/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui.widget;

import io.github.zhengzhengyiyi.CommonEntryPoint;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.widget.AbstractEditor;
import io.github.zhengzhengyiyi.util.CodeSuggester;
import io.github.zhengzhengyiyi.util.JSONError;
import io.github.zhengzhengyiyi.util.JSONValidator;
import io.github.zhengzhengyiyi.util.TextSearchEngine;
import io.github.zhengzhengyiyi.util.highlighter.JsonSyntaxHighlighter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;

public class MultilineEditor
extends AbstractEditor {
    private final Font textRenderer;
    private final JsonSyntaxHighlighter highLighter = new JsonSyntaxHighlighter();
    private boolean isDraggingHorizontalScroll = false;
    private int dragStartX = 0;
    private int dragStartScrollOffset = 0;
    public String text = "";
    private int scrollOffset = 0;
    private int horizontalScrollOffset = 0;
    public static int maxVisibleLines = 10;
    private boolean editable = true;
    private Consumer<String> changedListener;
    private int cursorPosition = 0;
    private long lastCursorBlinkTime = 0L;
    private boolean cursorVisible = true;
    private String filename = "";
    public List<JSONError> currentErrors = new ArrayList<JSONError>();
    public JSONError hoveredError = null;
    private TextSearchEngine searchEngine = new TextSearchEngine();
    private boolean isSearching = false;
    public String searchQuery = "";
    public int lastCursorX = 0;
    private List<String> currentSuggestions = new ArrayList<String>();
    private int selectedSuggestion = -1;
    private boolean showSuggestions = false;
    private int maxLineWidth = 0;

    public MultilineEditor(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        this.textRenderer = Minecraft.getInstance().font;
        this.setFocused(false);
        new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(500L);
                        this.editable = !CommonEntryPoint.configManager.getConfig().readonly_mode;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        context.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        try {
            context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -16777216);
            String[] lines = this.text.split("\n", -1);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int maxVisibleLines = this.height / lineHeight;
            this.calculateMaxLineWidth(lines);
            if (this.isSearching && !this.searchQuery.isEmpty()) {
                this.renderSearchHighlights(context, lines, lineHeight, maxVisibleLines);
            }
            for (int i = 0; i < lines.length; ++i) {
                if (i < this.scrollOffset || i >= this.scrollOffset + maxVisibleLines) continue;
                int yPos = this.getY() + 4 + (i - this.scrollOffset) * lineHeight;
                String lineNum = String.valueOf(i + 1);
                context.drawString(this.textRenderer, lineNum, this.getX() + 2 - this.horizontalScrollOffset, yPos, -7829368, false);
                this.highLighter.drawHighlightedText(context, this.textRenderer, lines[i], this.getX() + 4 + 12 - this.horizontalScrollOffset, yPos, this.editable);
            }
            this.renderErrorUnderlines(context, lines, lineHeight, maxVisibleLines);
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                entrypoint.renderButton(context, mouseX, mouseY, delta);
            }
            if (this.isFocused() && this.editable) {
                long currentTime = Util.getNanos();
                if (currentTime - this.lastCursorBlinkTime > 500000000L) {
                    this.cursorVisible = !this.cursorVisible;
                    this.lastCursorBlinkTime = currentTime;
                }
                if (this.cursorVisible) {
                    int lineIndex = 0;
                    int xPos = this.getX() + 4 + 12;
                    int remaining = this.cursorPosition;
                    for (int i = 0; i < lines.length; ++i) {
                        if (remaining <= lines[i].length()) {
                            xPos += this.highLighter.getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                            lineIndex = i;
                            break;
                        }
                        remaining -= lines[i].length() + 1;
                    }
                    if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                        int yPos = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                        Objects.requireNonNull(this.textRenderer);
                        context.vLine(xPos - this.horizontalScrollOffset, yPos - 1, yPos + 9 + 1, -1);
                    }
                }
            }
            this.renderErrorTooltips(context, mouseX, mouseY, lines, lineHeight, maxVisibleLines);
            if (this.showSuggestions && !this.currentSuggestions.isEmpty()) {
                this.renderSuggestions(context, mouseX, mouseY);
            }
            this.renderScrollBars(context, lines.length, maxVisibleLines);
        }
        finally {
            context.disableScissor();
        }
    }

    private void calculateMaxLineWidth(String[] lines) {
        this.maxLineWidth = 0;
        for (String line : lines) {
            int lineWidth = this.highLighter.getTextWidth(this.textRenderer, line);
            this.maxLineWidth = Math.max(this.maxLineWidth, lineWidth);
        }
    }

    private void renderScrollBars(GuiGraphics context, int totalLines, int maxVisibleLines) {
        int scrollbarWidth = 5;
        if (totalLines > maxVisibleLines) {
            int scrollbarHeight = Math.max(20, (int)((float)this.height * (float)maxVisibleLines / (float)totalLines));
            int scrollbarY = this.getY() + (int)((float)(this.height - scrollbarHeight) * (float)this.scrollOffset / (float)(totalLines - maxVisibleLines));
            context.fill(this.getX() + this.width - scrollbarWidth, this.getY(), this.getX() + this.width, this.getY() + this.height, -11184811);
            context.fill(this.getX() + this.width - scrollbarWidth + 1, scrollbarY, this.getX() + this.width - 1, scrollbarY + scrollbarHeight, -4473925);
        }
        if (this.maxLineWidth > this.width - 20) {
            int visibleWidth = this.width - 20;
            int scrollbarHeight = 5;
            int scrollbarX = this.getX() + (int)((float)(this.width - scrollbarWidth) * (float)this.horizontalScrollOffset / (float)(this.maxLineWidth - visibleWidth));
            int scrollbarY = this.getY() + this.height - scrollbarHeight;
            context.fill(this.getX(), this.getY() + this.height - scrollbarHeight, this.getX() + this.width, this.getY() + this.height, -11184811);
            context.fill(scrollbarX, scrollbarY, scrollbarX + Math.max(20, (int)((float)this.width * (float)visibleWidth / (float)this.maxLineWidth)), scrollbarY + scrollbarHeight, -4473925);
        }
    }

    private void renderSearchHighlights(GuiGraphics context, String[] lines, int lineHeight, int maxVisibleLines) {
        this.searchEngine.setScrollOffset(this.scrollOffset);
        int currentLineStart = 0;
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line = lines[lineIndex];
            if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                int yPos = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                int xBase = this.getX() + 4 + 12 - this.horizontalScrollOffset;
                for (int matchPos : this.searchEngine.matchPositions) {
                    int matchEndInLine;
                    int matchInLine;
                    if (matchPos < currentLineStart || matchPos >= currentLineStart + line.length() || (matchInLine = matchPos - currentLineStart) >= (matchEndInLine = Math.min(matchInLine + this.searchQuery.length(), line.length()))) continue;
                    String beforeMatch = line.substring(0, matchInLine);
                    String matchText = line.substring(matchInLine, matchEndInLine);
                    int xStart = xBase + this.textRenderer.width(beforeMatch);
                    int highlightWidth = this.textRenderer.width(matchText);
                    Objects.requireNonNull(this.textRenderer);
                    int yStart = yPos + 9 - 1;
                    boolean isCurrentMatch = matchPos == this.searchEngine.getCurrentMatchPosition();
                    int color = isCurrentMatch ? 1728042752 : 0x66FFFF00;
                    context.fill(xStart, yStart, xStart + highlightWidth, yStart + 2, color);
                }
            }
            currentLineStart += line.length() + 1;
        }
    }

    private void renderErrorTooltips(GuiGraphics context, int mouseX, int mouseY, String[] lines, int lineHeight, int maxVisibleLines) {
        this.hoveredError = null;
        if (this.isMouseOver(mouseX, mouseY)) {
            for (JSONError error : this.currentErrors) {
                if (!this.isMouseOverError(mouseX, mouseY, error, lines, lineHeight, maxVisibleLines)) continue;
                this.hoveredError = error;
                String tooltip = "Line " + error.lineNumber + ", Col " + error.columnNumber + ": " + error.message;
                context.setTooltipForNextFrame(this.textRenderer, (Component)Component.literal((String)tooltip), mouseX, mouseY);
                break;
            }
        }
    }

    private void renderSuggestions(GuiGraphics context, int mouseX, int mouseY) {
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        String[] lines = this.text.split("\n", -1);
        int lineIndex = 0;
        int xPos = this.getX() + 4 + 12 - this.horizontalScrollOffset;
        int remaining = this.cursorPosition;
        for (int i = 0; i < lines.length; ++i) {
            if (remaining <= lines[i].length()) {
                xPos += this.highLighter.getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                lineIndex = i;
                break;
            }
            remaining -= lines[i].length() + 1;
        }
        int n = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
        Objects.requireNonNull(this.textRenderer);
        int yPos = n + 9;
        if (yPos + Math.min(this.currentSuggestions.size(), 5) * lineHeight > this.getY() + this.height) {
            yPos = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight - Math.min(this.currentSuggestions.size(), 5) * lineHeight;
        }
        int suggestionHeight = Math.min(this.currentSuggestions.size(), 5) * lineHeight;
        int suggestionWidth = 200;
        context.fill(xPos, yPos, xPos + suggestionWidth, yPos + suggestionHeight, -13421773);
        int startIndex = Math.max(0, Math.min(this.selectedSuggestion - 2, this.currentSuggestions.size() - 5));
        int endIndex = Math.min(startIndex + 5, this.currentSuggestions.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int itemY = yPos + (i - startIndex) * lineHeight;
            if (i == this.selectedSuggestion) {
                context.fill(xPos, itemY, xPos + suggestionWidth, itemY + lineHeight, -11184811);
            }
            context.drawString(this.textRenderer, this.currentSuggestions.get(i), xPos + 2, itemY + 2, -1, false);
        }
    }

    private boolean isMouseOverError(int mouseX, int mouseY, JSONError error, String[] lines, int lineHeight, int maxVisibleLines) {
        int yPos;
        int lineIndex = error.lineNumber - 1;
        if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines && mouseY >= (yPos = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight)) {
            Objects.requireNonNull(this.textRenderer);
            if (mouseY <= yPos + 9) {
                int errorEndInLine;
                String line = lines[lineIndex];
                int errorStartInLine = Math.min(error.startPosition - this.getLineStart(error.startPosition), line.length());
                if (errorStartInLine < (errorEndInLine = Math.min(error.endPosition - this.getLineStart(error.startPosition), line.length()))) {
                    String beforeError = line.substring(0, errorStartInLine);
                    int xStart = this.getX() + 4 + this.textRenderer.width(beforeError) - this.horizontalScrollOffset;
                    int xEnd = xStart + this.textRenderer.width(line.substring(errorStartInLine, errorEndInLine));
                    return mouseX >= xStart && mouseX <= xEnd;
                }
            }
        }
        return false;
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        double mouseY;
        if (this.showSuggestions) {
            this.hideSuggestions();
            return true;
        }
        double mouseX = click.x();
        if (this.isMouseOverHorizontalScrollBar(mouseX, mouseY = click.y())) {
            this.isDraggingHorizontalScroll = true;
            this.dragStartX = (int)mouseX;
            this.dragStartScrollOffset = this.horizontalScrollOffset;
            return true;
        }
        if (this.showSuggestions && this.isMouseOverSuggestion(mouseX, mouseY) && this.selectedSuggestion >= 0 && this.selectedSuggestion < this.currentSuggestions.size()) {
            this.insertSuggestion(this.currentSuggestions.get(this.selectedSuggestion));
            this.hideSuggestions();
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY) && this.editable) {
            this.setFocused(true);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int clickedY = (int)mouseY - (this.getY() + 4);
            int lineIndex = Mth.clamp((int)(clickedY / lineHeight + this.scrollOffset), (int)0, (int)(this.text.split("\n", -1).length - 1));
            String[] lines = this.text.split("\n", -1);
            String line = lines[lineIndex];
            int clickedX = (int)mouseX - (this.getX() + 4 + 12) + this.horizontalScrollOffset;
            int charIndex = this.highLighter.getCharIndexFromTokens(this.textRenderer, line, clickedX);
            int newPosition = 0;
            for (int i = 0; i < lineIndex; ++i) {
                newPosition += lines[i].length() + 1;
            }
            this.cursorPosition = Mth.clamp((int)(newPosition += charIndex), (int)0, (int)this.text.length());
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                InteractionResult result = entrypoint.onMouseDown((int)Math.round(mouseX), (int)Math.round(mouseY));
                if (result != InteractionResult.FAIL) continue;
                return true;
            }
            this.updateSuggestions();
            return true;
        }
        this.setFocused(false);
        this.hideSuggestions();
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (this.showSuggestions && this.isMouseOverSuggestion(mouseX, mouseY)) {
            this.selectedSuggestion = amount < 0.0 ? Math.min(this.currentSuggestions.size() - 1, this.selectedSuggestion + 1) : Math.max(0, this.selectedSuggestion - 1);
            return true;
        }
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int maxLines = this.text.split("\n", -1).length;
        int maxVisibleLines = this.height / lineHeight;
        int newScrollOffset = this.scrollOffset - (int)Math.signum(amount);
        this.scrollOffset = Mth.clamp((int)newScrollOffset, (int)0, (int)Math.max(0, maxLines - maxVisibleLines));
        for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
            entrypoint.onMouseScroll();
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.mouseScrolled(mouseX, mouseY, verticalAmount);
    }

    private boolean isMouseOverHorizontalScrollBar(double mouseX, double mouseY) {
        if (this.maxLineWidth <= this.width - 20) {
            return false;
        }
        int scrollbarHeight = 5;
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)(this.getY() + this.height - scrollbarHeight) && mouseY <= (double)(this.getY() + this.height);
    }

    public boolean keyPressed(KeyEvent input) {
        if (!this.editable) {
            return false;
        }
        if (!CommonEntryPoint.configManager.getConfig().doSuggestions) {
            this.showSuggestions = false;
        }
        for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
            InteractionResult result = entrypoint.onType(input.input(), input.scancode(), input.modifiers());
            if (result != InteractionResult.FAIL) continue;
            return true;
        }
        int keyCode = input.input();
        int scanCode = input.scancode();
        int modifiers = input.modifiers();
        if (keyCode == 259) {
            if (this.cursorPosition > 0) {
                this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                --this.cursorPosition;
                this.onTextChanged();
                this.updateCursorX();
                this.updateSuggestions();
            }
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.cursorPosition < this.text.length()) {
                this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                this.onTextChanged();
                this.updateCursorX();
                this.updateSuggestions();
            }
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (this.showSuggestions && keyCode != 44 && keyCode != 261) {
            if (keyCode == 265) {
                this.selectedSuggestion = Math.max(0, this.selectedSuggestion - 1);
                return true;
            }
            if (keyCode == 264) {
                this.selectedSuggestion = Math.min(this.currentSuggestions.size() - 1, this.selectedSuggestion + 1);
                return true;
            }
            if ((keyCode == 257 || keyCode == 258) && this.selectedSuggestion >= 0 && this.selectedSuggestion < this.currentSuggestions.size()) {
                this.insertSuggestion(this.currentSuggestions.get(this.selectedSuggestion));
                this.hideSuggestions();
                return true;
            }
            if (keyCode == 256) {
                this.hideSuggestions();
                return true;
            }
        }
        if (keyCode == 263) {
            this.cursorPosition = Mth.clamp((int)(this.cursorPosition - 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            this.hideSuggestions();
            return true;
        }
        if (keyCode == 262) {
            this.cursorPosition = Mth.clamp((int)(this.cursorPosition + 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            this.hideSuggestions();
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 268) {
            this.cursorPosition = this.getLineStart(this.cursorPosition);
            this.updateCursorX();
            this.hideSuggestions();
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 269) {
            this.cursorPosition = this.getLineEnd(this.cursorPosition);
            this.updateCursorX();
            this.hideSuggestions();
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 265) {
            if (!this.showSuggestions) {
                int prevLineEnd;
                int lineStart = this.getLineStart(this.cursorPosition);
                int currentX = this.cursorPosition - lineStart;
                int n = prevLineEnd = lineStart > 0 ? this.getLineEnd(lineStart - 1) : -1;
                if (prevLineEnd != -1) {
                    int prevLineStart = this.getLineStart(prevLineEnd);
                    int prevLineLength = prevLineEnd - prevLineStart;
                    int newX = Math.min(currentX, prevLineLength);
                    this.cursorPosition = prevLineStart + newX;
                }
                this.updateCursorX();
                for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                    entrypoint.onType(keyCode, scanCode, modifiers);
                }
            }
            return true;
        }
        if (keyCode == 264) {
            if (!this.showSuggestions) {
                int nextLineStart;
                int lineEnd = this.getLineEnd(this.cursorPosition);
                int currentX = this.cursorPosition - this.getLineStart(this.cursorPosition);
                int n = nextLineStart = lineEnd < this.text.length() ? lineEnd + 1 : -1;
                if (nextLineStart != -1) {
                    int nextLineEnd = this.getLineEnd(nextLineStart);
                    int nextLineLength = nextLineEnd - nextLineStart;
                    int newX = Math.min(currentX, nextLineLength);
                    this.cursorPosition = nextLineStart + newX;
                }
                this.updateCursorX();
                for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                    entrypoint.onType(keyCode, scanCode, modifiers);
                }
            }
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.text = this.text.substring(0, this.cursorPosition) + "\n" + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            this.hideSuggestions();
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        return false;
    }

    public boolean charTyped(CharacterEvent input) {
        if (!this.isFocused() || !this.editable) {
            return false;
        }
        if (!CommonEntryPoint.configManager.getConfig().doSuggestions) {
            this.showSuggestions = false;
        }
        for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
            InteractionResult result = entrypoint.onCharTyped(input);
            if (result != InteractionResult.FAIL) continue;
            return true;
        }
        if (input.isAllowedChatCharacter()) {
            String chr = input.codepointAsString();
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            if (!(chr.equals(",") || chr.equals("\n") || chr.equals("\r"))) {
                this.updateSuggestions();
            } else {
                this.hideSuggestions();
            }
            for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
                entrypoint.onType(input.codepoint(), 0, input.modifiers());
            }
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        this.defaultButtonNarrationText(builder);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.cursorPosition = Mth.clamp((int)this.cursorPosition, (int)0, (int)this.text.length());
        this.onTextChanged();
        this.updateCursorX();
        this.hideSuggestions();
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    private void onTextChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.text);
        }
        this.validateJSON();
    }

    private void renderErrorUnderlines(GuiGraphics context, String[] lines, int lineHeight, int maxVisibleLines) {
        for (JSONError error : this.currentErrors) {
            int x;
            int lineIndex = error.lineNumber - 1;
            if (lineIndex < this.scrollOffset || lineIndex >= this.scrollOffset + maxVisibleLines) continue;
            int yPos = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
            String line = lines[lineIndex];
            int lineStartPosition = this.calculateLineStartPosition(lineIndex, lines);
            int errorStartInLine = Math.min(error.startPosition - lineStartPosition, line.length());
            int errorEndInLine = Math.min(error.endPosition - lineStartPosition, line.length());
            if (errorStartInLine < 0 || errorStartInLine >= errorEndInLine || errorEndInLine > line.length()) continue;
            String visibleLine = line.substring(0, line.length());
            String beforeError = visibleLine.substring(0, errorStartInLine);
            String errorText = visibleLine.substring(errorStartInLine, errorEndInLine);
            int textStartX = this.getX() + 4 + 12;
            int beforeErrorWidth = this.highLighter.getTextWidth(this.textRenderer, beforeError);
            int errorWidth = this.highLighter.getTextWidth(this.textRenderer, errorText);
            int xStart = textStartX + beforeErrorWidth - this.horizontalScrollOffset;
            if (xStart >= this.getX() && xStart < this.getX() + this.width && errorWidth > 0) {
                for (int i = 0; i < errorWidth; i += 3) {
                    int x2 = xStart + i;
                    if (x2 >= this.getX() + this.width || i + 2 > errorWidth) continue;
                    context.hLine(x2, x2 + 2, yPos, -65536);
                }
                continue;
            }
            if (errorWidth != 0 || (x = textStartX + beforeErrorWidth - this.horizontalScrollOffset) < this.getX() || x >= this.getX() + this.width) continue;
            context.hLine(x, x + 5, yPos, -65536);
        }
    }

    private int calculateLineStartPosition(int lineIndex, String[] lines) {
        int position = 0;
        for (int i = 0; i < lineIndex; ++i) {
            position += lines[i].length() + 1;
        }
        return position;
    }

    public void validateJSON() {
        this.currentErrors = JSONValidator.validateJSON(this.text);
    }

    private void updateCursorX() {
        int lineStart = this.getLineStart(this.cursorPosition);
        String currentLine = this.text.substring(lineStart, this.cursorPosition);
        this.lastCursorX = this.textRenderer.width(currentLine);
        int visibleWidth = this.width - 20;
        if (this.lastCursorX > this.horizontalScrollOffset + visibleWidth) {
            this.horizontalScrollOffset = this.lastCursorX - visibleWidth + 10;
        } else if (this.lastCursorX < this.horizontalScrollOffset) {
            this.horizontalScrollOffset = Math.max(0, this.lastCursorX - 10);
        }
    }

    private int getLineStart(int pos) {
        int start = this.text.lastIndexOf(10, pos - 1) + 1;
        return start;
    }

    private int getLineEnd(int pos) {
        int end = this.text.indexOf(10, pos);
        if (end == -1) {
            end = this.text.length();
        }
        return end;
    }

    @Override
    public void insertTextAtCursor(String text) {
        this.text = this.text.substring(0, this.cursorPosition) + text + this.text.substring(this.cursorPosition);
        this.cursorPosition += text.length();
        this.onTextChanged();
        this.updateCursorX();
        this.hideSuggestions();
    }

    @Override
    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public void setCursorPosition(int position) {
        this.cursorPosition = Mth.clamp((int)position, (int)0, (int)this.text.length());
        this.updateCursorX();
        this.hideSuggestions();
    }

    public void setFileName(String v) {
        this.filename = v;
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public void startSearch(String query) {
        this.searchQuery = query;
        this.isSearching = true;
        this.searchEngine.search(query, this.text);
        if (this.searchEngine.hasMatches()) {
            this.scrollToCurrentMatch();
        }
        this.hideSuggestions();
    }

    @Override
    public void findNext() {
        if (this.isSearching && this.searchEngine.hasMatches()) {
            this.searchEngine.nextMatch();
            this.scrollToCurrentMatch();
        }
    }

    @Override
    public void findPrevious() {
        if (this.isSearching && this.searchEngine.hasMatches()) {
            this.searchEngine.previousMatch();
            this.scrollToCurrentMatch();
        }
    }

    private void scrollToCurrentMatch() {
        int lineIndex;
        Integer matchPos = this.searchEngine.getCurrentMatchPosition();
        if (matchPos != null && ((lineIndex = this.getLineIndex(matchPos)) < this.scrollOffset || lineIndex >= this.scrollOffset + maxVisibleLines)) {
            this.scrollOffset = Math.max(0, lineIndex - 2);
        }
    }

    @Override
    public void endSearch() {
        this.isSearching = false;
        this.searchQuery = "";
        this.searchEngine.clear();
    }

    private int getLineIndex(int position) {
        int line = 0;
        for (int i = 0; i < position && i < this.text.length(); ++i) {
            if (this.text.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    @Override
    public boolean isSearching() {
        return this.isSearching;
    }

    @Override
    public int getSearchMatchCount() {
        return this.searchEngine.getMatchCount();
    }

    @Override
    public int getCurrentSearchIndex() {
        return this.searchEngine.getCurrentMatchIndex() + 1;
    }

    private void updateSuggestions() {
        if (!CommonEntryPoint.configManager.getConfig().doSuggestions) {
            this.hideSuggestions();
            return;
        }
        this.currentSuggestions = CodeSuggester.suggestForPosition(this.text, this.cursorPosition);
        this.showSuggestions = !this.currentSuggestions.isEmpty();
        this.selectedSuggestion = this.showSuggestions ? 0 : -1;
    }

    private void hideSuggestions() {
        this.showSuggestions = false;
        this.currentSuggestions.clear();
        this.selectedSuggestion = -1;
    }

    private void insertSuggestion(String suggestion) {
        this.insertTextAtCursor(suggestion);
        this.hideSuggestions();
    }

    private boolean isMouseOverSuggestion(double mouseX, double mouseY) {
        if (!this.showSuggestions) {
            return false;
        }
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        String[] lines = this.text.split("\n", -1);
        int lineIndex = 0;
        int xPos = this.getX() + 4 + 12 - this.horizontalScrollOffset;
        int remaining = this.cursorPosition;
        for (int i = 0; i < lines.length; ++i) {
            if (remaining <= lines[i].length()) {
                xPos += this.highLighter.getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                lineIndex = i;
                break;
            }
            remaining -= lines[i].length() + 1;
        }
        int n = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
        Objects.requireNonNull(this.textRenderer);
        int yPos = n + 9;
        int suggestionHeight = Math.min(this.currentSuggestions.size(), 5) * lineHeight;
        int suggestionWidth = 200;
        return mouseX >= (double)xPos && mouseX <= (double)(xPos + suggestionWidth) && mouseY >= (double)yPos && mouseY <= (double)(yPos + suggestionHeight);
    }

    public boolean mouseDragged(MouseButtonEvent click, double offsetX, double offsetY) {
        if (this.isDraggingHorizontalScroll) {
            int visibleWidth = this.width - 20;
            int dragDeltaX = (int)click.x() - this.dragStartX;
            int scrollRange = Math.max(0, this.maxLineWidth - visibleWidth);
            if (scrollRange > 0) {
                float scrollRatio = (float)dragDeltaX / (float)this.width;
                int newScrollOffset = this.dragStartScrollOffset + (int)(scrollRatio * (float)scrollRange);
                this.horizontalScrollOffset = Mth.clamp((int)newScrollOffset, (int)0, (int)scrollRange);
            }
            return true;
        }
        return super.mouseDragged(click, offsetX, offsetY);
    }

    public boolean mouseReleased(MouseButtonEvent click) {
        if (this.isDraggingHorizontalScroll) {
            this.isDraggingHorizontalScroll = false;
            return true;
        }
        return super.mouseReleased(click);
    }
}

