/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.MalformedJsonException;
import io.github.zhengzhengyiyi.util.JSONError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONValidator {
    public static List<JSONError> validateJSON(String text) {
        ArrayList<JSONError> errors = new ArrayList<JSONError>();
        if (text == null || text.trim().isEmpty()) {
            return errors;
        }
        try {
            JsonParser.parseString((String)text);
        }
        catch (Exception e) {
            JSONValidator.parseException(e, text, errors);
        }
        JSONValidator.checkBasicErrors(text, errors);
        JSONValidator.checkStructuralErrors(text, errors);
        return errors;
    }

    private static void parseException(Exception e, String text, List<JSONError> errors) {
        String message = e.getMessage();
        Pattern pattern = Pattern.compile("at line (\\d+) column (\\d+)");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            int line = Integer.parseInt(matcher.group(1));
            int column = Integer.parseInt(matcher.group(2));
            int position = JSONValidator.findPosition(text, line, column);
            String errorMsg = JSONValidator.getCleanErrorMessage(e);
            int startPos = JSONValidator.findPreciseErrorStart(text, position, errorMsg);
            int endPos = JSONValidator.findPreciseErrorEnd(text, position, errorMsg);
            int actualLine = JSONValidator.calculateLineNumber(text, startPos) + 1;
            int actualColumn = JSONValidator.calculateColumnNumber(text, startPos);
            errors.add(new JSONError(actualLine, actualColumn, errorMsg, startPos, endPos));
        } else {
            JSONValidator.checkManualErrorDetection(text, errors);
        }
    }

    private static String getCleanErrorMessage(Exception e) {
        if (e instanceof JsonSyntaxException) {
            String msg = e.getMessage();
            if (msg.contains("Expected")) {
                if (msg.contains("BEGIN_OBJECT")) {
                    return "Expected '{'";
                }
                if (msg.contains("END_OBJECT")) {
                    return "Expected '}'";
                }
                if (msg.contains("BEGIN_ARRAY")) {
                    return "Expected '['";
                }
                if (msg.contains("END_ARRAY")) {
                    return "Expected ']'";
                }
                if (msg.contains("COLON")) {
                    return "Expected ':'";
                }
                if (msg.contains("COMMA")) {
                    return "Expected ','";
                }
                return "Expected value";
            }
            if (msg.contains("Unterminated")) {
                return "Unterminated string";
            }
            if (msg.contains("Malformed")) {
                return "Malformed JSON";
            }
            return "Syntax error";
        }
        if (e instanceof MalformedJsonException) {
            return "Malformed JSON";
        }
        return "JSON error";
    }

    private static int findPosition(String text, int line, int column) {
        int currentLine = 1;
        int currentColumn = 1;
        for (int i = 0; i < text.length(); ++i) {
            if (currentLine == line && currentColumn == column) {
                return i;
            }
            if (text.charAt(i) == '\n') {
                ++currentLine;
                currentColumn = 1;
                continue;
            }
            ++currentColumn;
        }
        return Math.max(0, Math.min(text.length() - 1, 0));
    }

    private static int calculateLineNumber(String text, int position) {
        int line = 0;
        for (int i = 0; i < position && i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    private static int calculateColumnNumber(String text, int position) {
        int column = 1;
        for (int i = 0; i < position && i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                column = 1;
                continue;
            }
            ++column;
        }
        return column;
    }

    private static int findPreciseErrorStart(String text, int position, String errorMsg) {
        if (errorMsg.contains("Expected '{'") || errorMsg.contains("Expected '}'")) {
            return JSONValidator.findBraceBoundary(text, position, true);
        }
        if (errorMsg.contains("Expected '['") || errorMsg.contains("Expected ']'")) {
            return JSONValidator.findBracketBoundary(text, position, true);
        }
        if (errorMsg.contains("Expected ':'")) {
            return JSONValidator.findColonBoundary(text, position, true);
        }
        if (errorMsg.contains("Expected ','")) {
            return JSONValidator.findCommaBoundary(text, position, true);
        }
        if (errorMsg.contains("Unterminated string")) {
            return JSONValidator.findStringStart(text, position);
        }
        return JSONValidator.findTokenBoundary(text, position, true);
    }

    private static int findPreciseErrorEnd(String text, int position, String errorMsg) {
        if (errorMsg.contains("Expected '{'") || errorMsg.contains("Expected '}'")) {
            return JSONValidator.findBraceBoundary(text, position, false);
        }
        if (errorMsg.contains("Expected '['") || errorMsg.contains("Expected ']'")) {
            return JSONValidator.findBracketBoundary(text, position, false);
        }
        if (errorMsg.contains("Expected ':'")) {
            return JSONValidator.findColonBoundary(text, position, false);
        }
        if (errorMsg.contains("Expected ','")) {
            return JSONValidator.findCommaBoundary(text, position, false);
        }
        if (errorMsg.contains("Unterminated string")) {
            return JSONValidator.findStringEnd(text, position);
        }
        return JSONValidator.findTokenBoundary(text, position, false);
    }

    private static int findBraceBoundary(String text, int position, boolean isStart) {
        if (isStart) {
            for (int i = position; i >= 0; --i) {
                if (i != 0 && text.charAt(i) != '{' && text.charAt(i) != '}' && text.charAt(i) != '[' && text.charAt(i) != ']' && text.charAt(i) != ',' && text.charAt(i) != '\n') continue;
                return i;
            }
        } else {
            for (int i = position; i < text.length(); ++i) {
                if (i != text.length() - 1 && text.charAt(i) != '{' && text.charAt(i) != '}' && text.charAt(i) != '[' && text.charAt(i) != ']' && text.charAt(i) != ',' && text.charAt(i) != '\n') continue;
                return i;
            }
        }
        return position;
    }

    private static int findBracketBoundary(String text, int position, boolean isStart) {
        return JSONValidator.findBraceBoundary(text, position, isStart);
    }

    private static int findColonBoundary(String text, int position, boolean isStart) {
        if (isStart) {
            for (int i = position; i >= 0; --i) {
                if (i != 0 && text.charAt(i) != ':' && text.charAt(i) != '\"' && text.charAt(i) != ',' && text.charAt(i) != '\n') continue;
                return i;
            }
        } else {
            for (int i = position; i < text.length(); ++i) {
                if (i != text.length() - 1 && text.charAt(i) != ':' && text.charAt(i) != '\"' && text.charAt(i) != ',' && text.charAt(i) != '\n') continue;
                return i;
            }
        }
        return position;
    }

    private static int findCommaBoundary(String text, int position, boolean isStart) {
        return JSONValidator.findColonBoundary(text, position, isStart);
    }

    private static int findStringStart(String text, int position) {
        for (int i = position; i >= 0; --i) {
            if (text.charAt(i) != '\"') continue;
            return i;
        }
        return position;
    }

    private static int findStringEnd(String text, int position) {
        for (int i = position; i < text.length(); ++i) {
            if (text.charAt(i) != '\"' || i != 0 && text.charAt(i - 1) == '\\') continue;
            return i;
        }
        return text.length() - 1;
    }

    private static int findTokenBoundary(String text, int position, boolean isStart) {
        char c;
        int end;
        if (isStart) {
            char c2;
            int start;
            for (start = position; start > 0 && (c2 = text.charAt(start - 1)) != '\n' && c2 != '{' && c2 != '[' && c2 != ',' && c2 != ':' && c2 != '}' && c2 != ']'; --start) {
            }
            return Math.max(start, 0);
        }
        for (end = position; end < text.length() - 1 && (c = text.charAt(end + 1)) != '\n' && c != '}' && c != ']' && c != ',' && c != ':' && c != '{' && c != '['; ++end) {
        }
        return Math.min(end, text.length() - 1);
    }

    private static void checkManualErrorDetection(String text, List<JSONError> errors) {
        JSONValidator.checkQuotes(text, errors);
        JSONValidator.checkBrackets(text, errors);
        JSONValidator.checkCommas(text, errors);
    }

    private static void checkBasicErrors(String text, List<JSONError> errors) {
        String trimmed = text.trim();
        if (trimmed.startsWith(",")) {
            errors.add(new JSONError(1, 1, "Unexpected comma", 0, 0));
        }
        if (trimmed.endsWith(",")) {
            int line = JSONValidator.calculateLineNumber(text, text.length() - 1) + 1;
            int column = JSONValidator.calculateColumnNumber(text, text.length() - 1);
            errors.add(new JSONError(line, column, "Trailing comma", text.length() - 1, text.length() - 1));
        }
    }

    private static void checkStructuralErrors(String text, List<JSONError> errors) {
        Stack<Character> stack = new Stack<Character>();
        Stack<Integer> positions = new Stack<Integer>();
        HashMap<Character, Character> pairs = new HashMap<Character, Character>();
        pairs.put(Character.valueOf('}'), Character.valueOf('{'));
        pairs.put(Character.valueOf(']'), Character.valueOf('['));
        boolean inString = false;
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!inString) {
                if (c == '{' || c == '[') {
                    stack.push(Character.valueOf(c));
                    positions.push(i);
                } else if (c == '}' || c == ']') {
                    if (stack.isEmpty()) {
                        line = JSONValidator.calculateLineNumber(text, i) + 1;
                        column = JSONValidator.calculateColumnNumber(text, i);
                        errors.add(new JSONError(line, column, "Unexpected closing bracket", i, i));
                    } else if (stack.peek() != pairs.get(Character.valueOf(c))) {
                        line = JSONValidator.calculateLineNumber(text, i) + 1;
                        column = JSONValidator.calculateColumnNumber(text, i);
                        errors.add(new JSONError(line, column, "Bracket mismatch", i, i));
                    } else {
                        stack.pop();
                        positions.pop();
                    }
                }
            }
            if (c == '\"' && !escaped) {
                inString = !inString;
            }
            escaped = c == '\\' && !escaped;
        }
        while (!stack.isEmpty()) {
            int pos = (Integer)positions.pop();
            char bracket = ((Character)stack.pop()).charValue();
            String msg = bracket == '{' ? "Unclosed curly brace" : "Unclosed square bracket";
            int line = JSONValidator.calculateLineNumber(text, pos) + 1;
            int column = JSONValidator.calculateColumnNumber(text, pos);
            errors.add(new JSONError(line, column, msg, pos, pos));
        }
    }

    private static void checkQuotes(String text, List<JSONError> errors) {
        boolean inString = false;
        int quoteStart = -1;
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (c == '\"' && !escaped) {
                if (!inString) {
                    inString = true;
                    quoteStart = i;
                } else {
                    inString = false;
                    quoteStart = -1;
                }
            }
            if (!escaped) continue;
            escaped = false;
        }
        if (inString && quoteStart != -1) {
            int line = JSONValidator.calculateLineNumber(text, quoteStart) + 1;
            int column = JSONValidator.calculateColumnNumber(text, quoteStart);
            errors.add(new JSONError(line, column, "Unterminated string", quoteStart, text.length() - 1));
        }
    }

    private static void checkBrackets(String text, List<JSONError> errors) {
    }

    private static void checkCommas(String text, List<JSONError> errors) {
    }
}

