/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.zhengzhengyiyi.config.ConfigData;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config", "editor_config.json");
    private static ConfigData config = new ConfigData();
    private static FileTime lastModifiedTime;
    private static ScheduledExecutorService fileWatcher;
    private static Logger LOGGER;

    public static void init() {
    }

    public static void load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String jsonContent = new String(Files.readAllBytes(CONFIG_PATH));
                config = (ConfigData)GSON.fromJson(jsonContent, ConfigData.class);
                lastModifiedTime = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0]);
            } else {
                ConfigManager.save();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config: " + e.getMessage());
            config = new ConfigData();
        }
        ConfigManager.startFileWatcher();
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String jsonContent = GSON.toJson((Object)config);
            Files.write(CONFIG_PATH, jsonContent.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            lastModifiedTime = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config: " + e.getMessage());
        }
    }

    private static void startFileWatcher() {
        if (fileWatcher != null) {
            fileWatcher.shutdown();
        }
        fileWatcher = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "Config File Watcher");
            thread.setDaemon(true);
            return thread;
        });
        fileWatcher.scheduleAtFixedRate(() -> {
            try {
                FileTime currentModifiedTime;
                if (Files.exists(CONFIG_PATH, new LinkOption[0]) && !(currentModifiedTime = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0])).equals(lastModifiedTime)) {
                    class_310.method_1551().execute(() -> new Thread(() -> {
                        ConfigManager.load();
                        LOGGER.info("Configuration reloaded due to external changes");
                    }).start());
                }
            }
            catch (Exception e) {
                LOGGER.error("File watcher error: " + e.getMessage());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public static ConfigData getConfig() {
        return config;
    }

    public static void shutdown() {
        if (fileWatcher != null) {
            fileWatcher.shutdown();
            try {
                if (!fileWatcher.awaitTermination(1L, TimeUnit.SECONDS)) {
                    fileWatcher.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                fileWatcher.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ConfigManager.class);
        ConfigManager.load();
    }
}

