/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class AutoBracketCompletionEntrypoint
implements ApiEntrypoint {
    private boolean enabled = true;
    private EditorScreen editor;
    private final Map<Character, Character> bracketPairs = new HashMap<Character, Character>();

    public AutoBracketCompletionEntrypoint() {
        this.initializeBracketPairs();
    }

    @Override
    public void init() {
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
    }

    @Override
    public void onEditerClose(EditorScreen editor) {
        this.editor = null;
    }

    @Override
    public class_1269 onMouseDown(int x, int y) {
        return class_1269.field_5812;
    }

    @Override
    public void onMouseScroll() {
    }

    @Override
    public class_1269 onType(int keyCode, int scanCode, int modifiers) {
        return class_1269.field_5811;
    }

    @Override
    public class_1269 onCharTyped(char chr, int modifiers) {
        if (!this.enabled || this.editor == null || this.editor.getTextWidget() == null) {
            return class_1269.field_5811;
        }
        if (this.bracketPairs.containsKey(Character.valueOf(chr))) {
            this.handleBracketCompletion(chr);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void initializeBracketPairs() {
        this.bracketPairs.put(Character.valueOf('('), Character.valueOf(')'));
        this.bracketPairs.put(Character.valueOf('['), Character.valueOf(']'));
        this.bracketPairs.put(Character.valueOf('{'), Character.valueOf('}'));
        this.bracketPairs.put(Character.valueOf('\"'), Character.valueOf('\"'));
        this.bracketPairs.put(Character.valueOf('\''), Character.valueOf('\''));
        this.bracketPairs.put(Character.valueOf('`'), Character.valueOf('`'));
    }

    private void handleBracketCompletion(char openingChar) {
        char closingChar = this.bracketPairs.get(Character.valueOf(openingChar)).charValue();
        String pair = String.valueOf(openingChar) + closingChar;
        this.editor.getTextWidget().insertTextAtCursor(pair);
        if (openingChar != closingChar) {
            int currentPos = this.editor.getTextWidget().getCursorPosition();
            this.editor.getTextWidget().setCursorPosition(currentPos - 1);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
    }
}

