/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui.widget;

import io.github.zhengzhengyiyi.ConfigEditorClient;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class MultilineEditorWidget
extends class_339 {
    private final class_327 textRenderer;
    private String text = "";
    private int scrollOffset = 0;
    private boolean editable = true;
    private Consumer<String> changedListener;
    private int cursorPosition = 0;
    private long lastCursorBlinkTime = 0L;
    private boolean cursorVisible = true;
    private int lastCursorX = 0;

    public MultilineEditorWidget(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
        this.textRenderer = class_310.method_1551().field_1772;
        this.method_25365(false);
        System.out.println(this.lastCursorX);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) {
            return;
        }
        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
        context.method_49601(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, -1);
        String[] lines = this.text.split("\n", -1);
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int maxVisibleLines = this.field_22759 / lineHeight;
        for (int i = 0; i < lines.length; ++i) {
            if (i < this.scrollOffset || i >= this.scrollOffset + maxVisibleLines) continue;
            int yPos = this.method_46427() + 4 + (i - this.scrollOffset) * lineHeight;
            context.method_51433(this.textRenderer, lines[i], this.method_46426() + 4, yPos, this.editable ? -1 : -8947849, false);
        }
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.renderButton(context, mouseX, mouseY, delta);
        }
        if (this.method_25370() && this.editable) {
            long currentTime = class_156.method_648();
            if (currentTime - this.lastCursorBlinkTime > 500000000L) {
                this.cursorVisible = !this.cursorVisible;
                this.lastCursorBlinkTime = currentTime;
            }
            if (this.cursorVisible) {
                int lineIndex = 0;
                int xPos = this.method_46426() + 4;
                int remaining = this.cursorPosition;
                for (int i = 0; i < lines.length; ++i) {
                    if (remaining <= lines[i].length()) {
                        xPos += this.textRenderer.method_1727(lines[i].substring(0, remaining));
                        lineIndex = i;
                        break;
                    }
                    remaining -= lines[i].length() + 1;
                }
                if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                    int yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                    Objects.requireNonNull(this.textRenderer);
                    context.method_51742(xPos, yPos - 1, yPos + 9 + 1, -1);
                }
            }
        }
        if (lines.length > maxVisibleLines) {
            int scrollbarHeight = Math.max(20, (int)((float)this.field_22759 * (float)maxVisibleLines / (float)lines.length));
            int scrollbarY = this.method_46427() + (int)((float)(this.field_22759 - scrollbarHeight) * (float)this.scrollOffset / (float)(lines.length - maxVisibleLines));
            context.method_25294(this.method_46426() + this.field_22758 - 5, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -11184811);
            context.method_25294(this.method_46426() + this.field_22758 - 4, scrollbarY, this.method_46426() + this.field_22758 - 1, scrollbarY + scrollbarHeight, -4473925);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && this.editable) {
            this.method_25365(true);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int clickedY = (int)mouseY - (this.method_46427() + 4);
            int lineIndex = class_3532.method_15340((int)(clickedY / lineHeight + this.scrollOffset), (int)0, (int)(this.text.split("\n", -1).length - 1));
            String[] lines = this.text.split("\n", -1);
            String line = lines[lineIndex];
            int clickedX = (int)mouseX - (this.method_46426() + 4);
            int charIndex = 0;
            int i = 1;
            while (i <= line.length()) {
                if (this.textRenderer.method_1727(line.substring(0, i)) > clickedX) {
                    charIndex = i - 1;
                    break;
                }
                charIndex = i++;
            }
            int newPosition = 0;
            for (int i2 = 0; i2 < lineIndex; ++i2) {
                newPosition += lines[i2].length() + 1;
            }
            this.cursorPosition = class_3532.method_15340((int)(newPosition += charIndex), (int)0, (int)this.text.length());
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onMouseDown((int)mouseX, (int)mouseY);
            }
            return true;
        }
        this.method_25365(false);
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int maxLines = this.text.split("\n", -1).length;
        int maxVisibleLines = this.field_22759 / lineHeight;
        int newScrollOffset = this.scrollOffset - (int)Math.signum(amount);
        this.scrollOffset = class_3532.method_15340((int)newScrollOffset, (int)0, (int)Math.max(0, maxLines - maxVisibleLines));
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onMouseScroll();
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.mouseScrolled(mouseX, mouseY, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        boolean controlDown = class_437.method_25441();
        if (controlDown) {
            if (keyCode == 86) {
                this.pasteFromClipboard();
                return true;
            }
            if (keyCode == 67) {
                this.copyToClipboard();
                return true;
            }
        }
        if (keyCode == 263) {
            this.cursorPosition = class_3532.method_15340((int)(this.cursorPosition - 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 262) {
            this.cursorPosition = class_3532.method_15340((int)(this.cursorPosition + 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 268) {
            this.cursorPosition = this.getLineStart(this.cursorPosition);
            this.updateCursorX();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 269) {
            this.cursorPosition = this.getLineEnd(this.cursorPosition);
            this.updateCursorX();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 265) {
            int prevLineEnd;
            int lineStart = this.getLineStart(this.cursorPosition);
            int currentX = this.cursorPosition - lineStart;
            int n = prevLineEnd = lineStart > 0 ? this.getLineEnd(lineStart - 1) : -1;
            if (prevLineEnd != -1) {
                int prevLineStart = this.getLineStart(prevLineEnd);
                int prevLineLength = prevLineEnd - prevLineStart;
                int newX = Math.min(currentX, prevLineLength);
                this.cursorPosition = prevLineStart + newX;
            }
            this.updateCursorX();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 264) {
            int nextLineStart;
            int lineEnd = this.getLineEnd(this.cursorPosition);
            int currentX = this.cursorPosition - this.getLineStart(this.cursorPosition);
            int n = nextLineStart = lineEnd < this.text.length() ? lineEnd + 1 : -1;
            if (nextLineStart != -1) {
                int nextLineEnd = this.getLineEnd(nextLineStart);
                int nextLineLength = nextLineEnd - nextLineStart;
                int newX = Math.min(currentX, nextLineLength);
                this.cursorPosition = nextLineStart + newX;
            }
            this.updateCursorX();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 259) {
            if (this.cursorPosition > 0) {
                this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                --this.cursorPosition;
                this.onTextChanged();
                this.updateCursorX();
            }
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.cursorPosition < this.text.length()) {
                this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                this.onTextChanged();
                this.updateCursorX();
            }
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.text = this.text.substring(0, this.cursorPosition) + "\n" + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        if (chr >= ' ' && chr != '\u007f') {
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(chr, 0, modifiers);
            }
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.cursorPosition = class_3532.method_15340((int)this.cursorPosition, (int)0, (int)this.text.length());
        this.onTextChanged();
        this.updateCursorX();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    private void onTextChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.text);
        }
    }

    private void updateCursorX() {
        int lineStart = this.getLineStart(this.cursorPosition);
        String currentLine = this.text.substring(lineStart, this.cursorPosition);
        this.lastCursorX = this.textRenderer.method_1727(currentLine);
    }

    private int getLineStart(int pos) {
        int start = this.text.lastIndexOf(10, pos - 1) + 1;
        return start;
    }

    private int getLineEnd(int pos) {
        int end = this.text.indexOf(10, pos);
        if (end == -1) {
            end = this.text.length();
        }
        return end;
    }

    private void copyToClipboard() {
        class_310.method_1551().field_1774.method_1455(this.text);
    }

    private void pasteFromClipboard() {
        String clipboardText = class_310.method_1551().field_1774.method_1460();
        if (clipboardText != null) {
            this.text = this.text.substring(0, this.cursorPosition) + clipboardText + this.text.substring(this.cursorPosition);
            this.cursorPosition += clipboardText.length();
            this.onTextChanged();
            this.updateCursorX();
        }
    }
}

