/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui.widget;

import io.github.zhengzhengyiyi.ConfigEditorClient;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.api.FileType;
import io.github.zhengzhengyiyi.config.ConfigManager;
import io.github.zhengzhengyiyi.util.CodeSuggester;
import io.github.zhengzhengyiyi.util.JSONError;
import io.github.zhengzhengyiyi.util.JSONValidator;
import io.github.zhengzhengyiyi.util.TextSearchEngine;
import io.github.zhengzhengyiyi.util.highlighter.HighLighter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class MultilineEditor
extends class_339 {
    private final class_327 textRenderer;
    private boolean isDraggingHorizontalScroll = false;
    private int dragStartX = 0;
    private int dragStartScrollOffset = 0;
    private String text = "";
    private int scrollOffset = 0;
    private int horizontalScrollOffset = 0;
    public static int maxVisibleLines = 10;
    private boolean editable = true;
    private FileType fileType = FileType.TXT;
    private Consumer<String> changedListener;
    private int cursorPosition = 0;
    private long lastCursorBlinkTime = 0L;
    private boolean cursorVisible = true;
    private String filename = "";
    public List<JSONError> currentErrors = new ArrayList<JSONError>();
    public JSONError hoveredError = null;
    private TextSearchEngine searchEngine = new TextSearchEngine();
    private boolean isSearching = false;
    public String searchQuery = "";
    public int lastCursorX = 0;
    private List<String> currentSuggestions = new ArrayList<String>();
    private int selectedSuggestion = -1;
    private boolean showSuggestions = false;
    private int maxLineWidth = 0;

    public FileType getFileTypeFromName(String fileName) {
        String lowerName = fileName.toLowerCase();
        for (FileType type : FileType.values()) {
            String extension = "." + type.getExtension();
            if (!lowerName.endsWith(extension)) continue;
            return type;
        }
        return FileType.UNKNOW;
    }

    public MultilineEditor(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
        this.textRenderer = class_310.method_1551().field_1772;
        this.method_25365(false);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            this.editable = !ConfigManager.getConfig().readonly_mode;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) {
            return;
        }
        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        try {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
            context.method_49601(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, -1);
            String[] lines = this.text.split("\n", -1);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int maxVisibleLines = this.field_22759 / lineHeight;
            this.calculateMaxLineWidth(lines);
            HighLighter highlighter = this.fileType.getHighLighter();
            if (this.isSearching && !this.searchQuery.isEmpty()) {
                this.renderSearchHighlights(context, lines, lineHeight, maxVisibleLines);
            }
            for (int i = 0; i < lines.length; ++i) {
                if (i < this.scrollOffset || i >= this.scrollOffset + maxVisibleLines) continue;
                int yPos = this.method_46427() + 4 + (i - this.scrollOffset) * lineHeight;
                String lineNum = String.valueOf(i + 1);
                context.method_51433(this.textRenderer, lineNum, this.method_46426() + 2 - this.horizontalScrollOffset, yPos, -7829368, false);
                highlighter.drawHighlightedText(context, this.textRenderer, lines[i], this.method_46426() + 4 + 12 - this.horizontalScrollOffset, yPos, this.editable);
            }
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.renderButton(context, mouseX, mouseY, delta);
            }
            if (this.method_25370() && this.editable) {
                long currentTime = class_156.method_648();
                if (currentTime - this.lastCursorBlinkTime > 500000000L) {
                    this.cursorVisible = !this.cursorVisible;
                    this.lastCursorBlinkTime = currentTime;
                }
                if (this.cursorVisible) {
                    int lineIndex = 0;
                    int xPos = this.method_46426() + 4 + 12;
                    int remaining = this.cursorPosition;
                    for (int i = 0; i < lines.length; ++i) {
                        if (remaining <= lines[i].length()) {
                            xPos += highlighter.getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                            lineIndex = i;
                            break;
                        }
                        remaining -= lines[i].length() + 1;
                    }
                    if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                        int yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                        Objects.requireNonNull(this.textRenderer);
                        context.method_25301(xPos - this.horizontalScrollOffset, yPos - 1, yPos + 9 + 1, -1);
                    }
                }
            }
            this.renderErrorTooltips(context, mouseX, mouseY, lines, lineHeight, maxVisibleLines);
            if (this.showSuggestions && !this.currentSuggestions.isEmpty()) {
                this.renderSuggestions(context, mouseX, mouseY);
            }
            this.renderScrollBars(context, lines.length, maxVisibleLines);
        }
        finally {
            context.method_44380();
        }
    }

    private void calculateMaxLineWidth(String[] lines) {
        this.maxLineWidth = 0;
        for (String line : lines) {
            int lineWidth = this.fileType.getHighLighter().getTextWidth(this.textRenderer, line);
            this.maxLineWidth = Math.max(this.maxLineWidth, lineWidth);
        }
    }

    private void renderScrollBars(class_332 context, int totalLines, int maxVisibleLines) {
        int scrollbarWidth = 5;
        if (totalLines > maxVisibleLines) {
            int scrollbarHeight = Math.max(20, (int)((float)this.field_22759 * (float)maxVisibleLines / (float)totalLines));
            int scrollbarY = this.method_46427() + (int)((float)(this.field_22759 - scrollbarHeight) * (float)this.scrollOffset / (float)(totalLines - maxVisibleLines));
            context.method_25294(this.method_46426() + this.field_22758 - scrollbarWidth, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -11184811);
            context.method_25294(this.method_46426() + this.field_22758 - scrollbarWidth + 1, scrollbarY, this.method_46426() + this.field_22758 - 1, scrollbarY + scrollbarHeight, -4473925);
        }
        if (this.maxLineWidth > this.field_22758 - 20) {
            int visibleWidth = this.field_22758 - 20;
            int scrollbarHeight = 5;
            int scrollbarX = this.method_46426() + (int)((float)(this.field_22758 - scrollbarWidth) * (float)this.horizontalScrollOffset / (float)(this.maxLineWidth - visibleWidth));
            int scrollbarY = this.method_46427() + this.field_22759 - scrollbarHeight;
            context.method_25294(this.method_46426(), this.method_46427() + this.field_22759 - scrollbarHeight, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -11184811);
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + Math.max(20, (int)((float)this.field_22758 * (float)visibleWidth / (float)this.maxLineWidth)), scrollbarY + scrollbarHeight, -4473925);
        }
    }

    private void renderSearchHighlights(class_332 context, String[] lines, int lineHeight, int maxVisibleLines) {
        this.searchEngine.setScrollOffset(this.scrollOffset);
        int currentLineStart = 0;
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line = lines[lineIndex];
            if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                int yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                int xBase = this.method_46426() + 4 + 12 - this.horizontalScrollOffset;
                for (int matchPos : this.searchEngine.matchPositions) {
                    int matchEndInLine;
                    int matchInLine;
                    if (matchPos < currentLineStart || matchPos >= currentLineStart + line.length() || (matchInLine = matchPos - currentLineStart) >= (matchEndInLine = Math.min(matchInLine + this.searchQuery.length(), line.length()))) continue;
                    String beforeMatch = line.substring(0, matchInLine);
                    String matchText = line.substring(matchInLine, matchEndInLine);
                    int xStart = xBase + this.textRenderer.method_1727(beforeMatch);
                    int highlightWidth = this.textRenderer.method_1727(matchText);
                    Objects.requireNonNull(this.textRenderer);
                    int yStart = yPos + 9 - 1;
                    boolean isCurrentMatch = matchPos == this.searchEngine.getCurrentMatchPosition();
                    int color = isCurrentMatch ? 1728042752 : 0x66FFFF00;
                    context.method_25294(xStart, yStart, xStart + highlightWidth, yStart + 2, color);
                }
            }
            currentLineStart += line.length() + 1;
        }
    }

    private void renderErrorTooltips(class_332 context, int mouseX, int mouseY, String[] lines, int lineHeight, int maxVisibleLines) {
        this.hoveredError = null;
        if (this.method_25405(mouseX, mouseY)) {
            for (JSONError error : this.currentErrors) {
                if (!this.isMouseOverError(mouseX, mouseY, error, lines, lineHeight, maxVisibleLines)) continue;
                this.hoveredError = error;
                String tooltip = "Line " + error.lineNumber + ", Col " + error.columnNumber + ": " + error.message;
                context.method_51438(this.textRenderer, (class_2561)class_2561.method_43470((String)tooltip), mouseX, mouseY);
                break;
            }
        }
    }

    private void renderSuggestions(class_332 context, int mouseX, int mouseY) {
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        String[] lines = this.text.split("\n", -1);
        int lineIndex = 0;
        int xPos = this.method_46426() + 4 + 12 - this.horizontalScrollOffset;
        int remaining = this.cursorPosition;
        for (int i = 0; i < lines.length; ++i) {
            if (remaining <= lines[i].length()) {
                xPos += this.fileType.getHighLighter().getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                lineIndex = i;
                break;
            }
            remaining -= lines[i].length() + 1;
        }
        int n = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
        Objects.requireNonNull(this.textRenderer);
        int yPos = n + 9;
        if (yPos + Math.min(this.currentSuggestions.size(), 5) * lineHeight > this.method_46427() + this.field_22759) {
            yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight - Math.min(this.currentSuggestions.size(), 5) * lineHeight;
        }
        int suggestionHeight = Math.min(this.currentSuggestions.size(), 5) * lineHeight;
        int suggestionWidth = 200;
        context.method_25294(xPos, yPos, xPos + suggestionWidth, yPos + suggestionHeight, -13421773);
        context.method_49601(xPos, yPos, suggestionWidth, suggestionHeight, -1);
        int startIndex = Math.max(0, Math.min(this.selectedSuggestion - 2, this.currentSuggestions.size() - 5));
        int endIndex = Math.min(startIndex + 5, this.currentSuggestions.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int itemY = yPos + (i - startIndex) * lineHeight;
            if (i == this.selectedSuggestion) {
                context.method_25294(xPos, itemY, xPos + suggestionWidth, itemY + lineHeight, -11184811);
            }
            context.method_51433(this.textRenderer, this.currentSuggestions.get(i), xPos + 2, itemY + 2, -1, false);
        }
    }

    private boolean isMouseOverError(int mouseX, int mouseY, JSONError error, String[] lines, int lineHeight, int maxVisibleLines) {
        int yPos;
        int lineIndex = error.lineNumber - 1;
        if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines && mouseY >= (yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight)) {
            Objects.requireNonNull(this.textRenderer);
            if (mouseY <= yPos + 9) {
                int errorEndInLine;
                String line = lines[lineIndex];
                int errorStartInLine = Math.min(error.startPosition - this.getLineStart(error.startPosition), line.length());
                if (errorStartInLine < (errorEndInLine = Math.min(error.endPosition - this.getLineStart(error.startPosition), line.length()))) {
                    String beforeError = line.substring(0, errorStartInLine);
                    int xStart = this.method_46426() + 4 + this.textRenderer.method_1727(beforeError) - this.horizontalScrollOffset;
                    int xEnd = xStart + this.textRenderer.method_1727(line.substring(errorStartInLine, errorEndInLine));
                    return mouseX >= xStart && mouseX <= xEnd;
                }
            }
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.showSuggestions) {
            this.hideSuggestions();
            return true;
        }
        if (this.isMouseOverHorizontalScrollBar(mouseX, mouseY)) {
            this.isDraggingHorizontalScroll = true;
            this.dragStartX = (int)mouseX;
            this.dragStartScrollOffset = this.horizontalScrollOffset;
            return true;
        }
        if (this.showSuggestions && this.isMouseOverSuggestion(mouseX, mouseY) && this.selectedSuggestion >= 0 && this.selectedSuggestion < this.currentSuggestions.size()) {
            this.insertSuggestion(this.currentSuggestions.get(this.selectedSuggestion));
            this.hideSuggestions();
            return true;
        }
        if (this.method_25405(mouseX, mouseY) && this.editable) {
            this.method_25365(true);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int clickedY = (int)mouseY - (this.method_46427() + 4);
            int lineIndex = class_3532.method_15340((int)(clickedY / lineHeight + this.scrollOffset), (int)0, (int)(this.text.split("\n", -1).length - 1));
            String[] lines = this.text.split("\n", -1);
            String line = lines[lineIndex];
            int clickedX = (int)mouseX - (this.method_46426() + 4 + 12) + this.horizontalScrollOffset;
            int charIndex = this.fileType.getHighLighter().getCharIndexFromTokens(this.textRenderer, line, clickedX);
            int newPosition = 0;
            for (int i = 0; i < lineIndex; ++i) {
                newPosition += lines[i].length() + 1;
            }
            this.cursorPosition = class_3532.method_15340((int)(newPosition += charIndex), (int)0, (int)this.text.length());
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                class_1269 result = entrypoint.onMouseDown((int)Math.round(mouseX), (int)Math.round(mouseY));
                if (result != class_1269.field_5814) continue;
                return true;
            }
            this.updateSuggestions();
            return true;
        }
        this.method_25365(false);
        this.hideSuggestions();
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (this.showSuggestions && this.isMouseOverSuggestion(mouseX, mouseY)) {
            this.selectedSuggestion = amount < 0.0 ? Math.min(this.currentSuggestions.size() - 1, this.selectedSuggestion + 1) : Math.max(0, this.selectedSuggestion - 1);
            return true;
        }
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        boolean shiftDown = class_437.method_25442();
        if (shiftDown) {
            int visibleWidth = this.field_22758 - 20;
            int newHorizontalScroll = this.horizontalScrollOffset - (int)(amount * 20.0);
            this.horizontalScrollOffset = class_3532.method_15340((int)newHorizontalScroll, (int)0, (int)Math.max(0, this.maxLineWidth - visibleWidth));
            return true;
        }
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int maxLines = this.text.split("\n", -1).length;
        int maxVisibleLines = this.field_22759 / lineHeight;
        int newScrollOffset = this.scrollOffset - (int)Math.signum(amount);
        this.scrollOffset = class_3532.method_15340((int)newScrollOffset, (int)0, (int)Math.max(0, maxLines - maxVisibleLines));
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onMouseScroll();
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.mouseScrolled(mouseX, mouseY, verticalAmount);
    }

    private boolean isMouseOverHorizontalScrollBar(double mouseX, double mouseY) {
        if (this.maxLineWidth <= this.field_22758 - 20) {
            return false;
        }
        int scrollbarHeight = 5;
        return mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + this.field_22758) && mouseY >= (double)(this.method_46427() + this.field_22759 - scrollbarHeight) && mouseY <= (double)(this.method_46427() + this.field_22759);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        if (!ConfigManager.getConfig().doSuggestions) {
            this.showSuggestions = false;
        }
        for (ApiEntrypoint apiEntrypoint : ConfigEditorClient.ENTRYPOINTS) {
            class_1269 result = apiEntrypoint.onType(keyCode, scanCode, modifiers);
            if (result != class_1269.field_5814) continue;
            return true;
        }
        boolean controlDown = class_437.method_25441();
        if (this.showSuggestions && keyCode != 44 && keyCode != 261) {
            if (keyCode == 265) {
                this.selectedSuggestion = Math.max(0, this.selectedSuggestion - 1);
                return true;
            }
            if (keyCode == 264) {
                this.selectedSuggestion = Math.min(this.currentSuggestions.size() - 1, this.selectedSuggestion + 1);
                return true;
            }
            if ((keyCode == 257 || keyCode == 258) && this.selectedSuggestion >= 0 && this.selectedSuggestion < this.currentSuggestions.size()) {
                this.insertSuggestion(this.currentSuggestions.get(this.selectedSuggestion));
                this.hideSuggestions();
                return true;
            }
            if (keyCode == 256) {
                this.hideSuggestions();
                return true;
            }
        }
        if (controlDown) {
            if (keyCode == 86) {
                this.pasteFromClipboard();
                this.updateSuggestions();
                return true;
            }
            if (keyCode == 67) {
                this.copyToClipboard();
                return true;
            }
            if (keyCode == 32) {
                this.updateSuggestions();
                return true;
            }
        }
        if (keyCode == 263) {
            this.cursorPosition = class_3532.method_15340((int)(this.cursorPosition - 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            this.hideSuggestions();
            return true;
        }
        if (keyCode == 262) {
            this.cursorPosition = class_3532.method_15340((int)(this.cursorPosition + 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            this.hideSuggestions();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 268) {
            this.cursorPosition = this.getLineStart(this.cursorPosition);
            this.updateCursorX();
            this.hideSuggestions();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 269) {
            this.cursorPosition = this.getLineEnd(this.cursorPosition);
            this.updateCursorX();
            this.hideSuggestions();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 265) {
            if (!this.showSuggestions) {
                int prevLineEnd;
                int n = this.getLineStart(this.cursorPosition);
                int currentX = this.cursorPosition - n;
                int n2 = prevLineEnd = n > 0 ? this.getLineEnd(n - 1) : -1;
                if (prevLineEnd != -1) {
                    int prevLineStart = this.getLineStart(prevLineEnd);
                    int prevLineLength = prevLineEnd - prevLineStart;
                    int newX = Math.min(currentX, prevLineLength);
                    this.cursorPosition = prevLineStart + newX;
                }
                this.updateCursorX();
                for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                    entrypoint.onType(keyCode, scanCode, modifiers);
                }
            }
            return true;
        }
        if (keyCode == 264) {
            if (!this.showSuggestions) {
                int nextLineStart;
                int n = this.getLineEnd(this.cursorPosition);
                int currentX = this.cursorPosition - this.getLineStart(this.cursorPosition);
                int n3 = nextLineStart = n < this.text.length() ? n + 1 : -1;
                if (nextLineStart != -1) {
                    int nextLineEnd = this.getLineEnd(nextLineStart);
                    int nextLineLength = nextLineEnd - nextLineStart;
                    int newX = Math.min(currentX, nextLineLength);
                    this.cursorPosition = nextLineStart + newX;
                }
                this.updateCursorX();
                for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                    entrypoint.onType(keyCode, scanCode, modifiers);
                }
            }
            return true;
        }
        if (keyCode == 259) {
            if (this.cursorPosition > 0) {
                this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                --this.cursorPosition;
                this.onTextChanged();
                this.updateCursorX();
                this.updateSuggestions();
            }
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.cursorPosition < this.text.length()) {
                this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                this.onTextChanged();
                this.updateCursorX();
                this.updateSuggestions();
            }
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.text = this.text.substring(0, this.cursorPosition) + "\n" + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            this.hideSuggestions();
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        if (!ConfigManager.getConfig().doSuggestions) {
            this.showSuggestions = false;
        }
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            class_1269 result = entrypoint.onCharTyped(chr, modifiers);
            if (result != class_1269.field_5814) continue;
            return true;
        }
        if (chr >= ' ' && chr != '\u007f') {
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            if (chr != ',' && chr != '\n' && chr != '\r') {
                this.updateSuggestions();
            } else {
                this.hideSuggestions();
            }
            for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(chr, 0, modifiers);
            }
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.cursorPosition = class_3532.method_15340((int)this.cursorPosition, (int)0, (int)this.text.length());
        this.onTextChanged();
        this.updateCursorX();
        this.hideSuggestions();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    private void onTextChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.text);
        }
        this.validateJSON();
    }

    public void renderErrorUnderlines(class_332 context, String[] lines, int lineHeight, int maxVisibleLines) {
        for (JSONError error : this.currentErrors) {
            int errorEndInLine;
            int lineIndex = error.lineNumber - 1;
            if (lineIndex < this.scrollOffset || lineIndex >= this.scrollOffset + maxVisibleLines) continue;
            int yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
            String line = lines[lineIndex];
            int errorStartInLine = Math.min(error.startPosition - this.getLineStart(error.startPosition), line.length());
            if (errorStartInLine >= (errorEndInLine = Math.min(error.endPosition - this.getLineStart(error.startPosition), line.length()))) continue;
            String beforeError = line.substring(0, errorStartInLine);
            String errorText = line.substring(errorStartInLine, errorEndInLine);
            int xStart = this.method_46426() + 4 + this.textRenderer.method_1727(beforeError) - this.horizontalScrollOffset;
            int errorWidth = this.textRenderer.method_1727(errorText);
            for (int i = 0; i < errorWidth; i += 3) {
                int x = xStart + i;
                if (i + 2 > errorWidth) continue;
                Objects.requireNonNull(this.textRenderer);
                context.method_25292(x, x + 2 + 12, yPos + 9 + 1, -65536);
            }
        }
    }

    public void validateJSON() {
        this.currentErrors = JSONValidator.validateJSON(this.text);
    }

    private void updateCursorX() {
        int lineStart = this.getLineStart(this.cursorPosition);
        String currentLine = this.text.substring(lineStart, this.cursorPosition);
        this.lastCursorX = this.textRenderer.method_1727(currentLine);
        int visibleWidth = this.field_22758 - 20;
        if (this.lastCursorX > this.horizontalScrollOffset + visibleWidth) {
            this.horizontalScrollOffset = this.lastCursorX - visibleWidth + 10;
        } else if (this.lastCursorX < this.horizontalScrollOffset) {
            this.horizontalScrollOffset = Math.max(0, this.lastCursorX - 10);
        }
    }

    private int getLineStart(int pos) {
        int start = this.text.lastIndexOf(10, pos - 1) + 1;
        return start;
    }

    private int getLineEnd(int pos) {
        int end = this.text.indexOf(10, pos);
        if (end == -1) {
            end = this.text.length();
        }
        return end;
    }

    private void copyToClipboard() {
        class_310.method_1551().field_1774.method_1455(this.text);
    }

    private void pasteFromClipboard() {
        String clipboardText = class_310.method_1551().field_1774.method_1460();
        if (clipboardText != null) {
            this.text = this.text.substring(0, this.cursorPosition) + clipboardText + this.text.substring(this.cursorPosition);
            this.cursorPosition += clipboardText.length();
            this.onTextChanged();
            this.updateCursorX();
        }
    }

    public void insertTextAtCursor(String text) {
        this.text = this.text.substring(0, this.cursorPosition) + text + this.text.substring(this.cursorPosition);
        this.cursorPosition += text.length();
        this.onTextChanged();
        this.updateCursorX();
        this.hideSuggestions();
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = class_3532.method_15340((int)position, (int)0, (int)this.text.length());
        this.updateCursorX();
        this.hideSuggestions();
    }

    public void setFileName(String v) {
        this.filename = v;
        this.fileType = this.getFileTypeFromName(v);
    }

    public String getFileName() {
        return this.filename;
    }

    public void startSearch(String query) {
        this.searchQuery = query;
        this.isSearching = true;
        this.searchEngine.search(query, this.text);
        if (this.searchEngine.hasMatches()) {
            this.scrollToCurrentMatch();
        }
        this.hideSuggestions();
    }

    public void findNext() {
        if (this.isSearching && this.searchEngine.hasMatches()) {
            this.searchEngine.nextMatch();
            this.scrollToCurrentMatch();
        }
    }

    public void findPrevious() {
        if (this.isSearching && this.searchEngine.hasMatches()) {
            this.searchEngine.previousMatch();
            this.scrollToCurrentMatch();
        }
    }

    private void scrollToCurrentMatch() {
        int lineIndex;
        Integer matchPos = this.searchEngine.getCurrentMatchPosition();
        if (matchPos != null && ((lineIndex = this.getLineIndex(matchPos)) < this.scrollOffset || lineIndex >= this.scrollOffset + maxVisibleLines)) {
            this.scrollOffset = Math.max(0, lineIndex - 2);
        }
    }

    public void endSearch() {
        this.isSearching = false;
        this.searchQuery = "";
        this.searchEngine.clear();
    }

    private int getLineIndex(int position) {
        int line = 0;
        for (int i = 0; i < position && i < this.text.length(); ++i) {
            if (this.text.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public int getSearchMatchCount() {
        return this.searchEngine.getMatchCount();
    }

    public int getCurrentSearchIndex() {
        return this.searchEngine.getCurrentMatchIndex() + 1;
    }

    private void updateSuggestions() {
        if (!ConfigManager.getConfig().doSuggestions) {
            this.hideSuggestions();
            return;
        }
        this.currentSuggestions = CodeSuggester.suggestForPosition(this.text, this.cursorPosition);
        this.showSuggestions = !this.currentSuggestions.isEmpty();
        this.selectedSuggestion = this.showSuggestions ? 0 : -1;
    }

    private void hideSuggestions() {
        this.showSuggestions = false;
        this.currentSuggestions.clear();
        this.selectedSuggestion = -1;
    }

    private void insertSuggestion(String suggestion) {
        this.insertTextAtCursor(suggestion);
        this.hideSuggestions();
    }

    private boolean isMouseOverSuggestion(double mouseX, double mouseY) {
        if (!this.showSuggestions) {
            return false;
        }
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        String[] lines = this.text.split("\n", -1);
        int lineIndex = 0;
        int xPos = this.method_46426() + 4 + 12 - this.horizontalScrollOffset;
        int remaining = this.cursorPosition;
        for (int i = 0; i < lines.length; ++i) {
            if (remaining <= lines[i].length()) {
                xPos += this.fileType.getHighLighter().getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                lineIndex = i;
                break;
            }
            remaining -= lines[i].length() + 1;
        }
        int n = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
        Objects.requireNonNull(this.textRenderer);
        int yPos = n + 9;
        int suggestionHeight = Math.min(this.currentSuggestions.size(), 5) * lineHeight;
        int suggestionWidth = 200;
        return mouseX >= (double)xPos && mouseX <= (double)(xPos + suggestionWidth) && mouseY >= (double)yPos && mouseY <= (double)(yPos + suggestionHeight);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingHorizontalScroll) {
            int visibleWidth = this.field_22758 - 20;
            int dragDeltaX = (int)mouseX - this.dragStartX;
            int scrollRange = Math.max(0, this.maxLineWidth - visibleWidth);
            if (scrollRange > 0) {
                float scrollRatio = (float)dragDeltaX / (float)this.field_22758;
                int newScrollOffset = this.dragStartScrollOffset + (int)(scrollRatio * (float)scrollRange);
                this.horizontalScrollOffset = class_3532.method_15340((int)newScrollOffset, (int)0, (int)scrollRange);
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isDraggingHorizontalScroll) {
            this.isDraggingHorizontalScroll = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }
}

