/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util;

import com.google.gson.JsonParser;
import io.github.zhengzhengyiyi.util.JSONError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class JSONValidator {
    public static List<JSONError> validateJSON(String text) {
        ArrayList<JSONError> errors = new ArrayList<JSONError>();
        if (text == null || text.trim().isEmpty()) {
            return errors;
        }
        try {
            JsonParser.parseString((String)text);
        }
        catch (Exception e) {
            JSONValidator.parseException(e, text, errors);
        }
        JSONValidator.checkBasicErrors(text, errors);
        return errors;
    }

    private static void parseException(Exception e, String text, List<JSONError> errors) {
        String message = e.getMessage();
        Pattern pattern = Pattern.compile("at line (\\d+) column (\\d+)");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            int line = Integer.parseInt(matcher.group(1));
            int column = Integer.parseInt(matcher.group(2));
            int position = JSONValidator.findPosition(text, line, column);
            int startPos = JSONValidator.findErrorStart(text, position);
            int endPos = JSONValidator.findErrorEnd(text, position);
            String errorMsg = JSONValidator.simplifyMessage(message);
            errors.add(new JSONError(line, column, errorMsg, startPos, endPos));
        } else {
            JSONValidator.checkManual(text, errors);
        }
    }

    private static int findPosition(String text, int line, int column) {
        int currentLine = 1;
        int currentColumn = 1;
        for (int i = 0; i < text.length(); ++i) {
            if (currentLine == line && currentColumn == column) {
                return i;
            }
            if (text.charAt(i) == '\n') {
                ++currentLine;
                currentColumn = 1;
                continue;
            }
            ++currentColumn;
        }
        return Math.min(text.length() - 1, 0);
    }

    private static int findErrorStart(String text, int position) {
        char c;
        int start;
        for (start = position; start > 0 && (c = text.charAt(start - 1)) != '\n' && c != '{' && c != '[' && c != ',' && c != ':'; --start) {
        }
        return Math.max(start, 0);
    }

    private static int findErrorEnd(String text, int position) {
        char c;
        int end;
        for (end = position; end < text.length() - 1 && (c = text.charAt(end + 1)) != '\n' && c != '}' && c != ']' && c != ',' && c != ':'; ++end) {
        }
        return Math.min(end, text.length() - 1);
    }

    private static String simplifyMessage(String message) {
        if (message.contains("Expected")) {
            return "Missing symbol or value";
        }
        if (message.contains("Unterminated")) {
            return "String not closed";
        }
        if (message.contains("Malformed")) {
            return "Format error";
        }
        if (message.contains("Expected value")) {
            return "Missing value";
        }
        return "Syntax error";
    }

    private static void checkManual(String text, List<JSONError> errors) {
        JSONValidator.checkQuotes(text, errors);
        JSONValidator.checkBrackets(text, errors);
        JSONValidator.checkCommas(text, errors);
    }

    private static void checkQuotes(String text, List<JSONError> errors) {
        boolean inString = false;
        int quoteStart = -1;
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (c == '\"' && !escaped) {
                if (!inString) {
                    inString = true;
                    quoteStart = i;
                } else {
                    inString = false;
                    quoteStart = -1;
                }
            }
            if (!escaped) continue;
            escaped = false;
        }
        if (inString && quoteStart != -1) {
            int line = JSONValidator.countLines(text, 0, quoteStart) + 1;
            int column = JSONValidator.getColumn(text, quoteStart);
            errors.add(new JSONError(line, column, "String not closed", quoteStart, text.length() - 1));
        }
    }

    private static void checkBrackets(String text, List<JSONError> errors) {
        Stack<Character> stack = new Stack<Character>();
        Stack<Integer> positions = new Stack<Integer>();
        HashMap<Character, Character> pairs = new HashMap<Character, Character>();
        pairs.put(Character.valueOf('}'), Character.valueOf('{'));
        pairs.put(Character.valueOf(']'), Character.valueOf('['));
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\"') {
                i = JSONValidator.skipString(text, i);
                continue;
            }
            if (c == '{' || c == '[') {
                stack.push(Character.valueOf(c));
                positions.push(i);
                continue;
            }
            if (c != '}' && c != ']') continue;
            if (stack.isEmpty()) {
                JSONValidator.addBracketError(text, i, "Extra bracket", errors);
                continue;
            }
            if (stack.peek() != pairs.get(Character.valueOf(c))) {
                JSONValidator.addBracketError(text, i, "Bracket mismatch", errors);
                continue;
            }
            stack.pop();
            positions.pop();
        }
        while (!stack.isEmpty()) {
            int pos = (Integer)positions.pop();
            char bracket = ((Character)stack.pop()).charValue();
            String name = bracket == '{' ? "Curly brace" : "Square bracket";
            JSONValidator.addBracketError(text, pos, name + " not closed", errors);
        }
    }

    private static int skipString(String text, int start) {
        boolean escaped = false;
        for (int i = start + 1; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (c == '\"' && !escaped) {
                return i;
            }
            if (!escaped) continue;
            escaped = false;
        }
        return text.length() - 1;
    }

    private static void addBracketError(String text, int position, String message, List<JSONError> errors) {
        int line = JSONValidator.countLines(text, 0, position) + 1;
        int column = JSONValidator.getColumn(text, position);
        errors.add(new JSONError(line, column, message, position, position));
    }

    private static void checkCommas(String text, List<JSONError> errors) {
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (!line.endsWith(",") || i != lines.length - 1) continue;
            int lineStart = JSONValidator.getLineStart(text, i);
            int commaPos = lineStart + lines[i].length() - 1;
            errors.add(new JSONError(i + 1, lines[i].length(), "Extra comma", commaPos, commaPos));
        }
    }

    private static void checkBasicErrors(String text, List<JSONError> errors) {
        if (text.trim().startsWith(",")) {
            errors.add(new JSONError(1, 1, "Cannot start with comma", 0, 0));
        }
    }

    private static int countLines(String text, int start, int end) {
        int lines = 0;
        for (int i = start; i < end && i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++lines;
        }
        return lines;
    }

    private static int getColumn(String text, int position) {
        int column = 1;
        for (int i = 0; i < position && i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                column = 1;
                continue;
            }
            ++column;
        }
        return column;
    }

    private static int getLineStart(String text, int lineIndex) {
        int currentLine = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (currentLine == lineIndex) {
                return i;
            }
            if (text.charAt(i) != '\n') continue;
            ++currentLine;
        }
        return 0;
    }
}

