/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.github.zhengzhengyiyi.ConfigEditorClient;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.widget.MultilineEditor;
import io.github.zhengzhengyiyi.util.BackupHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class EditorScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorScreen.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private List<Path> configFiles;
    private int selectedIndex = 0;
    private MultilineEditor multilineEditor;
    private boolean modified = false;
    private class_4185 saveButton;
    private class_4185 openFolderButton;
    private class_4185 backupButton;
    private String buffer = "";
    private class_342 searchField;
    private class_4185 searchNextButton;
    private class_4185 searchPrevButton;
    private boolean searchVisible = false;

    public EditorScreen() {
        super((class_2561)class_2561.method_43471((String)"configeditor.title"));
    }

    protected void method_25426() {
        super.method_25426();
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            this.configFiles = Files.list(configDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).collect(Collectors.toList());
            LOGGER.info("Found {} config files", (Object)this.configFiles.size());
        }
        catch (Exception e) {
            this.configFiles = new ArrayList<Path>();
            LOGGER.error("Failed to list config files", (Throwable)e);
        }
        int buttonY = 25;
        for (int i = 0; i < this.configFiles.size(); ++i) {
            int index = i;
            Path file = this.configFiles.get(i);
            String fileName = file.getFileName().toString();
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(fileName.length() > 20 ? fileName.substring(0, 17) + "..." : fileName)), button -> this.switchFile(index)).method_46434(10, buttonY, 130, 20).method_46431());
            buttonY += 23;
        }
        this.multilineEditor = new MultilineEditor(170, 20, this.field_22789 - 180, this.field_22790 - 60, (class_2561)class_2561.method_43471((String)"configeditor.editor"));
        this.multilineEditor.setChangedListener(text -> {
            if (!this.buffer.equals(text)) {
                this.modified = true;
                this.updateButtonStates();
            } else {
                this.modified = false;
            }
        });
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.save"), button -> this.saveFile()).method_46434(this.field_22789 - 170, this.field_22790 - 30, 80, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.backupButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.backup"), button -> BackupHelper.backupEntireConfigDirectory()).method_46434(0, 0, 70, 20).method_46431();
        this.method_37063((class_364)this.backupButton);
        this.openFolderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.openfolder"), button -> this.openConfigFolder()).method_46434(this.field_22789 - 80, this.field_22790 - 30, 70, 20).method_46431();
        this.method_37063((class_364)this.openFolderButton);
        class_4185 exitButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.close"), button -> this.method_25419()).method_46434(0, this.field_22790 - 25, 80, 20).method_46431();
        this.method_37063((class_364)exitButton);
        this.searchField = new class_342(this.field_22793, this.field_22789 - 250, 5, 120, 16, (class_2561)class_2561.method_43471((String)"configeditor.search.placeholder"));
        this.searchField.method_1862(false);
        this.method_37063((class_364)this.searchField);
        this.searchNextButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.search.next"), button -> {
            if (this.multilineEditor != null) {
                this.multilineEditor.findNext();
            }
        }).method_46434(this.field_22789 - 125, 5, 50, 16).method_46431();
        this.searchNextButton.field_22764 = false;
        this.method_37063((class_364)this.searchNextButton);
        this.searchPrevButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.search.prev"), button -> {
            if (this.multilineEditor != null) {
                this.multilineEditor.findPrevious();
            }
        }).method_46434(this.field_22789 - 70, 5, 50, 16).method_46431();
        this.searchPrevButton.field_22764 = false;
        this.method_37063((class_364)this.searchPrevButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.search"), button -> this.toggleSearch()).method_46434(this.field_22789 - 300, 5, 45, 16).method_46431());
        this.method_37063((class_364)this.multilineEditor);
        this.method_48265((class_364)this.multilineEditor);
        if (!this.configFiles.isEmpty()) {
            this.loadFile(this.selectedIndex);
        } else {
            this.multilineEditor.setText("{}");
            this.multilineEditor.setEditable(false);
            LOGGER.warn("No config files found in config directory");
        }
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onEditerOpen(this);
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.saveButton != null) {
            this.saveButton.field_22763 = this.modified && !this.configFiles.isEmpty();
        }
    }

    private void switchFile(int index) {
        if (this.modified) {
            class_410 confirmScreen = new class_410(result -> {
                if (result) {
                    this.saveFileAsync(() -> this.loadFile(index));
                    this.field_22787.method_1507(null);
                    this.field_22787.method_1507((class_437)this);
                } else {
                    this.loadFile(index);
                    this.field_22787.method_1507(null);
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), (class_2561)class_2561.method_43471((String)"configeditor.confirm.unsaved"));
            this.field_22787.method_1507((class_437)confirmScreen);
        } else {
            this.loadFile(index);
        }
    }

    private void loadFile(int index) {
        if (index < 0 || index >= this.configFiles.size()) {
            LOGGER.error("Invalid file index: {}", (Object)index);
            return;
        }
        this.selectedIndex = index;
        this.modified = false;
        Path file = this.configFiles.get(index);
        try {
            String content;
            this.buffer = content = Files.readString(file);
            JsonElement json = JsonParser.parseString((String)content);
            String formattedContent = GSON.toJson(json);
            this.multilineEditor.setText(formattedContent);
            LOGGER.info("Successfully loaded config file: {}", (Object)file.getFileName());
        }
        catch (Exception e) {
            String text = null;
            try {
                text = Files.readString(file);
            }
            catch (IOException ioexception) {
                LOGGER.error("tried to read file except IOException: ", (Object)ioexception.toString());
            }
            if (text == null) {
                LOGGER.error("Failed to load config file: {}", (Object)file.getFileName(), (Object)e);
                this.multilineEditor.setText("{}");
                this.multilineEditor.setEditable(false);
                this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.loadfailed"));
            }
            this.multilineEditor.setText(text);
        }
        this.updateButtonStates();
    }

    private void saveFile() {
        this.saveFileAsync(null);
    }

    private void saveFileAsync(Runnable callback) {
        if (this.configFiles.isEmpty()) {
            return;
        }
        Path file = this.configFiles.get(this.selectedIndex);
        String content = this.multilineEditor.getText();
        try {
            JsonParser.parseString((String)content);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Invalid JSON syntax in file: {}", (Object)file.getFileName());
            this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.invalidjson"));
            return;
        }
        new Thread(() -> {
            try {
                Files.writeString(file, (CharSequence)content, new OpenOption[0]);
                this.modified = false;
                LOGGER.info("Successfully saved config file: {}", (Object)file.getFileName());
                if (callback != null) {
                    this.field_22787.execute(callback);
                } else {
                    this.field_22787.execute(() -> {
                        this.updateButtonStates();
                        this.showMessagePopup((class_2561)class_2561.method_43471((String)"configeditor.message.saved"));
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to save config file: {}", (Object)file.getFileName(), (Object)e);
                this.field_22787.execute(() -> this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.savefailed")));
            }
        }).start();
    }

    private void openConfigFolder() {
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            LOGGER.info("Config folder location: {}", (Object)configDir);
            class_156.method_668().method_673(configDir.toUri());
        }
        catch (Exception e) {
            LOGGER.error("Failed to get config folder", (Throwable)e);
        }
    }

    private void showErrorPopup(class_2561 message) {
        this.field_22787.method_1507((class_437)new class_410(result -> {
            this.method_25419();
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), message));
    }

    private void showMessagePopup(class_2561 message) {
        this.field_22787.method_1507((class_437)new class_410(result -> {
            this.method_25419();
            this.field_22787.method_1507(null);
        }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), message));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (!this.configFiles.isEmpty()) {
            Object status = this.modified ? "* " + this.configFiles.get(this.selectedIndex).getFileName().toString() : this.configFiles.get(this.selectedIndex).getFileName().toString();
            context.method_51433(this.field_22793, (String)status, 170, 5, this.modified ? 0xFF5555 : 0xFFFFFF, false);
        }
    }

    public boolean method_25422() {
        if (this.modified) {
            class_410 confirmScreen = new class_410(result -> {
                if (result) {
                    this.saveFileAsync(() -> {
                        this.method_25419();
                        this.field_22787.method_1507(null);
                    });
                } else {
                    this.method_25419();
                    this.field_22787.method_1507(null);
                }
            }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), (class_2561)class_2561.method_43471((String)"configeditor.confirm.unsavedclose"));
            this.field_22787.method_1507((class_437)confirmScreen);
            return false;
        }
        return true;
    }

    public MultilineEditor getTextWidget() {
        return this.multilineEditor;
    }

    private void toggleSearch() {
        if (this.multilineEditor == null) {
            return;
        }
        this.searchVisible = !this.searchVisible;
        this.searchField.method_1862(this.searchVisible);
        this.searchNextButton.field_22764 = this.searchVisible;
        this.searchPrevButton.field_22764 = this.searchVisible;
        if (this.searchVisible) {
            this.method_25395((class_364)this.searchField);
            String searchText = this.searchField.method_1882();
            if (searchText != null && !searchText.trim().isEmpty()) {
                this.multilineEditor.startSearch(searchText);
            }
        } else {
            this.multilineEditor.endSearch();
        }
    }

    public void method_25419() {
        super.method_25419();
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onEditerClose(this);
        }
        LOGGER.info("Config editor closed");
    }

    public void method_25432() {
        super.method_25432();
        LOGGER.info("Config editor screen removed");
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.multilineEditor == null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.searchVisible) {
            if (keyCode == 257) {
                this.multilineEditor.startSearch(this.searchField.method_1882());
                return true;
            }
            if (keyCode == 256) {
                this.toggleSearch();
                return true;
            }
            if (keyCode == 292) {
                this.multilineEditor.findNext();
                return true;
            }
        }
        if (keyCode == 70 && EditorScreen.method_25441()) {
            this.toggleSearch();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

