/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class SyntaxHighlighter {
    public static int getCharIndexFromTokens(class_327 textRenderer, String line, int targetX) {
        if (line.isEmpty()) {
            return 0;
        }
        for (int i = 0; i <= line.length(); ++i) {
            int width = SyntaxHighlighter.getTextWidthUpToChar(textRenderer, line, i);
            if (width < targetX) continue;
            return i;
        }
        return line.length();
    }

    public static int getTextWidthUpToChar(class_327 textRenderer, String line, int charIndex) {
        if (line.isEmpty() || charIndex <= 0) {
            return 0;
        }
        List<Token> tokens = SyntaxHighlighter.tokenizeLine(line);
        int currentCharIndex = 0;
        int totalWidth = 0;
        for (Token token : tokens) {
            int tokenLength = token.content.length();
            if (currentCharIndex + tokenLength >= charIndex) {
                int charsInThisToken = charIndex - currentCharIndex;
                if (charsInThisToken <= 0) break;
                totalWidth += textRenderer.method_1727(token.content.substring(0, charsInThisToken));
                break;
            }
            totalWidth += textRenderer.method_1727(token.content);
            currentCharIndex += tokenLength;
        }
        return totalWidth;
    }

    public static void drawHighlightedText(class_332 context, class_327 textRenderer, String text, int x, int y, boolean editable) {
        if (text.isEmpty()) {
            return;
        }
        List<Token> tokens = SyntaxHighlighter.tokenizeLine(text);
        int currentX = x;
        for (Token token : tokens) {
            int color = SyntaxHighlighter.getTokenColor(token.type, editable);
            context.method_51433(textRenderer, token.content, currentX, y, color, false);
            currentX += textRenderer.method_1727(token.content);
        }
    }

    private static List<Token> tokenizeLine(String line) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (line.isEmpty()) {
            return tokens;
        }
        StringBuilder currentToken = new StringBuilder();
        boolean inString = false;
        boolean isKey = false;
        boolean expectValue = false;
        block10: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                if (!inString) {
                    inString = true;
                    tokens.add(new Token(TokenType.TEXT, "\""));
                    continue;
                }
                inString = false;
                if (currentToken.length() > 0) {
                    TokenType type = isKey ? TokenType.KEY : (expectValue ? TokenType.STRING_VALUE : TokenType.TEXT);
                    tokens.add(new Token(type, currentToken.toString()));
                    currentToken.setLength(0);
                    if (type == TokenType.KEY) {
                        expectValue = true;
                    }
                }
                tokens.add(new Token(TokenType.TEXT, "\""));
                continue;
            }
            if (inString) {
                currentToken.append(c);
                continue;
            }
            switch (c) {
                case '{': {
                    tokens.add(new Token(TokenType.BRACE_LEFT, "{"));
                    isKey = true;
                    expectValue = false;
                    continue block10;
                }
                case '}': {
                    tokens.add(new Token(TokenType.BRACE_RIGHT, "}"));
                    isKey = false;
                    expectValue = false;
                    continue block10;
                }
                case '[': {
                    tokens.add(new Token(TokenType.BRACKET_LEFT, "["));
                    isKey = false;
                    expectValue = false;
                    continue block10;
                }
                case ']': {
                    tokens.add(new Token(TokenType.BRACKET_RIGHT, "]"));
                    isKey = false;
                    expectValue = false;
                    continue block10;
                }
                case ':': {
                    tokens.add(new Token(TokenType.COLON, ":"));
                    isKey = false;
                    expectValue = true;
                    continue block10;
                }
                case ',': {
                    tokens.add(new Token(TokenType.COMMA, ","));
                    isKey = true;
                    expectValue = false;
                    continue block10;
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '^': 
                case '|': 
                case '~': {
                    tokens.add(new Token(TokenType.SYMBOL, String.valueOf(c)));
                    continue block10;
                }
                case '\t': 
                case ' ': {
                    tokens.add(new Token(TokenType.TEXT, String.valueOf(c)));
                    continue block10;
                }
                default: {
                    if (Character.isDigit(c) || c == '-' || c == '.') {
                        char nextChar;
                        currentToken.setLength(0);
                        currentToken.append(c);
                        while (i + 1 < line.length() && (Character.isDigit(nextChar = line.charAt(i + 1)) || nextChar == '.' || nextChar == 'e' || nextChar == 'E' || nextChar == '+' || nextChar == '-')) {
                            currentToken.append(nextChar);
                            ++i;
                        }
                        tokens.add(new Token(TokenType.NUMBER_VALUE, currentToken.toString()));
                        currentToken.setLength(0);
                        continue block10;
                    }
                    if (Character.isLetter(c) || c == '_') {
                        currentToken.setLength(0);
                        currentToken.append(c);
                        while (i + 1 < line.length() && (Character.isLetterOrDigit(line.charAt(i + 1)) || line.charAt(i + 1) == '_')) {
                            currentToken.append(line.charAt(++i));
                        }
                        String word = currentToken.toString();
                        TokenType type = TokenType.TEXT;
                        if ("true".equals(word) || "false".equals(word)) {
                            type = TokenType.BOOLEAN_VALUE;
                        } else if ("null".equals(word)) {
                            type = TokenType.NULL_VALUE;
                        }
                        tokens.add(new Token(type, word));
                        currentToken.setLength(0);
                        continue block10;
                    }
                    tokens.add(new Token(TokenType.TEXT, String.valueOf(c)));
                }
            }
        }
        if (inString && currentToken.length() > 0) {
            tokens.add(new Token(TokenType.STRING_VALUE, currentToken.toString()));
        }
        return tokens;
    }

    public static int getTextWidth(class_327 textRenderer, String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        List<Token> tokens = SyntaxHighlighter.tokenizeLine(text);
        int totalWidth = 0;
        for (Token token : tokens) {
            totalWidth += textRenderer.method_1727(token.content);
        }
        return totalWidth;
    }

    private static int getTokenColor(TokenType type, boolean editable) {
        int defaultColor = editable ? -1 : -5592406;
        switch (type.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return -256;
            }
            case 4: 
            case 5: {
                return -5592406;
            }
            case 11: {
                return -65281;
            }
            case 6: {
                return -10694413;
            }
            case 7: {
                return -1647756;
            }
            case 8: {
                return -5340673;
            }
            case 9: {
                return -11100970;
            }
            case 10: {
                return -448910;
            }
        }
        return defaultColor;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Token {
        public final TokenType type;
        public final String content;

        public Token(TokenType type, String content) {
            this.type = type;
            this.content = content;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TokenType {
        BRACE_LEFT,
        BRACE_RIGHT,
        BRACKET_LEFT,
        BRACKET_RIGHT,
        COLON,
        COMMA,
        KEY,
        STRING_VALUE,
        NUMBER_VALUE,
        BOOLEAN_VALUE,
        NULL_VALUE,
        SYMBOL,
        TEXT;

    }
}

