package io.github.zhengzhengyiyi;

import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.github.zhengzhengyiyi.addon.*;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.api.config.ConfigManager;
import io.github.zhengzhengyiyi.config.ModConfigData;
import io.github.zhengzhengyiyi.gui.*;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import java.util.List;
import java.nio.file.Paths;
import java.util.ArrayList;

public class ConfigEditorClient implements ClientModInitializer {
	public static String MOD_ID = "config_editor";
	public static ConfigManager<ModConfigData> configManager = new ConfigManager<>(Paths.get("config", "editor_config.json"), new ModConfigData(), ModConfigData.class);
	
	/**
	 * The keybinding for open the configure
	 * @see class_304
	 */
	public static class_304 key = KeyBindingHelper.registerKeyBinding(new class_304(
			"zhengzhengyiyi.key.open_gui",
			class_3675.class_307.field_1668,
			GLFW.GLFW_KEY_UNKNOWN,
			class_304.class_11900.field_62558
	));

	public static class_304 chatkey = KeyBindingHelper.registerKeyBinding(new class_304(
			"zhengzhengyiyi.key.open_chat_gui",
			class_3675.class_307.field_1668,
			GLFW.GLFW_KEY_UNKNOWN,
			class_304.class_11900.field_62558
	));

	/**
	 * The Logger for the other mod's entry point, usually for printing errors.
	 */
	public static Logger API_ENTRYPOINT_LOGGER = LoggerFactory.getLogger("api_entry_point");
	
	/**
	 * The Logger for the whole mod.
	 */
	public static Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
	
	/**
	 * 
	 * put every api entry point into a List
	 * 
	 * @see List
	 */
	public static final List<ApiEntrypoint> ENTRYPOINTS = new ArrayList<>();
	
	@Override
	public void onInitializeClient() {
		FabricLoader.getInstance()
        .getEntrypointContainers(MOD_ID, ApiEntrypoint.class)
        .forEach(entrypoint -> {
            String modId = entrypoint.getProvider().getMetadata().getId();
            try {
            	entrypoint.getEntrypoint().init();
            	
            	ENTRYPOINTS.add(entrypoint.getEntrypoint());
            } catch (Throwable e) {
            	API_ENTRYPOINT_LOGGER.error("Mod '{}' has a broken 'config_editor' entrypoint implementation.", modId, e);
            }
        });
		
		ENTRYPOINTS.add(new UndoRedoEntrypoint());
		ENTRYPOINTS.add(new TextStatsEntrypoint());
		ENTRYPOINTS.add(new DateTimeDisplayEntrypoint());
		ENTRYPOINTS.add(new AutoBracketCompletionEntrypoint());
		ENTRYPOINTS.add(new TextStatsEntrypoint());
		
		ClientTickEvents.END_CLIENT_TICK.register((client) -> {
			if (key.method_1434()) {
				client.method_1507(new EditorScreen());
			}
			if (chatkey.method_1434()) {
				client.method_1507(new AIChatScreen());
			}
		});
		
		ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            configManager.shutdown();
        });
		
//		testLanguageResources();
	}
	
	public static void testLanguageResources() {
		class_2561 test = class_2561.method_43471("configEditor.test");
		
		LOGGER.info("----------------test------------------");
		LOGGER.info(test.toString());
		LOGGER.info(test.method_54160());
		LOGGER.info("--------------test-ended--------------");
	}
}
