package io.github.zhengzhengyiyi.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.github.zhengzhengyiyi.api.*;

public class AIChatScreen extends class_437 {
    private class_342 inputField;
    private class_4185 sendButton;
    private class_4185 clearButton;
    private class_4185 settingsButton;
    private List<String> chatHistory;
    private List<String> userInputs;
    private boolean waitingForAIResponse = false;
    private boolean serverAvailable = false;
    private boolean checkingServer = true;
    private int chatScrollOffset = 0;
    private class_4185 scrollUpButton;
    private class_4185 scrollDownButton;
    
    private static Logger LOGGER = LoggerFactory.getLogger(AIChatScreen.class);
    
    private AiClient aiClient = new AiClient();

    public AIChatScreen() {
        super(class_2561.method_43470("AI Chat"));
        this.chatHistory = new ArrayList<>();
        this.userInputs = new ArrayList<>();
        
        chatHistory.add("AI: Hello! How can I help you today?");
        chatHistory.add("AI: I'm ready to assist you with anything!");
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        
        checkServerAvailability();
        
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelHeight = Math.min(300, this.field_22790 - 80);
        int panelX = (this.field_22789 - panelWidth) / 2;
        int panelY = (this.field_22790 - panelHeight) / 2 - 20;
        
        int inputY = panelY + panelHeight + 10;
        int inputWidth = panelWidth - 100;
        
        this.inputField = new class_342(this.field_22793, panelX, inputY, inputWidth, 20, class_2561.method_43470("Type your message..."));
        this.inputField.method_1880(256);
        this.inputField.method_1888(false);
        this.method_37063(this.inputField);
        
        this.sendButton = class_4185.method_46430(class_2561.method_43470("Send"), button -> sendMessage())
            .method_46434(panelX + inputWidth + 5, inputY, 45, 20)
            .method_46431();
        this.sendButton.field_22763 = false;
        this.method_37063(this.sendButton);
        
        this.clearButton = class_4185.method_46430(class_2561.method_43470("Clear"), button -> clearChat())
            .method_46434(panelX + panelWidth - 90, panelY - 25, 45, 20)
            .method_46431();
        this.method_37063(this.clearButton);
        
        this.settingsButton = class_4185.method_46430(class_2561.method_43470("Settings"), button -> openSettings())
            .method_46434(panelX + panelWidth - 45, panelY - 25, 45, 20)
            .method_46431();
        this.method_37063(this.settingsButton);
        
        this.scrollUpButton = class_4185.method_46430(class_2561.method_43470("↑"), button -> scrollUp())
            .method_46434(panelX + panelWidth - 20, panelY + 25, 16, 16)
            .method_46431();
        this.method_37063(this.scrollUpButton);
        
        this.scrollDownButton = class_4185.method_46430(class_2561.method_43470("↓"), button -> scrollDown())
            .method_46434(panelX + panelWidth - 20, panelY + panelHeight - 20, 16, 16)
            .method_46431();
        this.method_37063(this.scrollDownButton);
        
        this.method_48265(this.inputField);
        updateScrollButtons();
    }

    private void checkServerAvailability() {
        checkingServer = true;
        aiClient.checkServerStatus().thenAccept(available -> {
            serverAvailable = available;
            checkingServer = false;
            if (!serverAvailable) {
                chatHistory.add("System: Ollama server is not available. Please make sure Ollama is running on localhost:11434");
            }
            updateUIState();
        }).exceptionally(throwable -> {
            serverAvailable = false;
            checkingServer = false;
            chatHistory.add("System: Failed to check server status: " + throwable.getMessage());
            updateUIState();
            return null;
        });
    }

    private void updateUIState() {
        if (this.inputField != null) {
            this.inputField.method_1888(serverAvailable && !waitingForAIResponse);
        }
        if (this.sendButton != null) {
            this.sendButton.field_22763 = serverAvailable && !waitingForAIResponse && 
                (this.inputField != null && !this.inputField.method_1882().trim().isEmpty());
        }
        updateScrollButtons();
    }

    private void updateScrollButtons() {
        if (scrollUpButton != null && scrollDownButton != null) {
            scrollUpButton.field_22763 = chatScrollOffset > 0;
            scrollDownButton.field_22763 = chatScrollOffset < getMaxScrollOffset();
        }
    }

    private int getMaxScrollOffset() {
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelHeight = Math.min(300, this.field_22790 - 80);
        int maxVisibleLines = (panelHeight - 50) / 10;
        int totalLines = getTotalChatLines(panelWidth - 30);
        return Math.max(0, totalLines - maxVisibleLines);
    }

    private int getTotalChatLines(int maxWidth) {
        int totalLines = 0;
        for (String message : chatHistory) {
            List<String> wrappedLines = wrapText(message, maxWidth);
            totalLines += wrappedLines.size();
        }
        if (checkingServer || waitingForAIResponse) {
            totalLines += 1;
        }
        return totalLines;
    }

    private List<String> wrapText(String text, int maxWidth) {
        List<String> lines = new ArrayList<>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        
        for (String word : words) {
            String testLine = currentLine.length() > 0 ? currentLine + " " + word : word;
            if (this.field_22793.method_1727(testLine) <= maxWidth) {
                currentLine.append(currentLine.length() > 0 ? " " + word : word);
            } else {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder(word);
                } else {
                    lines.add(word);
                    currentLine = new StringBuilder();
                }
            }
        }
        
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        
        return lines;
    }

    private void scrollUp() {
        if (chatScrollOffset > 0) {
            chatScrollOffset--;
            updateScrollButtons();
        }
    }

    private void scrollDown() {
        if (chatScrollOffset < getMaxScrollOffset()) {
            chatScrollOffset++;
            updateScrollButtons();
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelHeight = Math.min(300, this.field_22790 - 80);
        int panelX = (this.field_22789 - panelWidth) / 2;
        int panelY = (this.field_22790 - panelHeight) / 2 - 20;
        
        if (mouseX >= panelX && mouseX <= panelX + panelWidth && 
            mouseY >= panelY && mouseY <= panelY + panelHeight) {
            if (verticalAmount < 0) {
                scrollDown();
            } else if (verticalAmount > 0) {
                scrollUp();
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }
    
    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
//    	super.renderBackground(context, mouseY, mouseY, delta);
    	
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelHeight = Math.min(300, this.field_22790 - 80);
        int panelX = (this.field_22789 - panelWidth) / 2;
        int panelY = (this.field_22790 - panelHeight) / 2 - 20;
        
        context.method_25294(panelX - 2, panelY - 2, panelX + panelWidth + 2, panelY + panelHeight + 2, 0xFF333333);
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, 0xFF1a1a1a);
        
        String title = "AI Chat Assistant";
        if (checkingServer) {
            title += " (Checking server...)";
        } else if (!serverAvailable) {
            title += " (Server Offline)";
        }
        context.method_51439(this.field_22793, class_2561.method_43470(title), this.field_22789 / 2 - 70, panelY - 15, 0xFFFFFF, false);
        
        context.method_51738(panelX + 5, panelX + panelWidth - 5, panelY + 20, 0xFF666666);
        
        int chatY = panelY + 35;
        int maxVisibleLines = (panelHeight - 50) / 12;
        int textAreaWidth = panelWidth - 30;
        
//        context.enableScissor(panelX + 5, panelY + 25, panelX + panelWidth - 5, panelY + panelHeight - 5);
//        
//        int currentLine = 0;
//        int visibleLineCount = 0;
//        
//        for (String message : chatHistory) {
//            List<String> wrappedLines = wrapText(message, textAreaWidth);
//            for (String line : wrappedLines) {
//                if (currentLine >= chatScrollOffset && visibleLineCount < maxVisibleLines) {
//                    int renderY = chatY + visibleLineCount * 12;
//                    int color = getMessageColor(message);
//                    context.drawText(this.textRenderer, Text.literal(line), panelX + 10, renderY, color, false);
//                    visibleLineCount++;
//                }
//                currentLine++;
//            }
//        }
//        
//        if ((checkingServer || waitingForAIResponse) && visibleLineCount < maxVisibleLines) {
//            int renderY = chatY + visibleLineCount * 12;
//            String loadingText = checkingServer ? 
//                "Checking server status" + ".".repeat((int)(System.currentTimeMillis() / 500 % 4)) :
//                "AI is thinking" + ".".repeat((int)(System.currentTimeMillis() / 500 % 4));
//            context.drawText(this.textRenderer, Text.literal(loadingText), panelX + 10, renderY, 0xFFFF00, false);
//        }
//        
//        context.disableScissor();
        
        drawScrollBar(context, panelX, panelY, panelWidth, panelHeight);
        
//        int inputY = panelY + panelHeight + 10;
        
//        context.fill(panelX - 1, inputY - 1, panelX + panelWidth - 99, inputY + 21, 0xFF555555);
//        context.fill(panelX, inputY, panelX + panelWidth - 100, inputY + 20, 0xFF2d2d2d);
        
//        if (!serverAvailable && this.inputField.getText().isEmpty()) {
//            context.drawText(this.textRenderer, Text.literal("Server unavailable - Read only mode"), panelX + 8, inputY + 6, 0xFF5555, false);
//        } else if (this.inputField.getText().isEmpty()) {
//            context.drawText(this.textRenderer, Text.literal("Type your message here..."), panelX + 8, inputY + 6, 0x888888, false);
//        }
        
        updateUIState();
        
        super.method_25394(context, mouseX, mouseY, delta);
        
        context.method_44379(panelX + 5, panelY + 25, panelX + panelWidth - 5, panelY + panelHeight - 5);
        
        int currentLine = 0;
        int visibleLineCount = 0;
        
        for (String message : chatHistory) {
            List<String> wrappedLines = wrapText(message, textAreaWidth);
            for (String line : wrappedLines) {
                if (currentLine >= chatScrollOffset && visibleLineCount < maxVisibleLines) {
                    int renderY = chatY + visibleLineCount * 12;
                    int color = getMessageColor(message);
                    context.method_51433(this.field_22793, line, panelX + 10, renderY, color, false);
//                    context.drawText(this.textRenderer, "test", 40, 40 - this.textRenderer.fontHeight - 10, color, true);
                    visibleLineCount++;
                }
                currentLine++;
            }
        }
        
        if ((checkingServer || waitingForAIResponse) && visibleLineCount < maxVisibleLines) {
            int renderY = chatY + visibleLineCount * 12;
            String loadingText = checkingServer ? 
                "Checking server status" + ".".repeat((int)(System.currentTimeMillis() / 500 % 4)) :
                "AI is thinking" + ".".repeat((int)(System.currentTimeMillis() / 500 % 4));
            context.method_51433(this.field_22793, loadingText, panelX + 10, renderY, 0xFFFFFFFF, false);
        }
        
        context.method_44380();
    }

    private int getMessageColor(String message) {
//        if (message.startsWith("AI:")) {
//            return 0x55FF55;
//        } else if (message.startsWith("You:")) {
//            return 0xAAAAFF;
//        } else if (message.startsWith("System:")) {
//            return 0xFFFF55;
//        } else {
//            return 0xFFFFFF;
//        }
    	return 0xFFFFFFFF;
    }

    private void drawScrollBar(class_332 context, int panelX, int panelY, int panelWidth, int panelHeight) {
        int scrollBarX = panelX + panelWidth - 18;
        int scrollBarY = panelY + 25;
        int scrollBarHeight = panelHeight - 30;
        
        context.method_25294(scrollBarX, scrollBarY, scrollBarX + 12, scrollBarY + scrollBarHeight, 0xFF444444);
        
        int maxScrollOffset = getMaxScrollOffset();
        if (maxScrollOffset > 0) {
            int thumbHeight = Math.max(20, (int)(scrollBarHeight * (1.0 / (maxScrollOffset + 1))));
            int thumbY = scrollBarY + (int)((scrollBarHeight - thumbHeight) * (chatScrollOffset / (double)maxScrollOffset));
            context.method_25294(scrollBarX, thumbY, scrollBarX + 12, thumbY + thumbHeight, 0xFF888888);
        }
    }

    @Override
    public boolean method_25404(class_11908 input) {
    	int keyCode = input.method_74228();
    	
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        
        if (keyCode == 257 && this.inputField.method_25370() && !waitingForAIResponse && serverAvailable) {
            this.sendMessage();
            return true;
        }
        
        return super.method_25404(input);
    }

    private void sendMessage() {
        String message = this.inputField.method_1882().trim();
        if (!message.isEmpty() && !waitingForAIResponse && serverAvailable) {
            userInputs.add(message);
            chatHistory.add("You: " + message);
            inputField.method_1852("");
            waitingForAIResponse = true;
            chatScrollOffset = getMaxScrollOffset();
            updateUIState();
            
            input(message);
        }
    }

    private void clearChat() {
        chatHistory.clear();
        userInputs.clear();
        chatScrollOffset = 0;
        if (serverAvailable) {
            chatHistory.add("AI: Chat cleared. How can I help you?");
        } else {
            chatHistory.add("System: Chat cleared. Server is still unavailable.");
        }
        updateUIState();
    }

    private void openSettings() {
        class_310.method_1551().method_1507(new EditorScreen());
    }

    private void input(String message) {
        aiClient.sendChatRequest("tinyllama:latest", message)
            .thenAccept(aiResponse -> {
                if (!aiResponse.isEmpty()) {
                    chatHistory.add("AI: " + aiResponse);
                    chatScrollOffset = getMaxScrollOffset();
                    LOGGER.info(aiResponse);
                }
                waitingForAIResponse = false;
                updateUIState();
            })
            .exceptionally(throwable -> {
                chatHistory.add("System: Error getting AI response: " + throwable.getMessage());
                chatScrollOffset = getMaxScrollOffset();
                waitingForAIResponse = false;
                updateUIState();
                return null;
            });
    }

    @Override
    public void method_25419() {
        super.method_25419();
    }
}
