/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import io.github.zhengzhengyiyi.gui.widget.GeneralMultilineEditor;
import io.github.zhengzhengyiyi.gui.widget.MultilineEditor;
import java.util.ArrayDeque;
import java.util.Deque;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_332;
import net.minecraft.class_339;

@Environment(value=EnvType.CLIENT)
public class UndoRedoEntrypoint
implements ApiEntrypoint {
    public boolean enabled = true;
    public EditorScreen editor;
    private Deque<String> undoStack = new ArrayDeque<String>();
    private Deque<String> redoStack = new ArrayDeque<String>();
    private String currentText = "";
    private boolean isUndoing = false;
    private boolean isRedoing = false;
    private static final int MAX_HISTORY = 100;

    @Override
    public void init() {
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
        class_339 textWidget = editor.getTextWidget();
        this.resetStacks();
        if (textWidget != null) {
            if (textWidget instanceof MultilineEditor) {
                this.currentText = ((MultilineEditor)textWidget).text;
            } else if (textWidget instanceof GeneralMultilineEditor) {
                this.currentText = ((GeneralMultilineEditor)textWidget).text;
            } else {
                LOGGER.error("can not find current text");
            }
            this.saveState();
        }
    }

    @Override
    public void onEditerClose(EditorScreen editor) {
        this.editor = null;
        this.resetStacks();
    }

    @Override
    public class_1269 onMouseDown(int x, int y) {
        return class_1269.field_5811;
    }

    @Override
    public void onMouseScroll() {
    }

    @Override
    public void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void saveState() {
        if (this.isUndoing || this.isRedoing) {
            return;
        }
        this.undoStack.push(this.currentText);
        if (this.undoStack.size() > 100) {
            ArrayDeque<String> newStack = new ArrayDeque<String>();
            int count = 0;
            for (String state : this.undoStack) {
                if (count++ >= 100) continue;
                newStack.add(state);
            }
            this.undoStack = newStack;
        }
        this.redoStack.clear();
    }

    private void resetStacks() {
        this.undoStack.clear();
        this.redoStack.clear();
        this.currentText = "";
    }

    public void clearHistory() {
        this.resetStacks();
    }

    public boolean canUndo() {
        return this.undoStack.size() > 1;
    }

    public boolean canRedo() {
        return !this.redoStack.isEmpty();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.resetStacks();
        }
    }
}

