/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import io.github.zhengzhengyiyi.api.AiClient;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class AIChatScreen
extends class_437 {
    private class_342 inputField;
    private class_4185 sendButton;
    private class_4185 clearButton;
    private class_4185 settingsButton;
    private List<String> chatHistory;
    private List<String> userInputs;
    private boolean waitingForAIResponse = false;
    private boolean serverAvailable = false;
    private boolean checkingServer = true;
    private int chatScrollOffset = 0;
    private class_4185 scrollUpButton;
    private class_4185 scrollDownButton;
    private static Logger LOGGER = LoggerFactory.getLogger(AIChatScreen.class);
    private AiClient aiClient = new AiClient();

    public AIChatScreen() {
        super((class_2561)class_2561.method_43470((String)"AI Chat"));
        this.chatHistory = new ArrayList<String>();
        this.userInputs = new ArrayList<String>();
        this.chatHistory.add("AI: Hello! How can I help you today?");
        this.chatHistory.add("AI: I'm ready to assist you with anything!");
    }

    protected void method_25426() {
        super.method_25426();
        this.checkServerAvailability();
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelHeight = Math.min(300, this.field_22790 - 80);
        int panelX = (this.field_22789 - panelWidth) / 2;
        int panelY = (this.field_22790 - panelHeight) / 2 - 20;
        int inputY = panelY + panelHeight + 10;
        int inputWidth = panelWidth - 100;
        this.inputField = new class_342(this.field_22793, panelX, inputY, inputWidth, 20, (class_2561)class_2561.method_43470((String)"Type your message..."));
        this.inputField.method_1880(256);
        this.inputField.method_1888(false);
        this.method_37063((class_364)this.inputField);
        this.sendButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Send"), button -> this.sendMessage()).method_46434(panelX + inputWidth + 5, inputY, 45, 20).method_46431();
        this.sendButton.field_22763 = false;
        this.method_37063((class_364)this.sendButton);
        this.clearButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear"), button -> this.clearChat()).method_46434(panelX + panelWidth - 90, panelY - 25, 45, 20).method_46431();
        this.method_37063((class_364)this.clearButton);
        this.settingsButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Settings"), button -> this.openSettings()).method_46434(panelX + panelWidth - 45, panelY - 25, 45, 20).method_46431();
        this.method_37063((class_364)this.settingsButton);
        this.scrollUpButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> this.scrollUp()).method_46434(panelX + panelWidth - 20, panelY + 25, 16, 16).method_46431();
        this.method_37063((class_364)this.scrollUpButton);
        this.scrollDownButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> this.scrollDown()).method_46434(panelX + panelWidth - 20, panelY + panelHeight - 20, 16, 16).method_46431();
        this.method_37063((class_364)this.scrollDownButton);
        this.method_48265((class_364)this.inputField);
        this.updateScrollButtons();
    }

    private void checkServerAvailability() {
        this.checkingServer = true;
        ((CompletableFuture)this.aiClient.checkServerStatus().thenAccept(available -> {
            this.serverAvailable = available;
            this.checkingServer = false;
            if (!this.serverAvailable) {
                this.chatHistory.add("System: Ollama server is not available. Please make sure Ollama is running on localhost:11434");
            }
            this.updateUIState();
        })).exceptionally(throwable -> {
            this.serverAvailable = false;
            this.checkingServer = false;
            this.chatHistory.add("System: Failed to check server status: " + throwable.getMessage());
            this.updateUIState();
            return null;
        });
    }

    private void updateUIState() {
        if (this.inputField != null) {
            this.inputField.method_1888(this.serverAvailable && !this.waitingForAIResponse);
        }
        if (this.sendButton != null) {
            this.sendButton.field_22763 = this.serverAvailable && !this.waitingForAIResponse && this.inputField != null && !this.inputField.method_1882().trim().isEmpty();
        }
        this.updateScrollButtons();
    }

    private void updateScrollButtons() {
        if (this.scrollUpButton != null && this.scrollDownButton != null) {
            this.scrollUpButton.field_22763 = this.chatScrollOffset > 0;
            this.scrollDownButton.field_22763 = this.chatScrollOffset < this.getMaxScrollOffset();
        }
    }

    private int getMaxScrollOffset() {
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelHeight = Math.min(300, this.field_22790 - 80);
        int maxVisibleLines = (panelHeight - 50) / 10;
        int totalLines = this.getTotalChatLines(panelWidth - 30);
        return Math.max(0, totalLines - maxVisibleLines);
    }

    private int getTotalChatLines(int maxWidth) {
        int totalLines = 0;
        for (String message : this.chatHistory) {
            List<String> wrappedLines = this.wrapText(message, maxWidth);
            totalLines += wrappedLines.size();
        }
        if (this.checkingServer || this.waitingForAIResponse) {
            ++totalLines;
        }
        return totalLines;
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() > 0 ? String.valueOf(currentLine) + " " + word : word;
            if (this.field_22793.method_1727(testLine) <= maxWidth) {
                currentLine.append((String)(currentLine.length() > 0 ? " " + word : word));
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
            currentLine = new StringBuilder();
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private void scrollUp() {
        if (this.chatScrollOffset > 0) {
            --this.chatScrollOffset;
            this.updateScrollButtons();
        }
    }

    private void scrollDown() {
        if (this.chatScrollOffset < this.getMaxScrollOffset()) {
            ++this.chatScrollOffset;
            this.updateScrollButtons();
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelHeight = Math.min(300, this.field_22790 - 80);
        int panelX = (this.field_22789 - panelWidth) / 2;
        int panelY = (this.field_22790 - panelHeight) / 2 - 20;
        if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelWidth) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelHeight)) {
            if (verticalAmount < 0.0) {
                this.scrollDown();
            } else if (verticalAmount > 0.0) {
                this.scrollUp();
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int panelWidth = Math.min(400, this.field_22789 - 40);
        int panelHeight = Math.min(300, this.field_22790 - 80);
        int panelX = (this.field_22789 - panelWidth) / 2;
        int panelY = (this.field_22790 - panelHeight) / 2 - 20;
        context.method_25294(panelX - 2, panelY - 2, panelX + panelWidth + 2, panelY + panelHeight + 2, -13421773);
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -15066598);
        Object title = "AI Chat Assistant";
        if (this.checkingServer) {
            title = (String)title + " (Checking server...)";
        } else if (!this.serverAvailable) {
            title = (String)title + " (Server Offline)";
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)title), this.field_22789 / 2 - 70, panelY - 15, 0xFFFFFF, false);
        context.method_51738(panelX + 5, panelX + panelWidth - 5, panelY + 20, -10066330);
        int chatY = panelY + 35;
        int maxVisibleLines = (panelHeight - 50) / 12;
        int textAreaWidth = panelWidth - 30;
        this.drawScrollBar(context, panelX, panelY, panelWidth, panelHeight);
        this.updateUIState();
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_44379(panelX + 5, panelY + 25, panelX + panelWidth - 5, panelY + panelHeight - 5);
        int currentLine = 0;
        int visibleLineCount = 0;
        for (String message : this.chatHistory) {
            List<String> wrappedLines = this.wrapText(message, textAreaWidth);
            for (String line : wrappedLines) {
                if (currentLine >= this.chatScrollOffset && visibleLineCount < maxVisibleLines) {
                    int renderY = chatY + visibleLineCount * 12;
                    int color = this.getMessageColor(message);
                    context.method_51433(this.field_22793, line, panelX + 10, renderY, color, false);
                    ++visibleLineCount;
                }
                ++currentLine;
            }
        }
        if ((this.checkingServer || this.waitingForAIResponse) && visibleLineCount < maxVisibleLines) {
            int renderY = chatY + visibleLineCount * 12;
            String loadingText = this.checkingServer ? "Checking server status" + ".".repeat((int)(System.currentTimeMillis() / 500L % 4L)) : "AI is thinking" + ".".repeat((int)(System.currentTimeMillis() / 500L % 4L));
            context.method_51433(this.field_22793, loadingText, panelX + 10, renderY, -1, false);
        }
        context.method_44380();
    }

    private int getMessageColor(String message) {
        return -1;
    }

    private void drawScrollBar(class_332 context, int panelX, int panelY, int panelWidth, int panelHeight) {
        int scrollBarX = panelX + panelWidth - 18;
        int scrollBarY = panelY + 25;
        int scrollBarHeight = panelHeight - 30;
        context.method_25294(scrollBarX, scrollBarY, scrollBarX + 12, scrollBarY + scrollBarHeight, -12303292);
        int maxScrollOffset = this.getMaxScrollOffset();
        if (maxScrollOffset > 0) {
            int thumbHeight = Math.max(20, (int)((double)scrollBarHeight * (1.0 / (double)(maxScrollOffset + 1))));
            int thumbY = scrollBarY + (int)((double)(scrollBarHeight - thumbHeight) * ((double)this.chatScrollOffset / (double)maxScrollOffset));
            context.method_25294(scrollBarX, thumbY, scrollBarX + 12, thumbY + thumbHeight, -7829368);
        }
    }

    public boolean method_25404(class_11908 input) {
        int keyCode = input.method_74228();
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (keyCode == 257 && this.inputField.method_25370() && !this.waitingForAIResponse && this.serverAvailable) {
            this.sendMessage();
            return true;
        }
        return super.method_25404(input);
    }

    private void sendMessage() {
        String message = this.inputField.method_1882().trim();
        if (!message.isEmpty() && !this.waitingForAIResponse && this.serverAvailable) {
            this.userInputs.add(message);
            this.chatHistory.add("You: " + message);
            this.inputField.method_1852("");
            this.waitingForAIResponse = true;
            this.chatScrollOffset = this.getMaxScrollOffset();
            this.updateUIState();
            this.input(message);
        }
    }

    private void clearChat() {
        this.chatHistory.clear();
        this.userInputs.clear();
        this.chatScrollOffset = 0;
        if (this.serverAvailable) {
            this.chatHistory.add("AI: Chat cleared. How can I help you?");
        } else {
            this.chatHistory.add("System: Chat cleared. Server is still unavailable.");
        }
        this.updateUIState();
    }

    private void openSettings() {
        class_310.method_1551().method_1507((class_437)new EditorScreen());
    }

    private void input(String message) {
        ((CompletableFuture)this.aiClient.sendChatRequest("tinyllama:latest", message).thenAccept(aiResponse -> {
            if (!aiResponse.isEmpty()) {
                this.chatHistory.add("AI: " + aiResponse);
                this.chatScrollOffset = this.getMaxScrollOffset();
                LOGGER.info(aiResponse);
            }
            this.waitingForAIResponse = false;
            this.updateUIState();
        })).exceptionally(throwable -> {
            this.chatHistory.add("System: Error getting AI response: " + throwable.getMessage());
            this.chatScrollOffset = this.getMaxScrollOffset();
            this.waitingForAIResponse = false;
            this.updateUIState();
            return null;
        });
    }

    public void method_25419() {
        super.method_25419();
    }
}

