/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi;

import io.github.zhengzhengyiyi.gui.NbtEditorScreen;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class NbtSaver {
    private final Minecraft client = Minecraft.getInstance();

    public void saveAndOpenEditor() {
        if (this.client == null || this.client.player == null || this.client.level == null) {
            return;
        }
        CompoundTag tag = this.readPointedNbt(this.client.player, this.client.level);
        this.openEditor(tag);
    }

    private CompoundTag readPointedNbt(LocalPlayer player, ClientLevel world) {
        HitResult hit = this.client.hitResult;
        if (hit == null) {
            return new CompoundTag();
        }
        if (hit.getType() == HitResult.Type.BLOCK) {
            BlockHitResult bhr = (BlockHitResult)hit;
            BlockEntity be = world.getBlockEntity(bhr.getBlockPos());
            CompoundTag tag = new CompoundTag();
            if (be == null) {
                BlockState state = world.getBlockState(bhr.getBlockPos());
                tag.putString("block", state.toString());
            }
            return tag;
        }
        if (hit.getType() == HitResult.Type.ENTITY) {
            EntityHitResult ehr = (EntityHitResult)hit;
            Entity e = ehr.getEntity();
            CompoundTag tag = new CompoundTag();
            try {
                Field nbtField = Entity.class.getDeclaredField("customData");
                nbtField.setAccessible(true);
                Object nbtObj = nbtField.get(e);
                if (nbtObj instanceof CompoundTag) {
                    tag = (CompoundTag)nbtObj;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                ex.printStackTrace();
            }
            return tag;
        }
        return new CompoundTag();
    }

    private void openEditor(CompoundTag tag) {
        this.client.execute(() -> this.client.setScreen((Screen)new NbtEditorScreen(tag)));
    }
}

