/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.api;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

public class AiClient {
    private static final String OLLAMA_BASE_URL = "http://localhost:11434";
    private final HttpClient httpClient = HttpClient.newHttpClient();

    public CompletableFuture<String> sendChatRequest(String model, String message) {
        String requestBody = String.format("{\"model\": \"%s\", \"messages\": [{\"role\": \"user\", \"content\": \"%s\"}], \"stream\": false}", model, this.escapeJson(message));
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/chat")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        return this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() == 200) {
                return this.extractContentFromResponse((String)response.body());
            }
            throw new RuntimeException("API request failed: " + response.statusCode() + " - " + (String)response.body());
        });
    }

    private String extractContentFromResponse(String jsonResponse) {
        try {
            int idx = jsonResponse.indexOf("\"content\":\"");
            if (idx == -1) {
                return "Unable to parse AI response";
            }
            StringBuilder sb = new StringBuilder();
            boolean escape = false;
            for (int i = idx + 11; i < jsonResponse.length(); ++i) {
                char c = jsonResponse.charAt(i);
                if (escape) {
                    switch (c) {
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case 'b': {
                            sb.append('\b');
                            break;
                        }
                        case 'f': {
                            sb.append('\f');
                            break;
                        }
                        case '\\': {
                            sb.append('\\');
                            break;
                        }
                        case '\"': {
                            sb.append('\"');
                            break;
                        }
                        case '/': {
                            sb.append('/');
                            break;
                        }
                        case 'u': {
                            if (i + 4 < jsonResponse.length()) {
                                String hex = jsonResponse.substring(i + 1, i + 5);
                                try {
                                    int code = Integer.parseInt(hex, 16);
                                    sb.append((char)code);
                                    i += 4;
                                }
                                catch (Exception e) {
                                    sb.append('\\');
                                    sb.append('u');
                                }
                                break;
                            }
                            sb.append('\\');
                            sb.append('u');
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                    escape = false;
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                if (c == '\"') break;
                sb.append(c);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "Error parsing response";
        }
    }

    private String escapeJson(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public CompletableFuture<Boolean> checkServerStatus() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://localhost:11434/api/tags")).GET().build();
        return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> response.statusCode() == 200)).exceptionally(ex -> false);
    }
}

