/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import io.github.zhengzhengyiyi.api.AiClient;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIChatScreen
extends Screen {
    private EditBox inputField;
    private EditBox pathField;
    private Button sendButton;
    private Button loadButton;
    private Button clearButton;
    private Button settingsButton;
    private List<String> chatHistory;
    private List<String> userInputs;
    private boolean waitingForSendResponse = false;
    private boolean loadingFile = false;
    private boolean serverAvailable = false;
    private boolean checkingServer = true;
    private int chatScrollOffset = 0;
    private Button scrollUpButton;
    private Button scrollDownButton;
    private static Logger LOGGER = LoggerFactory.getLogger(AIChatScreen.class);
    private AiClient aiClient = new AiClient();

    public AIChatScreen() {
        super((Component)Component.literal((String)"AI Chat"));
        this.chatHistory = new ArrayList<String>();
        this.userInputs = new ArrayList<String>();
        this.chatHistory.add("AI: Hello! How can I help you today?");
        this.chatHistory.add("AI: I'm ready to assist you with anything!");
    }

    protected void init() {
        super.init();
        this.checkServerAvailability();
        int panelWidth = Math.min(400, this.width - 40);
        int panelHeight = Math.min(300, this.height - 80);
        int panelX = (this.width - panelWidth) / 2;
        int panelY = (this.height - panelHeight) / 2 - 20;
        int inputY = panelY + panelHeight + 10;
        int inputWidth = panelWidth - 100;
        this.inputField = new EditBox(this.font, panelX, inputY, inputWidth, 20, (Component)Component.literal((String)"Type your message..."));
        this.inputField.setMaxLength(1024);
        this.inputField.setEditable(false);
        this.addRenderableWidget((GuiEventListener)this.inputField);
        this.sendButton = Button.builder((Component)Component.literal((String)"Send"), button -> this.sendMessage()).bounds(panelX + inputWidth + 5, inputY, 45, 20).build();
        this.sendButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.sendButton);
        int pathY = inputY + 26;
        this.pathField = new EditBox(this.font, panelX, pathY, inputWidth - 50, 20, (Component)Component.literal((String)"Enter file or folder path relative to .minecraft or absolute"));
        this.pathField.setMaxLength(1024);
        this.addRenderableWidget((GuiEventListener)this.pathField);
        this.loadButton = Button.builder((Component)Component.literal((String)"Load"), button -> this.loadPathAndSend()).bounds(panelX + inputWidth - 40, pathY, 45, 20).build();
        this.addRenderableWidget((GuiEventListener)this.loadButton);
        this.clearButton = Button.builder((Component)Component.literal((String)"Clear"), button -> this.clearChat()).bounds(panelX + panelWidth - 90, panelY - 25, 45, 20).build();
        this.addRenderableWidget((GuiEventListener)this.clearButton);
        this.settingsButton = Button.builder((Component)Component.literal((String)"Settings"), button -> this.openSettings()).bounds(panelX + panelWidth - 45, panelY - 25, 45, 20).build();
        this.addRenderableWidget((GuiEventListener)this.settingsButton);
        this.scrollUpButton = Button.builder((Component)Component.literal((String)"\u2191"), button -> this.scrollUp()).bounds(panelX + panelWidth - 20, panelY + 25, 16, 16).build();
        this.addRenderableWidget((GuiEventListener)this.scrollUpButton);
        this.scrollDownButton = Button.builder((Component)Component.literal((String)"\u2193"), button -> this.scrollDown()).bounds(panelX + panelWidth - 20, panelY + panelHeight - 20, 16, 16).build();
        this.addRenderableWidget((GuiEventListener)this.scrollDownButton);
        this.setInitialFocus((GuiEventListener)this.inputField);
        this.updateScrollButtons();
    }

    private void checkServerAvailability() {
        this.checkingServer = true;
        ((CompletableFuture)this.aiClient.checkServerStatus().thenAccept(available -> {
            this.serverAvailable = available;
            this.checkingServer = false;
            if (!this.serverAvailable) {
                this.chatHistory.add("System: Ollama server is not available. Please make sure Ollama is running on localhost:11434");
            }
            this.updateUIState();
        })).exceptionally(throwable -> {
            this.serverAvailable = false;
            this.checkingServer = false;
            this.chatHistory.add("System: Failed to check server status: " + throwable.getMessage());
            this.updateUIState();
            return null;
        });
    }

    private void updateUIState() {
        if (this.inputField != null) {
            this.inputField.setEditable(this.serverAvailable && !this.waitingForSendResponse);
        }
        if (this.sendButton != null) {
            boolean bl = this.sendButton.active = this.serverAvailable && !this.waitingForSendResponse && this.inputField != null && !this.inputField.getValue().trim().isEmpty();
        }
        if (this.loadButton != null) {
            this.loadButton.active = this.serverAvailable && !this.loadingFile;
        }
        this.updateScrollButtons();
    }

    private void updateScrollButtons() {
        if (this.scrollUpButton != null && this.scrollDownButton != null) {
            this.scrollUpButton.active = this.chatScrollOffset > 0;
            this.scrollDownButton.active = this.chatScrollOffset < this.getMaxScrollOffset();
        }
    }

    private int getMaxScrollOffset() {
        int panelWidth = Math.min(400, this.width - 40);
        int panelHeight = Math.min(300, this.height - 80);
        int maxVisibleLines = (panelHeight - 50) / 10;
        int totalLines = this.getTotalChatLines(panelWidth - 30);
        return Math.max(0, totalLines - maxVisibleLines);
    }

    private int getTotalChatLines(int maxWidth) {
        int totalLines = 0;
        for (String message : this.chatHistory) {
            List<String> wrappedLines = this.wrapText(message, maxWidth);
            totalLines += wrappedLines.size();
        }
        if (this.checkingServer || this.waitingForSendResponse || this.loadingFile) {
            ++totalLines;
        }
        return totalLines;
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() > 0 ? String.valueOf(currentLine) + " " + word : word;
            if (this.font.width(testLine) <= maxWidth) {
                currentLine.append((String)(currentLine.length() > 0 ? " " + word : word));
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
            currentLine = new StringBuilder();
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private void scrollUp() {
        if (this.chatScrollOffset > 0) {
            --this.chatScrollOffset;
            this.updateScrollButtons();
        }
    }

    private void scrollDown() {
        if (this.chatScrollOffset < this.getMaxScrollOffset()) {
            ++this.chatScrollOffset;
            this.updateScrollButtons();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int panelWidth = Math.min(400, this.width - 40);
        int panelHeight = Math.min(300, this.height - 80);
        int panelX = (this.width - panelWidth) / 2;
        int panelY = (this.height - panelHeight) / 2 - 20;
        if (mouseX >= (double)panelX && mouseX <= (double)(panelX + panelWidth) && mouseY >= (double)panelY && mouseY <= (double)(panelY + panelHeight)) {
            if (verticalAmount < 0.0) {
                this.scrollDown();
            } else if (verticalAmount > 0.0) {
                this.scrollUp();
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int panelWidth = Math.min(400, this.width - 40);
        int panelHeight = Math.min(300, this.height - 80);
        int panelX = (this.width - panelWidth) / 2;
        int panelY = (this.height - panelHeight) / 2 - 20;
        context.fill(panelX - 2, panelY - 2, panelX + panelWidth + 2, panelY + panelHeight + 2, -13421773);
        context.fill(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -15066598);
        Object title = "AI Chat Assistant";
        if (this.checkingServer) {
            title = (String)title + " (Checking server...)";
        } else if (!this.serverAvailable) {
            title = (String)title + " (Server Offline)";
        }
        context.drawString(this.font, (Component)Component.literal((String)title), this.width / 2 - 70, panelY - 15, 0xFFFFFF, false);
        context.hLine(panelX + 5, panelX + panelWidth - 5, panelY + 20, -10066330);
        int chatY = panelY + 35;
        int maxVisibleLines = (panelHeight - 50) / 12;
        int textAreaWidth = panelWidth - 30;
        this.drawScrollBar(context, panelX, panelY, panelWidth, panelHeight);
        this.updateUIState();
        super.render(context, mouseX, mouseY, delta);
        context.enableScissor(panelX + 5, panelY + 25, panelX + panelWidth - 5, panelY + panelHeight - 5);
        int currentLine = 0;
        int visibleLineCount = 0;
        for (String message : this.chatHistory) {
            List<String> wrappedLines = this.wrapText(message, textAreaWidth);
            for (String line : wrappedLines) {
                if (currentLine >= this.chatScrollOffset && visibleLineCount < maxVisibleLines) {
                    int renderY = chatY + visibleLineCount * 12;
                    int color = this.getMessageColor(message);
                    context.drawString(this.font, line, panelX + 10, renderY, color, false);
                    ++visibleLineCount;
                }
                ++currentLine;
            }
        }
        if ((this.checkingServer || this.waitingForSendResponse || this.loadingFile) && visibleLineCount < maxVisibleLines) {
            int renderY = chatY + visibleLineCount * 12;
            String loadingText = this.checkingServer ? "Checking server status" : (this.waitingForSendResponse ? "AI is thinking" : "Loading files...");
            context.drawString(this.font, loadingText, panelX + 10, renderY, -1, false);
        }
        context.disableScissor();
    }

    private int getMessageColor(String message) {
        return -1;
    }

    private void drawScrollBar(GuiGraphics context, int panelX, int panelY, int panelWidth, int panelHeight) {
        int scrollBarX = panelX + panelWidth - 18;
        int scrollBarY = panelY + 25;
        int scrollBarHeight = panelHeight - 30;
        context.fill(scrollBarX, scrollBarY, scrollBarX + 12, scrollBarY + scrollBarHeight, -12303292);
        int maxScrollOffset = this.getMaxScrollOffset();
        if (maxScrollOffset > 0) {
            int thumbHeight = Math.max(20, (int)((double)scrollBarHeight * (1.0 / (double)(maxScrollOffset + 1))));
            int thumbY = scrollBarY + (int)((double)(scrollBarHeight - thumbHeight) * ((double)this.chatScrollOffset / (double)maxScrollOffset));
            context.fill(scrollBarX, thumbY, scrollBarX + 12, thumbY + thumbHeight, -7829368);
        }
    }

    public boolean keyPressed(KeyEvent input) {
        int keyCode = input.input();
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        if (keyCode == 257 && this.inputField.isFocused() && !this.waitingForSendResponse && this.serverAvailable) {
            this.sendMessage();
            return true;
        }
        return super.keyPressed(input);
    }

    private void sendMessage() {
        String message = this.inputField.getValue().trim();
        if (!message.isEmpty() && !this.waitingForSendResponse && this.serverAvailable) {
            this.userInputs.add(message);
            this.chatHistory.add("You: " + message);
            this.inputField.setValue("");
            this.waitingForSendResponse = true;
            this.chatScrollOffset = this.getMaxScrollOffset();
            this.updateUIState();
            this.input(message);
        }
    }

    private void clearChat() {
        this.chatHistory.clear();
        this.userInputs.clear();
        this.chatScrollOffset = 0;
        if (this.serverAvailable) {
            this.chatHistory.add("AI: Chat cleared. How can I help you?");
        } else {
            this.chatHistory.add("System: Chat cleared. Server is still unavailable.");
        }
        this.updateUIState();
    }

    private void openSettings() {
        Minecraft.getInstance().setScreen((Screen)new EditorScreen());
    }

    private void loadPathAndSend() {
        String rawPath = this.pathField.getValue().trim();
        if (rawPath.isEmpty()) {
            this.chatHistory.add("System: Path is empty.");
            return;
        }
        File base = Minecraft.getInstance().gameDirectory;
        File target = new File(rawPath);
        if (!target.isAbsolute()) {
            target = new File(base, rawPath);
        }
        if (!target.exists()) {
            this.chatHistory.add("System: Path does not exist: " + target.getPath());
            return;
        }
        this.loadingFile = true;
        this.chatHistory.add("You (file): " + target.getPath());
        this.chatScrollOffset = this.getMaxScrollOffset();
        this.updateUIState();
        if (target.isFile()) {
            try {
                String content = this.readFileContent(target);
                String prompt = "User loaded configure file:" + target.getName() + "\n" + content;
                ((CompletableFuture)this.aiClient.sendChatRequest("tinyllama:latest", prompt).thenAccept(aiResponse -> {
                    String safe = this.unescapeJsonEscapes((String)aiResponse);
                    if (!safe.isEmpty()) {
                        this.chatHistory.add("AI: " + safe);
                        this.chatScrollOffset = this.getMaxScrollOffset();
                        LOGGER.info(safe);
                    }
                    this.loadingFile = false;
                    this.updateUIState();
                })).exceptionally(throwable -> {
                    this.chatHistory.add("System: Error getting AI response: " + throwable.getMessage());
                    this.loadingFile = false;
                    this.updateUIState();
                    return null;
                });
            }
            catch (IOException e) {
                this.chatHistory.add("System: Failed to read file: " + e.getMessage());
                this.loadingFile = false;
                this.updateUIState();
            }
        } else if (target.isDirectory()) {
            try {
                StringBuilder sb = new StringBuilder();
                File[] files = target.listFiles();
                if (files == null || files.length == 0) {
                    this.chatHistory.add("System: Directory is empty.");
                    this.loadingFile = false;
                    this.updateUIState();
                    return;
                }
                for (File f : files) {
                    if (f.isFile() && f.length() < 20000L) {
                        sb.append("---FILE: ").append(f.getName()).append("---\n");
                        sb.append(this.readFileContent(f)).append("\n\n");
                    } else {
                        sb.append("---SKIP: ").append(f.getName()).append(" (too large or not a file)---\n");
                    }
                    if (sb.length() <= 30000) continue;
                    sb.append("\n...TRUNCATED...\n");
                    break;
                }
                String prompt = "Please analyze the following directory listing and small file contents:\n" + sb.toString();
                ((CompletableFuture)this.aiClient.sendChatRequest("tinyllama:latest", prompt).thenAccept(aiResponse -> {
                    String safe = this.unescapeJsonEscapes((String)aiResponse);
                    if (!safe.isEmpty()) {
                        this.chatHistory.add("AI: " + safe);
                        this.chatScrollOffset = this.getMaxScrollOffset();
                        LOGGER.info(safe);
                    }
                    this.loadingFile = false;
                    this.updateUIState();
                })).exceptionally(throwable -> {
                    this.chatHistory.add("System: Error getting AI response: " + throwable.getMessage());
                    this.loadingFile = false;
                    this.updateUIState();
                    return null;
                });
            }
            catch (IOException e) {
                this.chatHistory.add("System: Failed to read directory: " + e.getMessage());
                this.loadingFile = false;
                this.updateUIState();
            }
        }
    }

    private String readFileContent(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        String s = new String(bytes, StandardCharsets.UTF_8);
        if (s.length() > 10000) {
            return s.substring(0, 10000) + "\n...TRUNCATED...";
        }
        return s;
    }

    private String unescapeJsonEscapes(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i + 1 < s.length()) {
                char n = s.charAt(++i);
                switch (n) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '/': {
                        sb.append('/');
                        break;
                    }
                    case 'u': {
                        if (i + 4 < s.length()) {
                            String hex = s.substring(i + 1, i + 5);
                            try {
                                int code = Integer.parseInt(hex, 16);
                                sb.append((char)code);
                                i += 4;
                            }
                            catch (Exception e) {
                                sb.append('\\');
                                sb.append('u');
                            }
                            break;
                        }
                        sb.append('\\');
                        sb.append('u');
                        break;
                    }
                    default: {
                        sb.append(n);
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void input(String message) {
        ((CompletableFuture)this.aiClient.sendChatRequest("tinyllama:latest", message).thenAccept(aiResponse -> {
            String safe = this.unescapeJsonEscapes((String)aiResponse);
            if (!safe.isEmpty()) {
                this.chatHistory.add("AI: " + safe);
                this.chatScrollOffset = this.getMaxScrollOffset();
                LOGGER.info(safe);
            }
            this.waitingForSendResponse = false;
            this.updateUIState();
        })).exceptionally(throwable -> {
            this.chatHistory.add("System: Error getting AI response: " + throwable.getMessage());
            this.chatScrollOffset = this.getMaxScrollOffset();
            this.waitingForSendResponse = false;
            this.updateUIState();
            return null;
        });
    }

    public void onClose() {
        super.onClose();
    }
}

