/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.github.zhengzhengyiyi.CommonEntryPoint;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.config.ModConfigData;
import io.github.zhengzhengyiyi.gui.PluginManagerScreen;
import io.github.zhengzhengyiyi.gui.theme.ThemeManager;
import io.github.zhengzhengyiyi.gui.widget.GeneralMultilineEditor;
import io.github.zhengzhengyiyi.util.BackupHelper;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorScreen.class);
    private List<Path> configFiles;
    private int selectedIndex = 0;
    private GeneralMultilineEditor editor;
    private boolean modified = false;
    private Button saveButton;
    private Button openFolderButton;
    private Button backupButton;
    private String buffer = "";
    private EditBox searchField;
    private Button searchNextButton;
    private Button searchPrevButton;
    private Button managePluginsButton;
    private Button exitButton;
    private boolean searchVisible = false;
    private ThemeManager themeManager;
    private Button themeToggleButton;
    private int fileListScrollOffset = 0;
    private Button scrollUpButton;
    private Button scrollDownButton;
    private List<Button> fileButtonList;

    public EditorScreen() {
        super((Component)Component.translatable((String)"configeditor.title"));
    }

    protected void init() {
        super.init();
        this.themeManager = ThemeManager.getInstance();
        this.themeToggleButton = Button.builder((Component)Component.translatable((String)this.getThemeButtonText()), button -> this.toggleTheme()).bounds(this.width - 50, 5, 45, 16).build();
        this.addRenderableWidget((GuiEventListener)this.themeToggleButton);
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            this.configFiles = new ArrayList<Path>();
            this.loadConfigFilesRecursively(configDir, this.configFiles);
        }
        catch (Exception e) {
            this.configFiles = new ArrayList<Path>();
            LOGGER.error("Failed to list config files", (Throwable)e);
        }
        this.fileButtonList = new ArrayList<Button>();
        this.scrollUpButton = Button.builder((Component)Component.literal((String)"\u2191"), button -> this.scrollUp()).bounds(140, 25, 20, 20).build();
        this.scrollDownButton = Button.builder((Component)Component.literal((String)"\u2193"), button -> this.scrollDown()).bounds(140, this.height - 45, 20, 20).build();
        this.managePluginsButton = Button.builder((Component)Component.nullToEmpty((String)"plugins"), button -> this.minecraft.setScreen((Screen)new PluginManagerScreen(this))).bounds(this.width - 30, this.height - 20, 20, 30).build();
        this.addRenderableWidget((GuiEventListener)this.scrollUpButton);
        this.addRenderableWidget((GuiEventListener)this.scrollDownButton);
        this.addRenderableWidget((GuiEventListener)this.managePluginsButton);
        this.renderFileList();
        this.editor = new GeneralMultilineEditor(170, 20, this.width - 180, this.height - 60, (Component)Component.translatable((String)"configeditor.editor"));
        this.editor.setChangedListener(text -> {
            if (!this.buffer.equals(text)) {
                this.modified = true;
                this.updateButtonStates();
            } else {
                this.modified = false;
            }
        });
        this.saveButton = Button.builder((Component)Component.translatable((String)"configeditor.button.save"), button -> this.saveFile()).bounds(this.width - 170, this.height - 30, 80, 20).build();
        this.backupButton = Button.builder((Component)Component.translatable((String)"configeditor.button.backup"), button -> BackupHelper.backupEntireConfigDirectory()).bounds(this.width - 260, this.height - 30, 80, 20).build();
        this.openFolderButton = Button.builder((Component)Component.translatable((String)"configeditor.button.openfolder"), button -> this.openConfigFolder()).bounds(this.width - 80, this.height - 30, 70, 20).build();
        this.exitButton = Button.builder((Component)Component.translatable((String)"configeditor.button.close"), button -> this.onClose()).bounds(0, 0, 80, 20).build();
        this.searchField = new EditBox(this.font, this.width - 300, 5, 150, 16, (Component)Component.translatable((String)"configeditor.search.placeholder"));
        this.searchField.setResponder(text -> {
            if (!text.trim().isEmpty()) {
                this.startSearch(text.trim());
            }
        });
        this.searchField.setVisible(true);
        this.searchNextButton = Button.builder((Component)Component.literal((String)"\u2193"), button -> this.findNext()).bounds(this.width - 145, 5, 20, 16).build();
        this.searchNextButton.visible = true;
        this.searchPrevButton = Button.builder((Component)Component.literal((String)"\u2191"), button -> this.findPrevious()).bounds(this.width - 165, 5, 20, 16).build();
        this.searchPrevButton.visible = true;
        Button closeSearchButton = Button.builder((Component)Component.literal((String)"\u2715"), button -> {
            this.searchField.setValue("");
            this.endSearch();
        }).bounds(this.width - 120, 5, 20, 16).build();
        this.addRenderableWidget((GuiEventListener)this.saveButton);
        this.addRenderableWidget((GuiEventListener)this.backupButton);
        this.addRenderableWidget((GuiEventListener)this.openFolderButton);
        this.addRenderableWidget((GuiEventListener)this.searchField);
        this.addRenderableWidget((GuiEventListener)this.searchNextButton);
        this.addRenderableWidget((GuiEventListener)this.searchPrevButton);
        this.addRenderableWidget((GuiEventListener)closeSearchButton);
        this.addRenderableWidget((GuiEventListener)this.exitButton);
        this.addRenderableWidget((GuiEventListener)this.editor);
        this.setInitialFocus((GuiEventListener)this.editor);
        if (!this.configFiles.isEmpty()) {
            this.loadFile(this.selectedIndex);
        } else {
            this.editor.setText("{}");
            this.editor.setEditable(false);
            LOGGER.warn("No config files found in config directory");
        }
        for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
            entrypoint.onEditerOpen(this);
        }
        this.updateButtonStates();
        this.updateScrollButtons();
    }

    public boolean isConfigFile(Path file) {
        String fileName = file.getFileName().toString();
        if (fileName.equals(".DS_Store") || fileName.startsWith(".") || fileName.equals("Thumbs.db")) {
            return false;
        }
        String lowerName = fileName.toLowerCase();
        return lowerName.endsWith(".json") || lowerName.endsWith(".txt") || lowerName.endsWith(".yml") || lowerName.endsWith(".yaml") || lowerName.endsWith(".properties") || lowerName.endsWith(".toml") || lowerName.endsWith(".conf") || lowerName.endsWith(".cfg") || lowerName.endsWith(".ini");
    }

    private String formatFileName(String filePath) {
        if (filePath.length() > 22) {
            int lastSeparator = filePath.lastIndexOf(47);
            if (lastSeparator != -1) {
                Object folder = filePath.substring(0, lastSeparator);
                Object fileName = filePath.substring(lastSeparator + 1);
                if (((String)folder).length() > 8) {
                    folder = ((String)folder).substring(0, 12) + "..";
                }
                if (((String)fileName).length() > 12) {
                    fileName = ((String)fileName).substring(0, 12) + "..";
                }
                return (String)folder + "/" + (String)fileName;
            }
            return filePath.substring(0, 17) + "...";
        }
        return filePath;
    }

    private void renderFileList() {
        for (Button button : this.fileButtonList) {
            this.removeWidget((GuiEventListener)button);
        }
        this.fileButtonList.clear();
        int buttonY = 25;
        for (int i = this.fileListScrollOffset; i < this.configFiles.size() && i < this.fileListScrollOffset + 15; ++i) {
            int index = i;
            Path file = this.configFiles.get(i);
            Path configDir = FabricLoader.getInstance().getConfigDir();
            String relativePath = configDir.relativize(file).toString();
            Button button = Button.builder((Component)Component.literal((String)this.formatFileName(relativePath)), _button -> this.switchFile(index)).bounds(10, buttonY, 130, 20).build();
            this.addRenderableWidget((GuiEventListener)button);
            this.fileButtonList.add(button);
            buttonY += 23;
        }
    }

    private void scrollUp() {
        if (this.fileListScrollOffset > 0) {
            --this.fileListScrollOffset;
            this.renderFileList();
            this.updateScrollButtons();
        }
    }

    private void scrollDown() {
        if (this.fileListScrollOffset < this.configFiles.size() - 15) {
            ++this.fileListScrollOffset;
            this.renderFileList();
            this.updateScrollButtons();
        }
    }

    private void updateScrollButtons() {
        this.scrollUpButton.active = this.fileListScrollOffset > 0;
        this.scrollDownButton.active = this.fileListScrollOffset < this.configFiles.size() - 15;
    }

    private void updateButtonStates() {
        if (this.saveButton != null) {
            this.saveButton.active = true;
        }
    }

    private void switchFile(int index) {
        this.loadFile(index);
    }

    private void loadFile(int index) {
        if (index < 0 || index >= this.configFiles.size()) {
            LOGGER.error("Invalid file index: {}", (Object)index);
            return;
        }
        this.selectedIndex = index;
        this.modified = false;
        Path file = this.configFiles.get(index);
        try {
            String content;
            this.buffer = content = this.readFileWithFallbackEncoding(file);
            this.editor.setFileName(EditorScreen.getFileName(file.getFileName()));
            this.editor.setText(content);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config file: {}", (Object)file.getFileName(), (Object)e);
            this.editor.setFileName(EditorScreen.getFileName(file.getFileName()));
            this.editor.setText("{}");
            this.editor.setEditable(false);
            this.showErrorPopup((Component)Component.translatable((String)"configeditor.error.loadfailed"));
        }
        this.updateButtonStates();
    }

    public static String getFileName(Path path) {
        if (path == null) {
            return "";
        }
        return path.getFileName().toString();
    }

    private String readFileWithFallbackEncoding(Path file) throws IOException {
        try {
            return Files.readString(file, StandardCharsets.UTF_8);
        }
        catch (MalformedInputException e) {
            try {
                return Files.readString(file, Charset.defaultCharset());
            }
            catch (MalformedInputException e2) {
                return Files.readString(file, StandardCharsets.ISO_8859_1);
            }
        }
    }

    private void loadConfigFilesRecursively(Path directory, List<Path> fileList) throws IOException {
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(directory);){
            List entries = stream.collect(Collectors.toList());
            for (Path entry : entries) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    this.loadConfigFilesRecursively(entry, fileList);
                    continue;
                }
                if (!Files.isRegularFile(entry, new LinkOption[0]) || !this.isConfigFile(entry)) continue;
                fileList.add(entry);
            }
        }
    }

    public boolean checkIfJson(String content) {
        if (content == null || content.trim().isEmpty()) {
            return false;
        }
        String trimmed = content.trim();
        if (!trimmed.startsWith("{") && !trimmed.startsWith("[")) {
            return false;
        }
        try {
            JsonParser.parseString((String)content);
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    private void startSearch(String query) {
        this.editor.startSearch(query);
    }

    private void findNext() {
        this.editor.findNext();
    }

    private void findPrevious() {
        this.editor.findPrevious();
    }

    private void endSearch() {
        this.editor.endSearch();
    }

    private void saveFile() {
        this.saveFileAsync(null);
    }

    private void saveFileAsync(Runnable callback) {
        if (this.configFiles.isEmpty()) {
            return;
        }
        Path file = this.configFiles.get(this.selectedIndex);
        String content = this.editor.getText();
        new Thread(() -> {
            int retryCount = 0;
            int maxRetries = 3;
            while (retryCount <= 3) {
                try {
                    block13: {
                        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                            FileLock lock;
                            block14: {
                                lock = channel.tryLock(0L, Long.MAX_VALUE, false);
                                if (lock == null) break block13;
                                try {
                                    Files.writeString(file, (CharSequence)content, StandardOpenOption.TRUNCATE_EXISTING);
                                    this.modified = false;
                                    LOGGER.info("Successfully saved file: {}", (Object)file.getFileName());
                                    if (callback != null) {
                                        this.minecraft.execute(callback);
                                        break block14;
                                    }
                                    this.minecraft.execute(this::updateButtonStates);
                                }
                                catch (Throwable throwable) {
                                    lock.release();
                                    throw throwable;
                                }
                            }
                            lock.release();
                            return;
                        }
                    }
                    if (++retryCount > 3) continue;
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    if (++retryCount <= 3) continue;
                    LOGGER.error("Failed to save file after {} attempts: {}", new Object[]{3, file.getFileName(), e});
                    this.minecraft.execute(() -> {
                        if (this.minecraft.screen != null && this.minecraft.screen.equals((Object)this)) {
                            this.showErrorPopup((Component)Component.translatable((String)"configeditor.error.savefailed"));
                        }
                    });
                }
            }
            this.minecraft.execute(() -> {
                if (this.minecraft.screen != null && this.minecraft.screen.equals((Object)this)) {
                    this.showErrorPopup((Component)Component.translatable((String)"configeditor.error.fileretryfailed"));
                }
            });
        }).start();
    }

    private void openConfigFolder() {
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            LOGGER.info("Config folder location: {}", (Object)configDir);
            Util.getPlatform().openUri(configDir.toUri());
        }
        catch (Exception e) {
            LOGGER.error("Failed to get config folder", (Throwable)e);
        }
    }

    private void showErrorPopup(Component message) {
        this.minecraft.setScreen((Screen)new ConfirmScreen(result -> {
            this.onClose();
            this.minecraft.setScreen(null);
        }, (Component)Component.translatable((String)"configeditor.confirm.title"), message));
    }

    public void showMessagePopup(Component message) {
        this.minecraft.setScreen((Screen)new ConfirmScreen(result -> {
            this.onClose();
            this.minecraft.setScreen(null);
        }, (Component)Component.translatable((String)"configeditor.confirm.title"), message));
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (CommonEntryPoint.configManager.getConfig().doRenderBackground) {
            context.fill(0, 0, this.width, this.height, this.themeManager.getBackgroundColor());
        }
        super.render(context, mouseX, mouseY, delta);
        if (!this.configFiles.isEmpty()) {
            Object status = this.modified ? "* " + this.configFiles.get(this.selectedIndex).getFileName().toString() : this.configFiles.get(this.selectedIndex).getFileName().toString();
            String editorType = "[File]";
            context.drawString(this.font, (String)status + editorType, 170, 5, this.modified ? 0xFFFF00 : 0xFFFFFF, false);
        }
        for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
            entrypoint.renderButton(context, mouseX, mouseY, delta);
        }
    }

    public boolean shouldCloseOnEsc() {
        if (this.modified) {
            ConfirmScreen confirmScreen = new ConfirmScreen(result -> {
                if (result) {
                    this.saveFileAsync(() -> {
                        this.onClose();
                        this.minecraft.setScreen(null);
                    });
                } else {
                    this.onClose();
                    this.minecraft.setScreen(null);
                }
            }, (Component)Component.translatable((String)"configeditor.confirm.title"), (Component)Component.translatable((String)"configeditor.confirm.unsavedclose"));
            this.minecraft.setScreen((Screen)confirmScreen);
            return false;
        }
        return true;
    }

    public AbstractWidget getTextWidget() {
        return this.editor;
    }

    private void toggleSearch() {
        this.searchVisible = !this.searchVisible;
        this.searchField.setVisible(this.searchVisible);
        this.searchNextButton.visible = this.searchVisible;
        this.searchPrevButton.visible = this.searchVisible;
        if (this.searchVisible) {
            this.setFocused((GuiEventListener)this.searchField);
            String searchText = this.searchField.getValue();
            if (searchText != null && !searchText.trim().isEmpty()) {
                this.startSearch(searchText);
            }
        } else {
            this.endSearch();
        }
    }

    public void onClose() {
        super.onClose();
        this.configFiles = null;
        this.fileButtonList.clear();
        this.fileButtonList = null;
        for (ApiEntrypoint entrypoint : CommonEntryPoint.ENTRYPOINTS) {
            entrypoint.onEditerClose(this);
        }
        LOGGER.info("Config editor closed");
    }

    public void removed() {
        super.removed();
        LOGGER.info("Config editor screen removed");
    }

    public boolean keyPressed(KeyEvent input) {
        if (input.input() == 81 && input.hasControlDown() && input.hasAltDown()) {
            this.minecraft.setScreen(null);
            LOGGER.info("Config editor force closed by user shortcut");
            return true;
        }
        if (this.editor == null) {
            return super.keyPressed(input);
        }
        if (this.searchVisible) {
            if (input.input() == 257) {
                this.startSearch(this.searchField.getValue());
                return true;
            }
            if (input.input() == 256) {
                this.toggleSearch();
                return true;
            }
            if (input.input() == 292) {
                this.findNext();
                return true;
            }
        }
        if (input.input() == 70 && input.hasControlDown()) {
            this.toggleSearch();
            return true;
        }
        return super.keyPressed(input);
    }

    private void toggleTheme() {
        ModConfigData config = CommonEntryPoint.configManager.getConfig();
        switch (config.theme) {
            case DARK: {
                config.theme = ModConfigData.ThemeMode.LIGHT;
                break;
            }
            case LIGHT: {
                config.theme = ModConfigData.ThemeMode.AUTO;
                break;
            }
            case AUTO: {
                config.theme = ModConfigData.ThemeMode.DARK;
            }
        }
        CommonEntryPoint.configManager.save();
        this.themeToggleButton.setMessage((Component)Component.translatable((String)this.getThemeButtonText()));
    }

    private String getThemeButtonText() {
        return switch (CommonEntryPoint.configManager.getConfig().theme) {
            default -> throw new MatchException(null, null);
            case ModConfigData.ThemeMode.DARK -> "configeditor.theme.dark";
            case ModConfigData.ThemeMode.LIGHT -> "configeditor.theme.light";
            case ModConfigData.ThemeMode.AUTO -> "configeditor.theme.auto";
        };
    }
}

