/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import io.github.zhengzhengyiyi.CommonEntryPoint;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PluginManagerScreen
extends Screen {
    private final Screen parent;
    private final Map<ApiEntrypoint, Boolean> pluginStates;

    public PluginManagerScreen(Screen parent) {
        super((Component)Component.translatable((String)"screen.zhengzhengyiyi.plugin_manager"));
        this.parent = parent;
        this.pluginStates = new HashMap<ApiEntrypoint, Boolean>();
    }

    protected void init() {
        super.init();
        int y = 40;
        for (ApiEntrypoint plugin : CommonEntryPoint.TOTAL_ENTRYPOINTS) {
            ResourceLocation pluginId = plugin.getIdentifier();
            String pluginName = pluginId.getPath();
            this.pluginStates.put(plugin, CommonEntryPoint.ENTRYPOINTS.contains(plugin));
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)pluginName), button -> {}).bounds(this.width / 2 - 120, y, 150, 20).build());
            Button toggleButton = Button.builder((Component)(CommonEntryPoint.ENTRYPOINTS.contains(plugin) ? Component.translatable((String)"button.zhengzhengyiyi.enable") : Component.translatable((String)"button.zhengzhengyiyi.disable")), button -> this.togglePlugin(plugin, button)).bounds(this.width / 2 + 40, y, 80, 20).build();
            this.addRenderableWidget((GuiEventListener)toggleButton);
            y += 25;
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.onClose()).bounds(this.width / 2 - 100, this.height - 28, 200, 20).build());
    }

    private void togglePlugin(ApiEntrypoint plugin, Button button) {
        if (CommonEntryPoint.ENTRYPOINTS.contains(plugin)) {
            button.setMessage((Component)Component.translatable((String)"button.zhengzhengyiyi.disable"));
            CommonEntryPoint.ENTRYPOINTS.remove(plugin);
        } else {
            button.setMessage((Component)Component.translatable((String)"button.zhengzhengyiyi.enable"));
            CommonEntryPoint.ENTRYPOINTS.add(plugin);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.drawCenteredString(this.font, this.title, this.width / 2, 12, 0xFFFFFF);
        super.render(context, mouseX, mouseY, delta);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

