/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui.widget;

import io.github.zhengzhengyiyi.api.FileType;
import io.github.zhengzhengyiyi.gui.widget.AbstractEditor;
import io.github.zhengzhengyiyi.util.TextSearchEngine;
import io.github.zhengzhengyiyi.util.highlighter.HighLighter;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GeneralMultilineEditor
extends AbstractEditor {
    private final Font textRenderer;
    private boolean isDraggingHorizontalScroll = false;
    private int dragStartX = 0;
    private int dragStartScrollOffset = 0;
    public String text = "";
    private int scrollOffset = 0;
    private int horizontalScrollOffset = 0;
    public static int maxVisibleLines = 10;
    private boolean editable = true;
    private Consumer<String> changedListener;
    private int cursorPosition = 0;
    private long lastCursorBlinkTime = 0L;
    private boolean cursorVisible = true;
    private String filename = "";
    private int maxLineWidth = 0;
    public int lastCursorX = 0;
    private TextSearchEngine searchEngine = new TextSearchEngine();
    private boolean isSearching = false;
    public String searchQuery = "";
    private FileType fileType = FileType.TXT;

    public GeneralMultilineEditor(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        this.textRenderer = Minecraft.getInstance().font;
        this.setFocused(false);
    }

    public FileType getFileTypeFromName(String fileName) {
        String lowerName = fileName.toLowerCase();
        for (FileType type : FileType.values()) {
            String extension = "." + type.getExtension();
            if (!lowerName.endsWith(extension)) continue;
            return type;
        }
        return FileType.UNKNOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        context.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        try {
            context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -16777216);
            String[] lines = this.text.split("\n", -1);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int maxVisibleLines = this.height / lineHeight;
            this.calculateMaxLineWidth(lines);
            if (this.isSearching && !this.searchQuery.isEmpty()) {
                this.renderSearchHighlights(context, lines, lineHeight, maxVisibleLines);
            }
            HighLighter highlighter = this.fileType.getHighLighter();
            for (int i = 0; i < lines.length; ++i) {
                if (i < this.scrollOffset || i >= this.scrollOffset + maxVisibleLines) continue;
                int yPos = this.getY() + 4 + (i - this.scrollOffset) * lineHeight;
                String lineNum = String.valueOf(i + 1);
                context.drawString(this.textRenderer, lineNum, this.getX() + 2 - this.horizontalScrollOffset, yPos, -7829368, false);
                highlighter.drawHighlightedText(context, this.textRenderer, lines[i], this.getX() + 4 + 12 - this.horizontalScrollOffset, yPos, this.editable);
            }
            if (this.isFocused() && this.editable) {
                long currentTime = Util.getNanos();
                if (currentTime - this.lastCursorBlinkTime > 500000000L) {
                    this.cursorVisible = !this.cursorVisible;
                    this.lastCursorBlinkTime = currentTime;
                }
                if (this.cursorVisible) {
                    int lineIndex = 0;
                    int xPos = this.getX() + 4 + 12;
                    int remaining = this.cursorPosition;
                    for (int i = 0; i < lines.length; ++i) {
                        if (remaining <= lines[i].length()) {
                            xPos += highlighter.getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                            lineIndex = i;
                            break;
                        }
                        remaining -= lines[i].length() + 1;
                    }
                    if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                        int yPos = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                        Objects.requireNonNull(this.textRenderer);
                        context.vLine(xPos - this.horizontalScrollOffset, yPos - 1, yPos + 9 + 1, -1);
                    }
                }
            }
            this.renderScrollBars(context, lines.length, maxVisibleLines);
        }
        finally {
            context.disableScissor();
        }
    }

    private void calculateMaxLineWidth(String[] lines) {
        this.maxLineWidth = 0;
        for (String line : lines) {
            int lineWidth = this.fileType.getHighLighter().getTextWidth(this.textRenderer, line);
            this.maxLineWidth = Math.max(this.maxLineWidth, lineWidth);
        }
    }

    private void renderScrollBars(GuiGraphics context, int totalLines, int maxVisibleLines) {
        int scrollbarWidth = 5;
        if (totalLines > maxVisibleLines) {
            int scrollbarHeight = Math.max(20, (int)((float)this.height * (float)maxVisibleLines / (float)totalLines));
            int scrollbarY = this.getY() + (int)((float)(this.height - scrollbarHeight) * (float)this.scrollOffset / (float)(totalLines - maxVisibleLines));
            context.fill(this.getX() + this.width - scrollbarWidth, this.getY(), this.getX() + this.width, this.getY() + this.height, -11184811);
            context.fill(this.getX() + this.width - scrollbarWidth + 1, scrollbarY, this.getX() + this.width - 1, scrollbarY + scrollbarHeight, -4473925);
        }
        if (this.maxLineWidth > this.width - 20) {
            int visibleWidth = this.width - 20;
            int scrollbarHeight = 5;
            int scrollbarX = this.getX() + (int)((float)(this.width - scrollbarWidth) * (float)this.horizontalScrollOffset / (float)(this.maxLineWidth - visibleWidth));
            int scrollbarY = this.getY() + this.height - scrollbarHeight;
            context.fill(this.getX(), this.getY() + this.height - scrollbarHeight, this.getX() + this.width, this.getY() + this.height, -11184811);
            context.fill(scrollbarX, scrollbarY, scrollbarX + Math.max(20, (int)((float)this.width * (float)visibleWidth / (float)this.maxLineWidth)), scrollbarY + scrollbarHeight, -4473925);
        }
    }

    private void renderSearchHighlights(GuiGraphics context, String[] lines, int lineHeight, int maxVisibleLines) {
        this.searchEngine.setScrollOffset(this.scrollOffset);
        int currentLineStart = 0;
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line = lines[lineIndex];
            if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                int yPos = this.getY() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                int xBase = this.getX() + 4 + 12 - this.horizontalScrollOffset;
                for (int matchPos : this.searchEngine.matchPositions) {
                    int matchEndInLine;
                    int matchInLine;
                    if (matchPos < currentLineStart || matchPos >= currentLineStart + line.length() || (matchInLine = matchPos - currentLineStart) >= (matchEndInLine = Math.min(matchInLine + this.searchQuery.length(), line.length()))) continue;
                    String beforeMatch = line.substring(0, matchInLine);
                    String matchText = line.substring(matchInLine, matchEndInLine);
                    int xStart = xBase + this.fileType.getHighLighter().getTextWidth(this.textRenderer, beforeMatch);
                    int highlightWidth = this.fileType.getHighLighter().getTextWidth(this.textRenderer, matchText);
                    Objects.requireNonNull(this.textRenderer);
                    int yStart = yPos + 9 - 1;
                    boolean isCurrentMatch = matchPos == this.searchEngine.getCurrentMatchPosition();
                    int color = isCurrentMatch ? 1728042752 : 0x66FFFF00;
                    context.fill(xStart, yStart, xStart + highlightWidth, yStart + 2, color);
                }
            }
            currentLineStart += line.length() + 1;
        }
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        double mouseY;
        double mouseX = click.x();
        if (this.isMouseOverHorizontalScrollBar(mouseX, mouseY = click.y())) {
            this.isDraggingHorizontalScroll = true;
            this.dragStartX = (int)mouseX;
            this.dragStartScrollOffset = this.horizontalScrollOffset;
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY) && this.editable) {
            this.setFocused(true);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int clickedY = (int)mouseY - (this.getY() + 4);
            int lineIndex = Mth.clamp((int)(clickedY / lineHeight + this.scrollOffset), (int)0, (int)(this.text.split("\n", -1).length - 1));
            String[] lines = this.text.split("\n", -1);
            String line = lines[lineIndex];
            int clickedX = (int)mouseX - (this.getX() + 4 + 12) + this.horizontalScrollOffset;
            int charIndex = this.fileType.getHighLighter().getCharIndexFromTokens(this.textRenderer, line, clickedX);
            int newPosition = 0;
            for (int i = 0; i < lineIndex; ++i) {
                newPosition += lines[i].length() + 1;
            }
            this.cursorPosition = Mth.clamp((int)(newPosition += charIndex), (int)0, (int)this.text.length());
            return true;
        }
        this.setFocused(false);
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int maxLines = this.text.split("\n", -1).length;
        int maxVisibleLines = this.height / lineHeight;
        int newScrollOffset = this.scrollOffset - (int)Math.signum(amount);
        this.scrollOffset = Mth.clamp((int)newScrollOffset, (int)0, (int)Math.max(0, maxLines - maxVisibleLines));
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.mouseScrolled(mouseX, mouseY, verticalAmount);
    }

    private boolean isMouseOverHorizontalScrollBar(double mouseX, double mouseY) {
        if (this.maxLineWidth <= this.width - 20) {
            return false;
        }
        int scrollbarHeight = 5;
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)(this.getY() + this.height - scrollbarHeight) && mouseY <= (double)(this.getY() + this.height);
    }

    public boolean keyPressed(KeyEvent input) {
        if (!this.editable) {
            return false;
        }
        int keyCode = input.input();
        if (keyCode == 259) {
            if (this.cursorPosition > 0) {
                this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                --this.cursorPosition;
                this.onTextChanged();
                this.updateCursorX();
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.cursorPosition < this.text.length()) {
                this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                this.onTextChanged();
                this.updateCursorX();
            }
            return true;
        }
        if (keyCode == 263) {
            this.cursorPosition = Mth.clamp((int)(this.cursorPosition - 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            return true;
        }
        if (keyCode == 262) {
            this.cursorPosition = Mth.clamp((int)(this.cursorPosition + 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            return true;
        }
        if (keyCode == 268) {
            this.cursorPosition = this.getLineStart(this.cursorPosition);
            this.updateCursorX();
            return true;
        }
        if (keyCode == 269) {
            this.cursorPosition = this.getLineEnd(this.cursorPosition);
            this.updateCursorX();
            return true;
        }
        if (keyCode == 265) {
            int prevLineEnd;
            int lineStart = this.getLineStart(this.cursorPosition);
            int currentX = this.cursorPosition - lineStart;
            int n = prevLineEnd = lineStart > 0 ? this.getLineEnd(lineStart - 1) : -1;
            if (prevLineEnd != -1) {
                int prevLineStart = this.getLineStart(prevLineEnd);
                int prevLineLength = prevLineEnd - prevLineStart;
                int newX = Math.min(currentX, prevLineLength);
                this.cursorPosition = prevLineStart + newX;
            }
            this.updateCursorX();
            return true;
        }
        if (keyCode == 264) {
            int nextLineStart;
            int lineEnd = this.getLineEnd(this.cursorPosition);
            int currentX = this.cursorPosition - this.getLineStart(this.cursorPosition);
            int n = nextLineStart = lineEnd < this.text.length() ? lineEnd + 1 : -1;
            if (nextLineStart != -1) {
                int nextLineEnd = this.getLineEnd(nextLineStart);
                int nextLineLength = nextLineEnd - nextLineStart;
                int newX = Math.min(currentX, nextLineLength);
                this.cursorPosition = nextLineStart + newX;
            }
            this.updateCursorX();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.text = this.text.substring(0, this.cursorPosition) + "\n" + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            return true;
        }
        return false;
    }

    public boolean charTyped(CharacterEvent input) {
        if (!this.isFocused() || !this.editable) {
            return false;
        }
        if (input.isAllowedChatCharacter()) {
            String chr = input.codepointAsString();
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        this.defaultButtonNarrationText(builder);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.cursorPosition = Mth.clamp((int)this.cursorPosition, (int)0, (int)this.text.length());
        this.onTextChanged();
        this.updateCursorX();
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    private void onTextChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.text);
        }
    }

    private void updateCursorX() {
        int lineStart = this.getLineStart(this.cursorPosition);
        String currentLine = this.text.substring(lineStart, this.cursorPosition);
        this.lastCursorX = this.fileType.getHighLighter().getTextWidth(this.textRenderer, currentLine);
        int visibleWidth = this.width - 20;
        if (this.lastCursorX > this.horizontalScrollOffset + visibleWidth) {
            this.horizontalScrollOffset = this.lastCursorX - visibleWidth + 10;
        } else if (this.lastCursorX < this.horizontalScrollOffset) {
            this.horizontalScrollOffset = Math.max(0, this.lastCursorX - 10);
        }
    }

    private int getLineStart(int pos) {
        int start = this.text.lastIndexOf(10, pos - 1) + 1;
        return start;
    }

    private int getLineEnd(int pos) {
        int end = this.text.indexOf(10, pos);
        if (end == -1) {
            end = this.text.length();
        }
        return end;
    }

    @Override
    public void insertTextAtCursor(String text) {
        this.text = this.text.substring(0, this.cursorPosition) + text + this.text.substring(this.cursorPosition);
        this.cursorPosition += text.length();
        this.onTextChanged();
        this.updateCursorX();
    }

    @Override
    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public void setCursorPosition(int position) {
        this.cursorPosition = Mth.clamp((int)position, (int)0, (int)this.text.length());
        this.updateCursorX();
    }

    public void setFileName(String v) {
        this.filename = v;
        this.fileType = this.getFileTypeFromName(v);
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public void startSearch(String query) {
        this.searchQuery = query;
        this.isSearching = true;
        this.searchEngine.search(query, this.text);
        if (this.searchEngine.hasMatches()) {
            this.scrollToCurrentMatch();
        }
    }

    @Override
    public void findNext() {
        if (this.isSearching && this.searchEngine.hasMatches()) {
            this.searchEngine.nextMatch();
            this.scrollToCurrentMatch();
        }
    }

    @Override
    public void findPrevious() {
        if (this.isSearching && this.searchEngine.hasMatches()) {
            this.searchEngine.previousMatch();
            this.scrollToCurrentMatch();
        }
    }

    private void scrollToCurrentMatch() {
        int lineIndex;
        Integer matchPos = this.searchEngine.getCurrentMatchPosition();
        if (matchPos != null && ((lineIndex = this.getLineIndex(matchPos)) < this.scrollOffset || lineIndex >= this.scrollOffset + maxVisibleLines)) {
            this.scrollOffset = Math.max(0, lineIndex - 2);
        }
    }

    @Override
    public void endSearch() {
        this.isSearching = false;
        this.searchQuery = "";
        this.searchEngine.clear();
    }

    private int getLineIndex(int position) {
        int line = 0;
        for (int i = 0; i < position && i < this.text.length(); ++i) {
            if (this.text.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    @Override
    public boolean isSearching() {
        return this.isSearching;
    }

    @Override
    public int getSearchMatchCount() {
        return this.searchEngine.getMatchCount();
    }

    @Override
    public int getCurrentSearchIndex() {
        return this.searchEngine.getCurrentMatchIndex() + 1;
    }

    public boolean mouseDragged(MouseButtonEvent click, double offsetX, double offsetY) {
        if (this.isDraggingHorizontalScroll) {
            int visibleWidth = this.width - 20;
            int dragDeltaX = (int)click.x() - this.dragStartX;
            int scrollRange = Math.max(0, this.maxLineWidth - visibleWidth);
            if (scrollRange > 0) {
                float scrollRatio = (float)dragDeltaX / (float)this.width;
                int newScrollOffset = this.dragStartScrollOffset + (int)(scrollRatio * (float)scrollRange);
                this.horizontalScrollOffset = Mth.clamp((int)newScrollOffset, (int)0, (int)scrollRange);
            }
            return true;
        }
        return super.mouseDragged(click, offsetX, offsetY);
    }

    public boolean mouseReleased(MouseButtonEvent click) {
        if (this.isDraggingHorizontalScroll) {
            this.isDraggingHorizontalScroll = false;
            return true;
        }
        return super.mouseReleased(click);
    }
}

