/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class TextSearchEngine {
    private String searchText = "";
    private boolean caseSensitive = false;
    private boolean useRegex = false;
    public List<Integer> matchPositions = new ArrayList<Integer>();
    private int currentMatchIndex = -1;
    private int scrollOffset = 0;

    public void search(String text, String content) {
        String searchContent;
        this.searchText = text;
        this.matchPositions.clear();
        this.currentMatchIndex = -1;
        if (text == null || text.isEmpty() || content == null || content.isEmpty()) {
            return;
        }
        String searchPattern = this.caseSensitive ? text : text.toLowerCase();
        String string = searchContent = this.caseSensitive ? content : content.toLowerCase();
        if (this.useRegex) {
            try {
                Pattern pattern = Pattern.compile(searchPattern, this.caseSensitive ? 0 : 2);
                Matcher matcher = pattern.matcher(content);
                while (matcher.find()) {
                    this.matchPositions.add(matcher.start());
                }
            }
            catch (PatternSyntaxException e) {
                this.matchPositions.clear();
            }
        } else {
            int foundIndex;
            int index = 0;
            while (index < searchContent.length() && (foundIndex = searchContent.indexOf(searchPattern, index)) != -1) {
                this.matchPositions.add(foundIndex);
                index = foundIndex + 1;
            }
        }
        if (!this.matchPositions.isEmpty()) {
            this.currentMatchIndex = 0;
        }
    }

    public boolean hasMatches() {
        return !this.matchPositions.isEmpty();
    }

    public int getMatchCount() {
        return this.matchPositions.size();
    }

    public int getCurrentMatchIndex() {
        return this.currentMatchIndex;
    }

    public Integer getCurrentMatchPosition() {
        if (this.currentMatchIndex >= 0 && this.currentMatchIndex < this.matchPositions.size()) {
            return this.matchPositions.get(this.currentMatchIndex);
        }
        return null;
    }

    public boolean nextMatch() {
        if (this.matchPositions.isEmpty()) {
            return false;
        }
        this.currentMatchIndex = (this.currentMatchIndex + 1) % this.matchPositions.size();
        return true;
    }

    public boolean previousMatch() {
        if (this.matchPositions.isEmpty()) {
            return false;
        }
        this.currentMatchIndex = (this.currentMatchIndex - 1 + this.matchPositions.size()) % this.matchPositions.size();
        return true;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setUseRegex(boolean useRegex) {
        this.useRegex = useRegex;
    }

    public void clear() {
        this.searchText = "";
        this.matchPositions.clear();
        this.currentMatchIndex = -1;
    }

    public void renderHighlights(GuiGraphics context, Font textRenderer, String content, int x, int y, int lineHeight, int visibleLines) {
        if (this.matchPositions.isEmpty()) {
            return;
        }
        String[] lines = content.split("\n", -1);
        int currentLineStart = 0;
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line;
            if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + visibleLines) {
                line = lines[lineIndex];
                int yPos = y + (lineIndex - this.scrollOffset) * lineHeight;
                for (int matchPos : this.matchPositions) {
                    if (matchPos < currentLineStart || matchPos >= currentLineStart + line.length()) continue;
                    int matchInLine = matchPos - currentLineStart;
                    String beforeMatch = line.substring(0, matchInLine);
                    String matchText = line.substring(matchInLine, Math.min(matchInLine + this.searchText.length(), line.length()));
                    int xStart = x + textRenderer.width(beforeMatch);
                    int highlightWidth = textRenderer.width(matchText);
                    if (matchPos == this.getCurrentMatchPosition()) {
                        context.fill(xStart, yPos, xStart + highlightWidth, yPos + lineHeight, 1728042752);
                        continue;
                    }
                    context.fill(xStart, yPos, xStart + highlightWidth, yPos + lineHeight, 0x66FFFF00);
                }
            }
            line = lines[lineIndex];
            currentLineStart += line.length() + 1;
        }
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
    }
}

