/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.api;

import io.github.zhengzhengyiyi.util.highlighter.CfgSyntaxHighlighter;
import io.github.zhengzhengyiyi.util.highlighter.HighLighter;
import io.github.zhengzhengyiyi.util.highlighter.JsonSyntaxHighlighter;
import io.github.zhengzhengyiyi.util.highlighter.PropertiesSyntaxHighlighter;
import io.github.zhengzhengyiyi.util.highlighter.TextSyntaxHighlighter;
import io.github.zhengzhengyiyi.util.highlighter.TomlSyntaxHighlighter;
import io.github.zhengzhengyiyi.util.highlighter.YamlSyntaxHighlighter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public enum FileType {
    JSON("json", new JsonSyntaxHighlighter()),
    YML("yml", new DefaultHighlighter()),
    YAML("yaml", new YamlSyntaxHighlighter()),
    TXT("txt", new TextSyntaxHighlighter()),
    PROPERTIES("properties", new PropertiesSyntaxHighlighter()),
    TOML("toml", new TomlSyntaxHighlighter()),
    CONF("conf", new DefaultHighlighter()),
    CFG("cfg", new CfgSyntaxHighlighter()),
    INI("ini", new DefaultHighlighter()),
    JSON5("json5", new JsonSyntaxHighlighter()),
    UNKNOW("UNKNOW", new DefaultHighlighter());

    private final String extension;
    private final HighLighter highLighter;

    private FileType(String extension, HighLighter highLighter) {
        this.extension = extension;
        this.highLighter = highLighter;
    }

    public String getExtension() {
        return this.extension;
    }

    public HighLighter getHighLighter() {
        return this.highLighter;
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultHighlighter
    implements HighLighter {
        @Override
        public void drawHighlightedText(class_332 context, class_327 textRenderer, String text, int x, int y, boolean editable) {
            if (text == null || text.isEmpty()) {
                return;
            }
            int color = editable ? -1 : -5592406;
            context.method_51433(textRenderer, text, x, y, color, false);
        }

        @Override
        public int getTextWidth(class_327 textRenderer, String text) {
            if (text == null || text.isEmpty()) {
                return 0;
            }
            return textRenderer.method_1727(text);
        }

        @Override
        public int getCharIndexFromTokens(class_327 textRenderer, String line, int targetX) {
            if (line == null || line.isEmpty()) {
                return 0;
            }
            int currentWidth = 0;
            for (int i = 0; i < line.length(); ++i) {
                char c = line.charAt(i);
                int charWidth = textRenderer.method_1727(String.valueOf(c));
                if (currentWidth + charWidth > targetX) {
                    return i;
                }
                currentWidth += charWidth;
            }
            return line.length();
        }

        @Override
        public int getTextWidthUpToChar(class_327 textRenderer, String line, int charIndex) {
            if (line == null || line.isEmpty() || charIndex <= 0) {
                return 0;
            }
            if (charIndex >= line.length()) {
                return textRenderer.method_1727(line);
            }
            String substring = line.substring(0, charIndex);
            return textRenderer.method_1727(substring);
        }
    }
}

