/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.zhengzhengyiyi.api.config.ConfigData;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ConfigManager<T extends ConfigData> {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath;
    private final Class<T> configClass;
    private T config;
    private FileTime lastModifiedTime;
    private ScheduledExecutorService fileWatcher;
    private volatile boolean isReloading = false;
    private volatile boolean isWatcherRunning = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);

    public ConfigManager(Path configPath, T defaultConfig, Class<T> configClass) {
        this.configPath = configPath;
        this.config = defaultConfig;
        this.configClass = configClass;
        this.init();
    }

    private void init() {
        this.load();
    }

    public void load() {
        if (this.isReloading) {
            return;
        }
        try {
            if (Files.exists(this.configPath, new LinkOption[0])) {
                String jsonContent = Files.readString(this.configPath);
                ConfigData loadedConfig = (ConfigData)this.gson.fromJson(jsonContent, this.configClass);
                if (loadedConfig != null) {
                    this.config = loadedConfig;
                }
                this.lastModifiedTime = Files.getLastModifiedTime(this.configPath, new LinkOption[0]);
            } else {
                this.save();
                LOGGER.info("Created new configuration file with default values: {}", (Object)this.configPath);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config from {}: {}", (Object)this.configPath, (Object)e.getMessage());
        }
    }

    public void save() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            String jsonContent = this.gson.toJson(this.config);
            Files.writeString(this.configPath, (CharSequence)jsonContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.lastModifiedTime = Files.getLastModifiedTime(this.configPath, new LinkOption[0]);
            LOGGER.info("Configuration saved successfully to: {}", (Object)this.configPath);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config to {}: {}", (Object)this.configPath, (Object)e.getMessage());
        }
    }

    private void startFileWatcher() {
        if (this.fileWatcher != null && !this.fileWatcher.isShutdown()) {
            this.fileWatcher.shutdown();
            try {
                if (!this.fileWatcher.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.fileWatcher.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.fileWatcher.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.fileWatcher = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "Config-File-Watcher-" + String.valueOf(this.configPath.getFileName()));
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        });
        this.fileWatcher.scheduleAtFixedRate(() -> {
            try {
                boolean isModified;
                if (!Files.exists(this.configPath, new LinkOption[0])) {
                    LOGGER.debug("Config file does not exist: {}", (Object)this.configPath);
                    return;
                }
                FileTime currentModifiedTime = Files.getLastModifiedTime(this.configPath, new LinkOption[0]);
                boolean bl = isModified = this.lastModifiedTime == null || currentModifiedTime.toMillis() > this.lastModifiedTime.toMillis() + 1000L;
                if (isModified && !this.isReloading) {
                    this.isReloading = true;
                    LOGGER.info("Detected config file modification, reloading...");
                    if (class_310.method_1551() != null) {
                        class_310.method_1551().execute(() -> {
                            this.load();
                            this.isReloading = false;
                        });
                    } else {
                        this.load();
                        this.isReloading = false;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("File watcher error for {}: {}", (Object)this.configPath, (Object)e.getMessage());
                this.isReloading = false;
            }
        }, 2L, 2L, TimeUnit.SECONDS);
        this.isWatcherRunning = true;
        LOGGER.info("File watcher started for: {}", (Object)this.configPath);
    }

    public T getConfig() {
        this.load();
        return this.config;
    }

    public void updateConfig(T newConfig) {
        this.config = newConfig;
        this.save();
    }

    public boolean isWatcherRunning() {
        return this.isWatcherRunning && this.fileWatcher != null && !this.fileWatcher.isShutdown();
    }

    public void restartFileWatcher() {
        LOGGER.info("Restarting file watcher for: {}", (Object)this.configPath);
        this.startFileWatcher();
    }

    public void shutdown() {
        this.isWatcherRunning = false;
        if (this.fileWatcher != null) {
            LOGGER.info("Shutting down file watcher for: {}", (Object)this.configPath);
            this.fileWatcher.shutdown();
            try {
                if (!this.fileWatcher.awaitTermination(3L, TimeUnit.SECONDS)) {
                    this.fileWatcher.shutdownNow();
                    LOGGER.warn("File watcher had to be forcefully shutdown for: {}", (Object)this.configPath);
                } else {
                    LOGGER.info("File watcher shutdown successfully for: {}", (Object)this.configPath);
                }
            }
            catch (InterruptedException e) {
                this.fileWatcher.shutdownNow();
                Thread.currentThread().interrupt();
                LOGGER.warn("File watcher shutdown interrupted for: {}", (Object)this.configPath);
            }
        }
    }
}

