/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.github.zhengzhengyiyi.ConfigEditorClient;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.config.ModConfigData;
import io.github.zhengzhengyiyi.gui.theme.ThemeManager;
import io.github.zhengzhengyiyi.gui.widget.AbstractEditor;
import io.github.zhengzhengyiyi.gui.widget.GeneralMultilineEditor;
import io.github.zhengzhengyiyi.gui.widget.MultilineEditor;
import io.github.zhengzhengyiyi.util.BackupHelper;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class EditorScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorScreen.class);
    private List<Path> configFiles;
    private int selectedIndex = 0;
    private MultilineEditor multilineEditor;
    private GeneralMultilineEditor universalEditor;
    private AbstractEditor currentEditor;
    private boolean modified = false;
    private class_4185 saveButton;
    private class_4185 openFolderButton;
    private class_4185 backupButton;
    private String buffer = "";
    private class_342 searchField;
    private class_4185 searchNextButton;
    private class_4185 searchPrevButton;
    private class_4185 exitButton;
    private boolean searchVisible = false;
    private ThemeManager themeManager;
    private class_4185 themeToggleButton;
    private int fileListScrollOffset = 0;
    private class_4185 scrollUpButton;
    private class_4185 scrollDownButton;
    private List<class_4185> fileButtonList;
    private boolean isJsonFile = true;

    public EditorScreen() {
        super((class_2561)class_2561.method_43471((String)"configeditor.title"));
    }

    protected void method_25426() {
        super.method_25426();
        this.themeManager = ThemeManager.getInstance();
        this.themeToggleButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)this.getThemeButtonText()), button -> this.toggleTheme()).method_46434(this.field_22789 - 50, 5, 45, 16).method_46431();
        this.method_37063((class_364)this.themeToggleButton);
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            this.configFiles = new ArrayList<Path>();
            this.loadConfigFilesRecursively(configDir, this.configFiles);
        }
        catch (Exception e) {
            this.configFiles = new ArrayList<Path>();
            LOGGER.error("Failed to list config files", (Throwable)e);
        }
        this.fileButtonList = new ArrayList<class_4185>();
        this.scrollUpButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> this.scrollUp()).method_46434(140, 25, 20, 20).method_46431();
        this.scrollDownButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> this.scrollDown()).method_46434(140, this.field_22790 - 45, 20, 20).method_46431();
        this.method_37063((class_364)this.scrollUpButton);
        this.method_37063((class_364)this.scrollDownButton);
        this.renderFileList();
        this.multilineEditor = new MultilineEditor(170, 20, this.field_22789 - 180, this.field_22790 - 60, (class_2561)class_2561.method_43471((String)"configeditor.editor"));
        this.multilineEditor.setChangedListener(text -> {
            if (!this.buffer.equals(text)) {
                this.modified = true;
                this.updateButtonStates();
            } else {
                this.modified = false;
            }
        });
        this.universalEditor = new GeneralMultilineEditor(170, 20, this.field_22789 - 180, this.field_22790 - 60, (class_2561)class_2561.method_43471((String)"configeditor.editor"));
        this.universalEditor.setChangedListener(text -> {
            if (!this.buffer.equals(text)) {
                this.modified = true;
                this.updateButtonStates();
            } else {
                this.modified = false;
            }
        });
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.save"), button -> this.saveFile()).method_46434(this.field_22789 - 170, this.field_22790 - 30, 80, 20).method_46431();
        this.backupButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.backup"), button -> BackupHelper.backupEntireConfigDirectory()).method_46434(this.field_22789 - 260, this.field_22790 - 30, 80, 20).method_46431();
        this.openFolderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.openfolder"), button -> this.openConfigFolder()).method_46434(this.field_22789 - 80, this.field_22790 - 30, 70, 20).method_46431();
        this.exitButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.close"), button -> this.method_25419()).method_46434(0, 0, 80, 20).method_46431();
        this.searchField = new class_342(this.field_22793, this.field_22789 - 300, 5, 150, 16, (class_2561)class_2561.method_43471((String)"configeditor.search.placeholder"));
        this.searchField.method_1863(text -> {
            if (!text.trim().isEmpty()) {
                this.startSearch(text.trim());
            }
        });
        this.searchField.method_1862(true);
        this.searchNextButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> this.findNext()).method_46434(this.field_22789 - 145, 5, 20, 16).method_46431();
        this.searchNextButton.field_22764 = true;
        this.searchPrevButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> this.findPrevious()).method_46434(this.field_22789 - 165, 5, 20, 16).method_46431();
        this.searchPrevButton.field_22764 = true;
        class_4185 closeSearchButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), button -> {
            this.searchField.method_1852("");
            this.endSearch();
        }).method_46434(this.field_22789 - 120, 5, 20, 16).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.backupButton);
        this.method_37063((class_364)this.openFolderButton);
        this.method_37063((class_364)this.searchField);
        this.method_37063((class_364)this.searchNextButton);
        this.method_37063((class_364)this.searchPrevButton);
        this.method_37063((class_364)closeSearchButton);
        this.method_37063((class_364)this.exitButton);
        this.method_48265((class_364)this.multilineEditor);
        if (!this.configFiles.isEmpty()) {
            this.loadFile(this.selectedIndex);
        } else {
            this.multilineEditor.setText("{}");
            this.multilineEditor.setEditable(false);
            LOGGER.warn("No config files found in config directory");
        }
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onEditerOpen(this);
        }
        this.updateButtonStates();
        this.updateScrollButtons();
    }

    public boolean isConfigFile(Path file) {
        String fileName = file.getFileName().toString();
        if (fileName.equals(".DS_Store") || fileName.startsWith(".") || fileName.equals("Thumbs.db")) {
            return false;
        }
        String lowerName = fileName.toLowerCase();
        return lowerName.endsWith(".json") || lowerName.endsWith(".txt") || lowerName.endsWith(".yml") || lowerName.endsWith(".yaml") || lowerName.endsWith(".properties") || lowerName.endsWith(".toml") || lowerName.endsWith(".conf") || lowerName.endsWith(".cfg") || lowerName.endsWith(".ini");
    }

    private String formatFileName(String filePath) {
        if (filePath.length() > 22) {
            int lastSeparator = filePath.lastIndexOf(47);
            if (lastSeparator != -1) {
                Object folder = filePath.substring(0, lastSeparator);
                Object fileName = filePath.substring(lastSeparator + 1);
                if (((String)folder).length() > 8) {
                    folder = ((String)folder).substring(0, 12) + "..";
                }
                if (((String)fileName).length() > 12) {
                    fileName = ((String)fileName).substring(0, 12) + "..";
                }
                return (String)folder + "/" + (String)fileName;
            }
            return filePath.substring(0, 17) + "...";
        }
        return filePath;
    }

    private void renderFileList() {
        for (class_4185 button : this.fileButtonList) {
            this.method_37066((class_364)button);
        }
        this.fileButtonList.clear();
        int buttonY = 25;
        for (int i = this.fileListScrollOffset; i < this.configFiles.size() && i < this.fileListScrollOffset + 15; ++i) {
            int index = i;
            Path file = this.configFiles.get(i);
            Path configDir = FabricLoader.getInstance().getConfigDir();
            String relativePath = configDir.relativize(file).toString();
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.formatFileName(relativePath)), _button -> this.switchFile(index)).method_46434(10, buttonY, 130, 20).method_46431();
            this.method_37063((class_364)button);
            this.fileButtonList.add(button);
            buttonY += 23;
        }
    }

    private void scrollUp() {
        if (this.fileListScrollOffset > 0) {
            --this.fileListScrollOffset;
            this.renderFileList();
            this.updateScrollButtons();
        }
    }

    private void scrollDown() {
        if (this.fileListScrollOffset < this.configFiles.size() - 15) {
            ++this.fileListScrollOffset;
            this.renderFileList();
            this.updateScrollButtons();
        }
    }

    private void updateScrollButtons() {
        this.scrollUpButton.field_22763 = this.fileListScrollOffset > 0;
        this.scrollDownButton.field_22763 = this.fileListScrollOffset < this.configFiles.size() - 15;
    }

    private void updateButtonStates() {
        if (this.saveButton != null) {
            this.saveButton.field_22763 = true;
        }
    }

    private void switchFile(int index) {
        this.loadFile(index);
    }

    private void loadFile(int index) {
        if (index < 0 || index >= this.configFiles.size()) {
            LOGGER.error("Invalid file index: {}", (Object)index);
            return;
        }
        this.selectedIndex = index;
        this.modified = false;
        Path file = this.configFiles.get(index);
        try {
            boolean isJson;
            String content;
            this.buffer = content = this.readFileWithFallbackEncoding(file);
            this.isJsonFile = isJson = this.checkIfJson(content);
            this.switchEditor(isJson, EditorScreen.getFileName(file.getFileName()));
            this.currentEditor.setText(content);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config file: {}", (Object)file.getFileName(), (Object)e);
            this.switchEditor(true, EditorScreen.getFileName(file.getFileName()));
            this.currentEditor.setText("{}");
            this.currentEditor.setEditable(false);
            this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.loadfailed"));
        }
        this.updateButtonStates();
    }

    public static String getFileName(Path path) {
        if (path == null) {
            return "";
        }
        return path.getFileName().toString();
    }

    private String readFileWithFallbackEncoding(Path file) throws IOException {
        try {
            return Files.readString(file, StandardCharsets.UTF_8);
        }
        catch (MalformedInputException e) {
            try {
                return Files.readString(file, Charset.defaultCharset());
            }
            catch (MalformedInputException e2) {
                return Files.readString(file, StandardCharsets.ISO_8859_1);
            }
        }
    }

    private void loadConfigFilesRecursively(Path directory, List<Path> fileList) throws IOException {
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.list(directory);){
            List entries = stream.collect(Collectors.toList());
            for (Path entry : entries) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    this.loadConfigFilesRecursively(entry, fileList);
                    continue;
                }
                if (!Files.isRegularFile(entry, new LinkOption[0]) || !this.isConfigFile(entry)) continue;
                fileList.add(entry);
            }
        }
    }

    private boolean checkIfJson(String content) {
        if (content == null || content.trim().isEmpty()) {
            return false;
        }
        String trimmed = content.trim();
        if (!trimmed.startsWith("{") && !trimmed.startsWith("[")) {
            return false;
        }
        try {
            JsonParser.parseString((String)content);
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    private void switchEditor(boolean useJsonEditor, String fileName) {
        if (this.currentEditor != null) {
            this.method_37066((class_364)this.currentEditor);
        }
        if (useJsonEditor) {
            this.multilineEditor.setFileName(fileName);
            this.currentEditor = this.multilineEditor;
        } else {
            this.universalEditor.setFileName(fileName);
            this.currentEditor = this.universalEditor;
            ((GeneralMultilineEditor)this.currentEditor).setFileName(fileName);
        }
        this.method_37063((class_364)this.currentEditor);
        this.method_48265((class_364)this.currentEditor);
    }

    private void startSearch(String query) {
        this.currentEditor.startSearch(query);
    }

    private void findNext() {
        this.currentEditor.findNext();
    }

    private void findPrevious() {
        this.currentEditor.findPrevious();
    }

    private void endSearch() {
        this.currentEditor.endSearch();
    }

    private void saveFile() {
        this.saveFileAsync(null);
    }

    private void saveFileAsync(Runnable callback) {
        if (this.configFiles.isEmpty()) {
            return;
        }
        Path file = this.configFiles.get(this.selectedIndex);
        String content = this.getCurrentEditorText();
        if (this.isJsonFile) {
            try {
                JsonParser.parseString((String)content);
            }
            catch (JsonSyntaxException e) {
                LOGGER.warn("Invalid JSON syntax in file: {}", (Object)file.getFileName());
                this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.invalidjson"));
                return;
            }
        }
        new Thread(() -> {
            int retryCount = 0;
            int maxRetries = 3;
            while (retryCount <= 3) {
                try {
                    block16: {
                        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                            FileLock lock;
                            block17: {
                                lock = channel.tryLock(0L, Long.MAX_VALUE, false);
                                if (lock == null) break block16;
                                try {
                                    Files.writeString(file, (CharSequence)content, StandardOpenOption.TRUNCATE_EXISTING);
                                    this.modified = false;
                                    LOGGER.info("Successfully saved file: {}", (Object)file.getFileName());
                                    if (callback != null) {
                                        this.field_22787.execute(callback);
                                        break block17;
                                    }
                                    this.field_22787.execute(this::updateButtonStates);
                                }
                                catch (Exception e) {
                                    try {
                                        LOGGER.error(e.toString());
                                        break block16;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                    finally {
                                        lock.release();
                                    }
                                }
                            }
                            lock.release();
                            return;
                        }
                    }
                    if (++retryCount > 3) continue;
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    if (++retryCount <= 3) continue;
                    LOGGER.error("Failed to save file after {} attempts: {}", new Object[]{3, file.getFileName(), e});
                    this.field_22787.execute(() -> {
                        if (this.field_22787.field_1755 != null && this.field_22787.field_1755.equals((Object)this)) {
                            this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.savefailed"));
                        }
                    });
                }
            }
            this.field_22787.execute(() -> {
                if (this.field_22787.field_1755 != null && this.field_22787.field_1755.equals((Object)this)) {
                    this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.fileretryfailed"));
                }
            });
        }).start();
    }

    private String getCurrentEditorText() {
        return this.currentEditor.getText();
    }

    private void openConfigFolder() {
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            LOGGER.info("Config folder location: {}", (Object)configDir);
            class_156.method_668().method_673(configDir.toUri());
        }
        catch (Exception e) {
            LOGGER.error("Failed to get config folder", (Throwable)e);
        }
    }

    private void showErrorPopup(class_2561 message) {
        this.field_22787.method_1507((class_437)new class_410(result -> {
            this.method_25419();
            this.field_22787.method_1507(null);
        }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), message));
    }

    public void showMessagePopup(class_2561 message) {
        this.field_22787.method_1507((class_437)new class_410(result -> {
            this.method_25419();
            this.field_22787.method_1507(null);
        }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), message));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (ConfigEditorClient.configManager.getConfig().doRenderBackground) {
            context.method_25294(0, 0, this.field_22789, this.field_22790, this.themeManager.getBackgroundColor());
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (!this.configFiles.isEmpty()) {
            Object status = this.modified ? "* " + this.configFiles.get(this.selectedIndex).getFileName().toString() : this.configFiles.get(this.selectedIndex).getFileName().toString();
            String editorType = this.isJsonFile ? " [JSON]" : " [Text]";
            context.method_51433(this.field_22793, (String)status + editorType, 170, 5, this.modified ? 0xFFFF00 : 0xFFFFFF, false);
        }
    }

    public boolean method_25422() {
        if (this.modified) {
            class_410 confirmScreen = new class_410(result -> {
                if (result) {
                    this.saveFileAsync(() -> {
                        this.method_25419();
                        this.field_22787.method_1507(null);
                    });
                } else {
                    this.method_25419();
                    this.field_22787.method_1507(null);
                }
            }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), (class_2561)class_2561.method_43471((String)"configeditor.confirm.unsavedclose"));
            this.field_22787.method_1507((class_437)confirmScreen);
            return false;
        }
        return true;
    }

    public class_339 getTextWidget() {
        return this.currentEditor;
    }

    private void toggleSearch() {
        this.searchVisible = !this.searchVisible;
        this.searchField.method_1862(this.searchVisible);
        this.searchNextButton.field_22764 = this.searchVisible;
        this.searchPrevButton.field_22764 = this.searchVisible;
        if (this.searchVisible) {
            this.method_25395((class_364)this.searchField);
            String searchText = this.searchField.method_1882();
            if (searchText != null && !searchText.trim().isEmpty()) {
                this.startSearch(searchText);
            }
        } else {
            this.endSearch();
        }
    }

    public void method_25419() {
        super.method_25419();
        this.configFiles = null;
        this.fileButtonList.clear();
        this.fileButtonList = null;
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onEditerClose(this);
        }
        LOGGER.info("Config editor closed");
    }

    public void method_25432() {
        super.method_25432();
        LOGGER.info("Config editor screen removed");
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74228() == 81 && input.method_74240() && input.method_74238()) {
            this.field_22787.method_1507(null);
            LOGGER.info("Config editor force closed by user shortcut");
            return true;
        }
        if (this.currentEditor == null) {
            return super.method_25404(input);
        }
        if (this.searchVisible) {
            if (input.method_74228() == 257) {
                this.startSearch(this.searchField.method_1882());
                return true;
            }
            if (input.method_74228() == 256) {
                this.toggleSearch();
                return true;
            }
            if (input.method_74228() == 292) {
                this.findNext();
                return true;
            }
        }
        if (input.method_74228() == 70 && input.method_74240()) {
            this.toggleSearch();
            return true;
        }
        return super.method_25404(input);
    }

    private void toggleTheme() {
        ModConfigData config = ConfigEditorClient.configManager.getConfig();
        switch (config.theme) {
            case DARK: {
                config.theme = ModConfigData.ThemeMode.LIGHT;
                break;
            }
            case LIGHT: {
                config.theme = ModConfigData.ThemeMode.AUTO;
                break;
            }
            case AUTO: {
                config.theme = ModConfigData.ThemeMode.DARK;
            }
        }
        ConfigEditorClient.configManager.save();
        this.themeToggleButton.method_25355((class_2561)class_2561.method_43471((String)this.getThemeButtonText()));
    }

    private String getThemeButtonText() {
        return switch (ConfigEditorClient.configManager.getConfig().theme) {
            default -> throw new MatchException(null, null);
            case ModConfigData.ThemeMode.DARK -> "configeditor.theme.dark";
            case ModConfigData.ThemeMode.LIGHT -> "configeditor.theme.light";
            case ModConfigData.ThemeMode.AUTO -> "configeditor.theme.auto";
        };
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        return super.method_25402(click, doubled);
    }
}

