/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui.widget;

import io.github.zhengzhengyiyi.api.FileType;
import io.github.zhengzhengyiyi.gui.widget.AbstractEditor;
import io.github.zhengzhengyiyi.util.TextSearchEngine;
import io.github.zhengzhengyiyi.util.highlighter.HighLighter;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class GeneralMultilineEditor
extends AbstractEditor {
    private final class_327 textRenderer;
    private boolean isDraggingHorizontalScroll = false;
    private int dragStartX = 0;
    private int dragStartScrollOffset = 0;
    public String text = "";
    private int scrollOffset = 0;
    private int horizontalScrollOffset = 0;
    public static int maxVisibleLines = 10;
    private boolean editable = true;
    private Consumer<String> changedListener;
    private int cursorPosition = 0;
    private long lastCursorBlinkTime = 0L;
    private boolean cursorVisible = true;
    private String filename = "";
    private int maxLineWidth = 0;
    public int lastCursorX = 0;
    private TextSearchEngine searchEngine = new TextSearchEngine();
    private boolean isSearching = false;
    public String searchQuery = "";
    private FileType fileType = FileType.TXT;

    public GeneralMultilineEditor(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
        this.textRenderer = class_310.method_1551().field_1772;
        this.method_25365(false);
    }

    public FileType getFileTypeFromName(String fileName) {
        String lowerName = fileName.toLowerCase();
        for (FileType type : FileType.values()) {
            String extension = "." + type.getExtension();
            if (!lowerName.endsWith(extension)) continue;
            return type;
        }
        return FileType.UNKNOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) {
            return;
        }
        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        try {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -16777216);
            String[] lines = this.text.split("\n", -1);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int maxVisibleLines = this.field_22759 / lineHeight;
            this.calculateMaxLineWidth(lines);
            if (this.isSearching && !this.searchQuery.isEmpty()) {
                this.renderSearchHighlights(context, lines, lineHeight, maxVisibleLines);
            }
            HighLighter highlighter = this.fileType.getHighLighter();
            for (int i = 0; i < lines.length; ++i) {
                if (i < this.scrollOffset || i >= this.scrollOffset + maxVisibleLines) continue;
                int yPos = this.method_46427() + 4 + (i - this.scrollOffset) * lineHeight;
                String lineNum = String.valueOf(i + 1);
                context.method_51433(this.textRenderer, lineNum, this.method_46426() + 2 - this.horizontalScrollOffset, yPos, -7829368, false);
                highlighter.drawHighlightedText(context, this.textRenderer, lines[i], this.method_46426() + 4 + 12 - this.horizontalScrollOffset, yPos, this.editable);
            }
            if (this.method_25370() && this.editable) {
                long currentTime = class_156.method_648();
                if (currentTime - this.lastCursorBlinkTime > 500000000L) {
                    this.cursorVisible = !this.cursorVisible;
                    this.lastCursorBlinkTime = currentTime;
                }
                if (this.cursorVisible) {
                    int lineIndex = 0;
                    int xPos = this.method_46426() + 4 + 12;
                    int remaining = this.cursorPosition;
                    for (int i = 0; i < lines.length; ++i) {
                        if (remaining <= lines[i].length()) {
                            xPos += highlighter.getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                            lineIndex = i;
                            break;
                        }
                        remaining -= lines[i].length() + 1;
                    }
                    if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                        int yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                        Objects.requireNonNull(this.textRenderer);
                        context.method_51742(xPos - this.horizontalScrollOffset, yPos - 1, yPos + 9 + 1, -1);
                    }
                }
            }
            this.renderScrollBars(context, lines.length, maxVisibleLines);
        }
        finally {
            context.method_44380();
        }
    }

    private void calculateMaxLineWidth(String[] lines) {
        this.maxLineWidth = 0;
        for (String line : lines) {
            int lineWidth = this.fileType.getHighLighter().getTextWidth(this.textRenderer, line);
            this.maxLineWidth = Math.max(this.maxLineWidth, lineWidth);
        }
    }

    private void renderScrollBars(class_332 context, int totalLines, int maxVisibleLines) {
        int scrollbarWidth = 5;
        if (totalLines > maxVisibleLines) {
            int scrollbarHeight = Math.max(20, (int)((float)this.field_22759 * (float)maxVisibleLines / (float)totalLines));
            int scrollbarY = this.method_46427() + (int)((float)(this.field_22759 - scrollbarHeight) * (float)this.scrollOffset / (float)(totalLines - maxVisibleLines));
            context.method_25294(this.method_46426() + this.field_22758 - scrollbarWidth, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -11184811);
            context.method_25294(this.method_46426() + this.field_22758 - scrollbarWidth + 1, scrollbarY, this.method_46426() + this.field_22758 - 1, scrollbarY + scrollbarHeight, -4473925);
        }
        if (this.maxLineWidth > this.field_22758 - 20) {
            int visibleWidth = this.field_22758 - 20;
            int scrollbarHeight = 5;
            int scrollbarX = this.method_46426() + (int)((float)(this.field_22758 - scrollbarWidth) * (float)this.horizontalScrollOffset / (float)(this.maxLineWidth - visibleWidth));
            int scrollbarY = this.method_46427() + this.field_22759 - scrollbarHeight;
            context.method_25294(this.method_46426(), this.method_46427() + this.field_22759 - scrollbarHeight, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, -11184811);
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + Math.max(20, (int)((float)this.field_22758 * (float)visibleWidth / (float)this.maxLineWidth)), scrollbarY + scrollbarHeight, -4473925);
        }
    }

    private void renderSearchHighlights(class_332 context, String[] lines, int lineHeight, int maxVisibleLines) {
        this.searchEngine.setScrollOffset(this.scrollOffset);
        int currentLineStart = 0;
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line = lines[lineIndex];
            if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                int yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                int xBase = this.method_46426() + 4 + 12 - this.horizontalScrollOffset;
                for (int matchPos : this.searchEngine.matchPositions) {
                    int matchEndInLine;
                    int matchInLine;
                    if (matchPos < currentLineStart || matchPos >= currentLineStart + line.length() || (matchInLine = matchPos - currentLineStart) >= (matchEndInLine = Math.min(matchInLine + this.searchQuery.length(), line.length()))) continue;
                    String beforeMatch = line.substring(0, matchInLine);
                    String matchText = line.substring(matchInLine, matchEndInLine);
                    int xStart = xBase + this.fileType.getHighLighter().getTextWidth(this.textRenderer, beforeMatch);
                    int highlightWidth = this.fileType.getHighLighter().getTextWidth(this.textRenderer, matchText);
                    Objects.requireNonNull(this.textRenderer);
                    int yStart = yPos + 9 - 1;
                    boolean isCurrentMatch = matchPos == this.searchEngine.getCurrentMatchPosition();
                    int color = isCurrentMatch ? 1728042752 : 0x66FFFF00;
                    context.method_25294(xStart, yStart, xStart + highlightWidth, yStart + 2, color);
                }
            }
            currentLineStart += line.length() + 1;
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseY;
        double mouseX = click.comp_4798();
        if (this.isMouseOverHorizontalScrollBar(mouseX, mouseY = click.comp_4799())) {
            this.isDraggingHorizontalScroll = true;
            this.dragStartX = (int)mouseX;
            this.dragStartScrollOffset = this.horizontalScrollOffset;
            return true;
        }
        if (this.method_25405(mouseX, mouseY) && this.editable) {
            this.method_25365(true);
            Objects.requireNonNull(this.textRenderer);
            int lineHeight = 9 + 2;
            int clickedY = (int)mouseY - (this.method_46427() + 4);
            int lineIndex = class_3532.method_15340((int)(clickedY / lineHeight + this.scrollOffset), (int)0, (int)(this.text.split("\n", -1).length - 1));
            String[] lines = this.text.split("\n", -1);
            String line = lines[lineIndex];
            int clickedX = (int)mouseX - (this.method_46426() + 4 + 12) + this.horizontalScrollOffset;
            int charIndex = this.fileType.getHighLighter().getCharIndexFromTokens(this.textRenderer, line, clickedX);
            int newPosition = 0;
            for (int i = 0; i < lineIndex; ++i) {
                newPosition += lines[i].length() + 1;
            }
            this.cursorPosition = class_3532.method_15340((int)(newPosition += charIndex), (int)0, (int)this.text.length());
            return true;
        }
        this.method_25365(false);
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9 + 2;
        int maxLines = this.text.split("\n", -1).length;
        int maxVisibleLines = this.field_22759 / lineHeight;
        int newScrollOffset = this.scrollOffset - (int)Math.signum(amount);
        this.scrollOffset = class_3532.method_15340((int)newScrollOffset, (int)0, (int)Math.max(0, maxLines - maxVisibleLines));
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.mouseScrolled(mouseX, mouseY, verticalAmount);
    }

    private boolean isMouseOverHorizontalScrollBar(double mouseX, double mouseY) {
        if (this.maxLineWidth <= this.field_22758 - 20) {
            return false;
        }
        int scrollbarHeight = 5;
        return mouseX >= (double)this.method_46426() && mouseX <= (double)(this.method_46426() + this.field_22758) && mouseY >= (double)(this.method_46427() + this.field_22759 - scrollbarHeight) && mouseY <= (double)(this.method_46427() + this.field_22759);
    }

    public boolean method_25404(class_11908 input) {
        if (!this.editable) {
            return false;
        }
        int keyCode = input.method_74228();
        if (keyCode == 259) {
            if (this.cursorPosition > 0) {
                this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                --this.cursorPosition;
                this.onTextChanged();
                this.updateCursorX();
            }
            return true;
        }
        if (keyCode == 261) {
            if (this.cursorPosition < this.text.length()) {
                this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                this.onTextChanged();
                this.updateCursorX();
            }
            return true;
        }
        if (keyCode == 263) {
            this.cursorPosition = class_3532.method_15340((int)(this.cursorPosition - 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            return true;
        }
        if (keyCode == 262) {
            this.cursorPosition = class_3532.method_15340((int)(this.cursorPosition + 1), (int)0, (int)this.text.length());
            this.updateCursorX();
            return true;
        }
        if (keyCode == 268) {
            this.cursorPosition = this.getLineStart(this.cursorPosition);
            this.updateCursorX();
            return true;
        }
        if (keyCode == 269) {
            this.cursorPosition = this.getLineEnd(this.cursorPosition);
            this.updateCursorX();
            return true;
        }
        if (keyCode == 265) {
            int prevLineEnd;
            int lineStart = this.getLineStart(this.cursorPosition);
            int currentX = this.cursorPosition - lineStart;
            int n = prevLineEnd = lineStart > 0 ? this.getLineEnd(lineStart - 1) : -1;
            if (prevLineEnd != -1) {
                int prevLineStart = this.getLineStart(prevLineEnd);
                int prevLineLength = prevLineEnd - prevLineStart;
                int newX = Math.min(currentX, prevLineLength);
                this.cursorPosition = prevLineStart + newX;
            }
            this.updateCursorX();
            return true;
        }
        if (keyCode == 264) {
            int nextLineStart;
            int lineEnd = this.getLineEnd(this.cursorPosition);
            int currentX = this.cursorPosition - this.getLineStart(this.cursorPosition);
            int n = nextLineStart = lineEnd < this.text.length() ? lineEnd + 1 : -1;
            if (nextLineStart != -1) {
                int nextLineEnd = this.getLineEnd(nextLineStart);
                int nextLineLength = nextLineEnd - nextLineStart;
                int newX = Math.min(currentX, nextLineLength);
                this.cursorPosition = nextLineStart + newX;
            }
            this.updateCursorX();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.text = this.text.substring(0, this.cursorPosition) + "\n" + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            return true;
        }
        return false;
    }

    public boolean method_25400(class_11905 input) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        if (input.method_74227()) {
            String chr = input.method_74226();
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.onTextChanged();
            this.updateCursorX();
            return true;
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.cursorPosition = class_3532.method_15340((int)this.cursorPosition, (int)0, (int)this.text.length());
        this.onTextChanged();
        this.updateCursorX();
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    private void onTextChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.text);
        }
    }

    private void updateCursorX() {
        int lineStart = this.getLineStart(this.cursorPosition);
        String currentLine = this.text.substring(lineStart, this.cursorPosition);
        this.lastCursorX = this.fileType.getHighLighter().getTextWidth(this.textRenderer, currentLine);
        int visibleWidth = this.field_22758 - 20;
        if (this.lastCursorX > this.horizontalScrollOffset + visibleWidth) {
            this.horizontalScrollOffset = this.lastCursorX - visibleWidth + 10;
        } else if (this.lastCursorX < this.horizontalScrollOffset) {
            this.horizontalScrollOffset = Math.max(0, this.lastCursorX - 10);
        }
    }

    private int getLineStart(int pos) {
        int start = this.text.lastIndexOf(10, pos - 1) + 1;
        return start;
    }

    private int getLineEnd(int pos) {
        int end = this.text.indexOf(10, pos);
        if (end == -1) {
            end = this.text.length();
        }
        return end;
    }

    @Override
    public void insertTextAtCursor(String text) {
        this.text = this.text.substring(0, this.cursorPosition) + text + this.text.substring(this.cursorPosition);
        this.cursorPosition += text.length();
        this.onTextChanged();
        this.updateCursorX();
    }

    @Override
    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    public void setCursorPosition(int position) {
        this.cursorPosition = class_3532.method_15340((int)position, (int)0, (int)this.text.length());
        this.updateCursorX();
    }

    public void setFileName(String v) {
        this.filename = v;
        this.fileType = this.getFileTypeFromName(v);
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public void startSearch(String query) {
        this.searchQuery = query;
        this.isSearching = true;
        this.searchEngine.search(query, this.text);
        if (this.searchEngine.hasMatches()) {
            this.scrollToCurrentMatch();
        }
    }

    @Override
    public void findNext() {
        if (this.isSearching && this.searchEngine.hasMatches()) {
            this.searchEngine.nextMatch();
            this.scrollToCurrentMatch();
        }
    }

    @Override
    public void findPrevious() {
        if (this.isSearching && this.searchEngine.hasMatches()) {
            this.searchEngine.previousMatch();
            this.scrollToCurrentMatch();
        }
    }

    private void scrollToCurrentMatch() {
        int lineIndex;
        Integer matchPos = this.searchEngine.getCurrentMatchPosition();
        if (matchPos != null && ((lineIndex = this.getLineIndex(matchPos)) < this.scrollOffset || lineIndex >= this.scrollOffset + maxVisibleLines)) {
            this.scrollOffset = Math.max(0, lineIndex - 2);
        }
    }

    @Override
    public void endSearch() {
        this.isSearching = false;
        this.searchQuery = "";
        this.searchEngine.clear();
    }

    private int getLineIndex(int position) {
        int line = 0;
        for (int i = 0; i < position && i < this.text.length(); ++i) {
            if (this.text.charAt(i) != '\n') continue;
            ++line;
        }
        return line;
    }

    @Override
    public boolean isSearching() {
        return this.isSearching;
    }

    @Override
    public int getSearchMatchCount() {
        return this.searchEngine.getMatchCount();
    }

    @Override
    public int getCurrentSearchIndex() {
        return this.searchEngine.getCurrentMatchIndex() + 1;
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (this.isDraggingHorizontalScroll) {
            int visibleWidth = this.field_22758 - 20;
            int dragDeltaX = (int)click.comp_4798() - this.dragStartX;
            int scrollRange = Math.max(0, this.maxLineWidth - visibleWidth);
            if (scrollRange > 0) {
                float scrollRatio = (float)dragDeltaX / (float)this.field_22758;
                int newScrollOffset = this.dragStartScrollOffset + (int)(scrollRatio * (float)scrollRange);
                this.horizontalScrollOffset = class_3532.method_15340((int)newScrollOffset, (int)0, (int)scrollRange);
            }
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25406(class_11909 click) {
        if (this.isDraggingHorizontalScroll) {
            this.isDraggingHorizontalScroll = false;
            return true;
        }
        return super.method_25406(click);
    }
}

