package io.github.zhengzhengyiyi.gui.widget;

import io.github.zhengzhengyiyi.ConfigEditorClient;
import io.github.zhengzhengyiyi.api.FileType;
import io.github.zhengzhengyiyi.config.ConfigManager;
import io.github.zhengzhengyiyi.util.*;
import io.github.zhengzhengyiyi.util.highlighter.HighLighter;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class MultilineEditor extends class_339 {
    private final class_327 textRenderer;
    private boolean isDraggingHorizontalScroll = false;
    private int dragStartX = 0;
    private int dragStartScrollOffset = 0;
    private String text = "";
    private int scrollOffset = 0;
    private int horizontalScrollOffset = 0;
    public static int maxVisibleLines = 10;
    private boolean editable = true;
    private FileType fileType = FileType.TXT;
    private Consumer<String> changedListener;
    private int cursorPosition = 0;
    private long lastCursorBlinkTime = 0;
    private boolean cursorVisible = true;
    private String filename = "";
    public List<JSONError> currentErrors = new ArrayList<>();
    public JSONError hoveredError = null;
    private TextSearchEngine searchEngine = new TextSearchEngine();
    private boolean isSearching = false;
    public String searchQuery = "";
    public int lastCursorX = 0;
    private List<String> currentSuggestions = new ArrayList<>();
    private int selectedSuggestion = -1;
    private boolean showSuggestions = false;
    private int maxLineWidth = 0;
    
    public FileType getFileTypeFromName(String fileName) {
        String lowerName = fileName.toLowerCase();
        
        for (FileType type : FileType.values()) {
            String extension = "." + type.getExtension();
            if (lowerName.endsWith(extension)) {
                return type;
            }
        }
        return FileType.UNKNOW;
    }

    public MultilineEditor(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
        this.textRenderer = class_310.method_1551().field_1772;
        this.method_25365(false);
        
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            editable = !ConfigManager.getConfig().readonly_mode;
        });
    }
    
    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) {
            return;
        }

        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        
        try {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xFF000000);
            context.method_49601(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, 0xFFFFFFFF);

            String[] lines = this.text.split("\n", -1);
            int lineHeight = this.textRenderer.field_2000 + 2;
            int maxVisibleLines = this.field_22759 / lineHeight;

            calculateMaxLineWidth(lines);
            
            HighLighter highlighter = fileType.getHighLighter();

            if (isSearching && !searchQuery.isEmpty()) {
                renderSearchHighlights(context, lines, lineHeight, maxVisibleLines);
            }

            for (int i = 0; i < lines.length; i++) {
                if (i >= this.scrollOffset && i < this.scrollOffset + maxVisibleLines) {
                    int yPos = this.method_46427() + 4 + (i - this.scrollOffset) * lineHeight;
                    String lineNum = String.valueOf(i + 1);
                    context.method_51433(textRenderer, lineNum, this.method_46426() + 2 - horizontalScrollOffset, yPos, 0xFF888888, false);
//                    JsonSyntaxHighlighter.drawHighlightedText(context, this.textRenderer, lines[i], this.getX() + 4 + 12 - horizontalScrollOffset, yPos, this.editable);
                    highlighter.drawHighlightedText(context, this.textRenderer, lines[i], this.method_46426() + 4 + 12 - horizontalScrollOffset, yPos, this.editable);
                }
            }
            
//            renderErrorUnderlines(context, lines, lineHeight, maxVisibleLines);

            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.renderButton(context, mouseX, mouseY, delta);
            }

            if (this.method_25370() && this.editable) {
                long currentTime = class_156.method_648();
                if (currentTime - lastCursorBlinkTime > 500000000) {
                    cursorVisible = !cursorVisible;
                    lastCursorBlinkTime = currentTime;
                }
                if (cursorVisible) {
                    int lineIndex = 0;
                    int xPos = this.method_46426() + 4 + 12;
                    int remaining = this.cursorPosition;
                    for (int i = 0; i < lines.length; i++) {
                        if (remaining <= lines[i].length()) {
                            xPos += highlighter.getTextWidthUpToChar(this.textRenderer, lines[i], remaining);
                            lineIndex = i;
                            break;
                        }
                        remaining -= (lines[i].length() + 1);
                    }
                    
                    if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                        int yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                        context.method_25301(xPos - horizontalScrollOffset, yPos - 1, yPos + this.textRenderer.field_2000 + 1, 0xFFFFFFFF);
                    }
                }
            }
            
            renderErrorTooltips(context, mouseX, mouseY, lines, lineHeight, maxVisibleLines);
            
            if (showSuggestions && !currentSuggestions.isEmpty()) {
                renderSuggestions(context, mouseX, mouseY);
            }

            renderScrollBars(context, lines.length, maxVisibleLines);
        } finally {
            context.method_44380();
        }
    }

    private void calculateMaxLineWidth(String[] lines) {
        maxLineWidth = 0;
        for (String line : lines) {
//            int lineWidth = highlighter.getTextWidth(this.textRenderer, line);
        	int lineWidth = fileType.getHighLighter().getTextWidth(textRenderer, line);
            maxLineWidth = Math.max(maxLineWidth, lineWidth);
        }
    }

    private void renderScrollBars(class_332 context, int totalLines, int maxVisibleLines) {
        int scrollbarWidth = 5;
        
        if (totalLines > maxVisibleLines) {
            int scrollbarHeight = Math.max(20, (int)((float)this.field_22759 * (float)maxVisibleLines / (float)totalLines));
            int scrollbarY = this.method_46427() + (int)((float)(this.field_22759 - scrollbarHeight) * (float)this.scrollOffset / (float)(totalLines - maxVisibleLines));
            context.method_25294(this.method_46426() + this.field_22758 - scrollbarWidth, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xFF555555);
            context.method_25294(this.method_46426() + this.field_22758 - scrollbarWidth + 1, scrollbarY, this.method_46426() + this.field_22758 - 1, scrollbarY + scrollbarHeight, 0xFFBBBBBB);
        }
        
        if (maxLineWidth > this.field_22758 - 20) {
            int visibleWidth = this.field_22758 - 20;
            int scrollbarHeight = 5;
            int scrollbarX = this.method_46426() + (int)((float)(this.field_22758 - scrollbarWidth) * (float)this.horizontalScrollOffset / (float)(maxLineWidth - visibleWidth));
            int scrollbarY = this.method_46427() + this.field_22759 - scrollbarHeight;
            
            context.method_25294(this.method_46426(), this.method_46427() + this.field_22759 - scrollbarHeight, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xFF555555);
            context.method_25294(scrollbarX, scrollbarY, scrollbarX + Math.max(20, (int)((float)this.field_22758 * (float)visibleWidth / (float)maxLineWidth)), scrollbarY + scrollbarHeight, 0xFFBBBBBB);
        }
    }

    private void renderSearchHighlights(class_332 context, String[] lines, int lineHeight, int maxVisibleLines) {
        searchEngine.setScrollOffset(this.scrollOffset);
        
        int currentLineStart = 0;
        for (int lineIndex = 0; lineIndex < lines.length; lineIndex++) {
            String line = lines[lineIndex];
            
            if (lineIndex >= scrollOffset && lineIndex < scrollOffset + maxVisibleLines) {
                int yPos = method_46427() + 4 + (lineIndex - scrollOffset) * lineHeight;
                int xBase = method_46426() + 4 + 12 - horizontalScrollOffset;
                
                for (int matchPos : searchEngine.matchPositions) {
                    if (matchPos >= currentLineStart && matchPos < currentLineStart + line.length()) {
                        int matchInLine = matchPos - currentLineStart;
                        int matchEndInLine = Math.min(matchInLine + searchQuery.length(), line.length());
                        
                        if (matchInLine < matchEndInLine) {
                            String beforeMatch = line.substring(0, matchInLine);
                            String matchText = line.substring(matchInLine, matchEndInLine);
                            
                            int xStart = xBase + textRenderer.method_1727(beforeMatch);
                            int highlightWidth = textRenderer.method_1727(matchText);
                            int yStart = yPos + textRenderer.field_2000 - 1;
                            
                            boolean isCurrentMatch = matchPos == searchEngine.getCurrentMatchPosition();
                            int color = isCurrentMatch ? 0x66FFD700 : 0x66FFFF00;
                            
                            context.method_25294(xStart, yStart, xStart + highlightWidth, yStart + 2, color);
                        }
                    }
                }
            }
            
            currentLineStart += line.length() + 1;
        }
    }
    
    private void renderErrorTooltips(class_332 context, int mouseX, int mouseY, String[] lines, int lineHeight, int maxVisibleLines) {
        hoveredError = null;
        
        if (method_25405(mouseX, mouseY)) {
            for (JSONError error : currentErrors) {
                if (isMouseOverError(mouseX, mouseY, error, lines, lineHeight, maxVisibleLines)) {
                    hoveredError = error;
                    String tooltip = "Line " + error.lineNumber + ", Col " + error.columnNumber + ": " + error.message;
                    context.method_51438(textRenderer, class_2561.method_43470(tooltip), mouseX, mouseY);
                    break;
                }
            }
        }
    }
    
    private void renderSuggestions(class_332 context, int mouseX, int mouseY) {
        int lineHeight = textRenderer.field_2000 + 2;
        String[] lines = text.split("\n", -1);
        
        int lineIndex = 0;
        int xPos = method_46426() + 4 + 12 - horizontalScrollOffset;
        int remaining = cursorPosition;
        for (int i = 0; i < lines.length; i++) {
            if (remaining <= lines[i].length()) {
                xPos += fileType.getHighLighter().getTextWidthUpToChar(textRenderer, lines[i], remaining);
                lineIndex = i;
                break;
            }
            remaining -= (lines[i].length() + 1);
        }
        
        int yPos = method_46427() + 4 + (lineIndex - scrollOffset) * lineHeight + textRenderer.field_2000;
        
        if (yPos + Math.min(currentSuggestions.size(), 5) * lineHeight > method_46427() + field_22759) {
            yPos = method_46427() + 4 + (lineIndex - scrollOffset) * lineHeight - Math.min(currentSuggestions.size(), 5) * lineHeight;
        }
        
        int suggestionHeight = Math.min(currentSuggestions.size(), 5) * lineHeight;
        int suggestionWidth = 200;
        
        context.method_25294(xPos, yPos, xPos + suggestionWidth, yPos + suggestionHeight, 0xFF333333);
        context.method_49601(xPos, yPos, suggestionWidth, suggestionHeight, 0xFFFFFFFF);
        
        int startIndex = Math.max(0, Math.min(selectedSuggestion - 2, currentSuggestions.size() - 5));
        int endIndex = Math.min(startIndex + 5, currentSuggestions.size());
        
        for (int i = startIndex; i < endIndex; i++) {
            int itemY = yPos + (i - startIndex) * lineHeight;
            if (i == selectedSuggestion) {
                context.method_25294(xPos, itemY, xPos + suggestionWidth, itemY + lineHeight, 0xFF555555);
            }
            context.method_51433(textRenderer, currentSuggestions.get(i), xPos + 2, itemY + 2, 0xFFFFFFFF, false);
        }
    }

    private boolean isMouseOverError(int mouseX, int mouseY, JSONError error, String[] lines, int lineHeight, int maxVisibleLines) {
        int lineIndex = error.lineNumber - 1;
        if (lineIndex >= scrollOffset && lineIndex < scrollOffset + maxVisibleLines) {
            int yPos = method_46427() + 4 + (lineIndex - scrollOffset) * lineHeight;
            if (mouseY >= yPos && mouseY <= yPos + textRenderer.field_2000) {
                String line = lines[lineIndex];
                int errorStartInLine = Math.min(error.startPosition - getLineStart(error.startPosition), line.length());
                int errorEndInLine = Math.min(error.endPosition - getLineStart(error.startPosition), line.length());
                
                if (errorStartInLine < errorEndInLine) {
                    String beforeError = line.substring(0, errorStartInLine);
                    int xStart = method_46426() + 4 + textRenderer.method_1727(beforeError) - horizontalScrollOffset;
                    int xEnd = xStart + textRenderer.method_1727(line.substring(errorStartInLine, errorEndInLine));
                    
                    return mouseX >= xStart && mouseX <= xEnd;
                }
            }
        }
        return false;
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (showSuggestions) {
            hideSuggestions();
            return true;
        }
        
        if (isMouseOverHorizontalScrollBar(mouseX, mouseY)) {
            isDraggingHorizontalScroll = true;
            dragStartX = (int) mouseX;
            dragStartScrollOffset = horizontalScrollOffset;
            return true;
        }
        
        if (showSuggestions && isMouseOverSuggestion(mouseX, mouseY)) {
            if (selectedSuggestion >= 0 && selectedSuggestion < currentSuggestions.size()) {
                insertSuggestion(currentSuggestions.get(selectedSuggestion));
                hideSuggestions();
                return true;
            }
        }
        
        if (this.method_25405(mouseX, mouseY) && this.editable) {
            this.method_25365(true);
            
            int lineHeight = this.textRenderer.field_2000 + 2;
            int clickedY = (int)mouseY - (this.method_46427() + 4);
            int lineIndex = class_3532.method_15340(clickedY / lineHeight + this.scrollOffset, 0, this.text.split("\n", -1).length - 1);
            
            String[] lines = this.text.split("\n", -1);
            String line = lines[lineIndex];
            
            int clickedX = (int)mouseX - (this.method_46426() + 4 + 12) + horizontalScrollOffset;
            
            int charIndex = fileType.getHighLighter().getCharIndexFromTokens(this.textRenderer, line, clickedX);
            
            int newPosition = 0;
            for (int i = 0; i < lineIndex; i++) {
                newPosition += lines[i].length() + 1;
            }
            newPosition += charIndex;
            
            this.cursorPosition = class_3532.method_15340(newPosition, 0, this.text.length());
            
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                class_1269 result = entrypoint.onMouseDown((int)Math.round(mouseX), (int)Math.round(mouseY));
                if (result == class_1269.field_5814) {
                    return true;
                }
            }
            
            updateSuggestions();
            return true;
        } else {
            this.method_25365(false);
            hideSuggestions();
            return false;
        }
    }

//    @Override
//    public boolean mouseClicked(double mouseX, double mouseY, int button) {
//        if (showSuggestions) {
//            hideSuggestions();
//            return true;
//        }
//        
//        if (isMouseOverHorizontalScrollBar(mouseX, mouseY)) {
//            return true;
//        }
//        
//        if (showSuggestions && isMouseOverSuggestion(mouseX, mouseY)) {
//            if (selectedSuggestion >= 0 && selectedSuggestion < currentSuggestions.size()) {
//                insertSuggestion(currentSuggestions.get(selectedSuggestion));
//                hideSuggestions();
//                return true;
//            }
//        }
//        
//        if (this.isMouseOver(mouseX, mouseY) && this.editable) {
//            this.setFocused(true);
//            
//            int lineHeight = this.textRenderer.fontHeight + 2;
//            int clickedY = (int)mouseY - (this.getY() + 4);
//            int lineIndex = MathHelper.clamp(clickedY / lineHeight + this.scrollOffset, 0, this.text.split("\n", -1).length - 1);
//            
//            String[] lines = this.text.split("\n", -1);
//            String line = lines[lineIndex];
//            
//            int clickedX = (int)mouseX - (this.getX() + 4 + 12) + horizontalScrollOffset;
//            
//            int charIndex = SyntaxHighlighter.getCharIndexFromTokens(this.textRenderer, line, clickedX);
//            
//            int newPosition = 0;
//            for (int i = 0; i < lineIndex; i++) {
//                newPosition += lines[i].length() + 1;
//            }
//            newPosition += charIndex;
//            
//            this.cursorPosition = MathHelper.clamp(newPosition, 0, this.text.length());
//            
//            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
//                ActionResult result = entrypoint.onMouseDown((int)Math.round(mouseX), (int)Math.round(mouseY));
//                if (result == ActionResult.FAIL) {
//                    return true;
//                }
//            }
//            
//            updateSuggestions();
//            return true;
//        } else {
//            this.setFocused(false);
//            hideSuggestions();
//            return false;
//        }
//    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (showSuggestions && isMouseOverSuggestion(mouseX, mouseY)) {
            if (amount < 0) {
                selectedSuggestion = Math.min(currentSuggestions.size() - 1, selectedSuggestion + 1);
            } else {
                selectedSuggestion = Math.max(0, selectedSuggestion - 1);
            }
            return true;
        }
        
        if (!this.method_25405(mouseX, mouseY)) return false;
        
        boolean shiftDown = class_437.method_25442();
        
        if (shiftDown) {
            int visibleWidth = this.field_22758 - 20;
            int newHorizontalScroll = this.horizontalScrollOffset - (int)(amount * 20);
            this.horizontalScrollOffset = class_3532.method_15340(newHorizontalScroll, 0, Math.max(0, maxLineWidth - visibleWidth));
            return true;
        } else {
            int lineHeight = this.textRenderer.field_2000 + 2;
            int maxLines = this.text.split("\n", -1).length;
            int maxVisibleLines = this.field_22759 / lineHeight;
            
            int newScrollOffset = this.scrollOffset - (int)Math.signum(amount);
            this.scrollOffset = class_3532.method_15340(newScrollOffset, 0, Math.max(0, maxLines - maxVisibleLines));
            
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onMouseScroll();
            }
            
            return true;
        }
    }
    
//    @Override
//    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
//        return this.mouseScrolled(mouseX, mouseY, verticalAmount);
//    }

    private boolean isMouseOverHorizontalScrollBar(double mouseX, double mouseY) {
        if (maxLineWidth <= this.field_22758 - 20) return false;
        
        int scrollbarHeight = 5;
        return mouseX >= this.method_46426() && mouseX <= this.method_46426() + this.field_22758 &&
               mouseY >= this.method_46427() + this.field_22759 - scrollbarHeight && mouseY <= this.method_46427() + this.field_22759;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        
        if (!ConfigManager.getConfig().doSuggestions) showSuggestions = false;
        
        for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            class_1269 result = entrypoint.onType(keyCode, scanCode, modifiers);
            if (result == class_1269.field_5814) {
                return true;
            }
        }

        boolean controlDown = class_437.method_25441();
//        boolean shiftDown = Screen.hasShiftDown();

        if (showSuggestions && keyCode != GLFW.GLFW_KEY_COMMA && keyCode != GLFW.GLFW_KEY_DELETE) {
            if (keyCode == GLFW.GLFW_KEY_UP) {
                selectedSuggestion = Math.max(0, selectedSuggestion - 1);
                return true;
            }
            if (keyCode == GLFW.GLFW_KEY_DOWN) {
                selectedSuggestion = Math.min(currentSuggestions.size() - 1, selectedSuggestion + 1);
                return true;
            }
            if (keyCode == GLFW.GLFW_KEY_ENTER || keyCode == GLFW.GLFW_KEY_TAB) {
                if (selectedSuggestion >= 0 && selectedSuggestion < currentSuggestions.size()) {
                    insertSuggestion(currentSuggestions.get(selectedSuggestion));
                    hideSuggestions();
                    return true;
                }
            }
            if (keyCode == GLFW.GLFW_KEY_ESCAPE) {
                hideSuggestions();
                return true;
            }
        }

        if (controlDown) {
            if (keyCode == GLFW.GLFW_KEY_V) {
                pasteFromClipboard();
                updateSuggestions();
                return true;
            }
            if (keyCode == GLFW.GLFW_KEY_C) {
                copyToClipboard();
                return true;
            }
            if (keyCode == GLFW.GLFW_KEY_SPACE) {
                updateSuggestions();
                return true;
            }
        }
        
        if (keyCode == GLFW.GLFW_KEY_LEFT) {
            this.cursorPosition = class_3532.method_15340(this.cursorPosition - 1, 0, this.text.length());
            updateCursorX();
            hideSuggestions();
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_RIGHT) {
            this.cursorPosition = class_3532.method_15340(this.cursorPosition + 1, 0, this.text.length());
            updateCursorX();
            hideSuggestions();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_HOME) {
            this.cursorPosition = getLineStart(this.cursorPosition);
            updateCursorX();
            hideSuggestions();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_END) {
            this.cursorPosition = getLineEnd(this.cursorPosition);
            updateCursorX();
            hideSuggestions();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_UP) {
            if (!showSuggestions) {
                int lineStart = getLineStart(this.cursorPosition);
                int currentX = this.cursorPosition - lineStart;
                
                int prevLineEnd = lineStart > 0 ? getLineEnd(lineStart - 1) : -1;
                if (prevLineEnd != -1) {
                    int prevLineStart = getLineStart(prevLineEnd);
                    int prevLineLength = prevLineEnd - prevLineStart;
                    int newX = Math.min(currentX, prevLineLength);
                    this.cursorPosition = prevLineStart + newX;
                }
                updateCursorX();
                for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                    entrypoint.onType(keyCode, scanCode, modifiers);
                }
            }
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_DOWN) {
            if (!showSuggestions) {
                int lineEnd = getLineEnd(this.cursorPosition);
                int currentX = this.cursorPosition - getLineStart(this.cursorPosition);
                
                int nextLineStart = lineEnd < this.text.length() ? lineEnd + 1 : -1;
                if (nextLineStart != -1) {
                    int nextLineEnd = getLineEnd(nextLineStart);
                    int nextLineLength = nextLineEnd - nextLineStart;
                    int newX = Math.min(currentX, nextLineLength);
                    this.cursorPosition = nextLineStart + newX;
                }
                updateCursorX();
                for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                    entrypoint.onType(keyCode, scanCode, modifiers);
                }
            }
            return true;
        }

        if (keyCode == GLFW.GLFW_KEY_BACKSPACE) {
            if (this.cursorPosition > 0) {
                this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                this.cursorPosition--;
                this.onTextChanged();
                updateCursorX();
                updateSuggestions();
            }
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }

        if (keyCode == GLFW.GLFW_KEY_DELETE) {
            if (this.cursorPosition < this.text.length()) {
                this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                this.onTextChanged();
                updateCursorX();
                updateSuggestions();
            }
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        
        if (keyCode == GLFW.GLFW_KEY_ENTER || keyCode == GLFW.GLFW_KEY_KP_ENTER) {
            this.text = this.text.substring(0, this.cursorPosition) + "\n" + this.text.substring(this.cursorPosition);
            this.cursorPosition++;
            this.onTextChanged();
            updateCursorX();
            hideSuggestions();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }

        return false;
    }
    
    @Override
    public boolean method_25400(char chr, int modifiers) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        
        if (!ConfigManager.getConfig().doSuggestions) showSuggestions = false;
        
        for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            class_1269 result = entrypoint.onCharTyped(chr, modifiers);
            if (result == class_1269.field_5814) {
                return true;
            }
        }
        
        if (chr >= 32 && chr != 127) {
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            this.cursorPosition++;
            this.onTextChanged();
            updateCursorX();
            
            if (chr != ',' && chr != '\n' && chr != '\r') {
                updateSuggestions();
            } else {
                hideSuggestions();
            }

            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(chr, 0, modifiers);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    public String getText() {
        return this.text;
    }
    
    public void setText(String text) {
        this.text = text;
        this.cursorPosition = class_3532.method_15340(this.cursorPosition, 0, this.text.length());
        this.onTextChanged();
        updateCursorX();
        hideSuggestions();
    }
    
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    private void onTextChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.text);
        }
        validateJSON();
    }
    
    public void renderErrorUnderlines(class_332 context, String[] lines, int lineHeight, int maxVisibleLines) {
        for (JSONError error : currentErrors) {
            int lineIndex = error.lineNumber - 1;
            if (lineIndex >= scrollOffset && lineIndex < scrollOffset + maxVisibleLines) {
                int yPos = method_46427() + 4 + (lineIndex - scrollOffset) * lineHeight;
                
                String line = lines[lineIndex];
                int errorStartInLine = Math.min(error.startPosition - getLineStart(error.startPosition), line.length());
                int errorEndInLine = Math.min(error.endPosition - getLineStart(error.startPosition), line.length());
                
                if (errorStartInLine < errorEndInLine) {
                    String beforeError = line.substring(0, errorStartInLine);
                    String errorText = line.substring(errorStartInLine, errorEndInLine);
                    
                    int xStart = method_46426() + 4 + textRenderer.method_1727(beforeError) - horizontalScrollOffset;
                    int errorWidth = textRenderer.method_1727(errorText);
                    
                    for (int i = 0; i < errorWidth; i += 3) {
                        int x = xStart + i;
                        if (i + 2 <= errorWidth) {
                            context.method_25292(x, x + 2 + 12, yPos + textRenderer.field_2000 + 1, 0xFFFF0000);
                        }
                    }
                }
            }
        }
    }
    
    public void validateJSON() {
        this.currentErrors = JSONValidator.validateJSON(this.text);
    }
    
    private void updateCursorX() {
        int lineStart = getLineStart(this.cursorPosition);
        String currentLine = this.text.substring(lineStart, this.cursorPosition);
        this.lastCursorX = this.textRenderer.method_1727(currentLine);
        
        int visibleWidth = this.field_22758 - 20;
        if (lastCursorX > horizontalScrollOffset + visibleWidth) {
            horizontalScrollOffset = lastCursorX - visibleWidth + 10;
        } else if (lastCursorX < horizontalScrollOffset) {
            horizontalScrollOffset = Math.max(0, lastCursorX - 10);
        }
    }

    private int getLineStart(int pos) {
        int start = this.text.lastIndexOf('\n', pos - 1) + 1;
        return start;
    }

    private int getLineEnd(int pos) {
        int end = this.text.indexOf('\n', pos);
        if (end == -1) {
            end = this.text.length();
        }
        return end;
    }

    private void copyToClipboard() {
        class_310.method_1551().field_1774.method_1455(this.text);
    }

    private void pasteFromClipboard() {
        String clipboardText = class_310.method_1551().field_1774.method_1460();
        if (clipboardText != null) {
            this.text = this.text.substring(0, this.cursorPosition) + clipboardText + this.text.substring(this.cursorPosition);
            this.cursorPosition += clipboardText.length();
            this.onTextChanged();
            updateCursorX();
        }
    }
    
    public void insertTextAtCursor(String text) {
        this.text = this.text.substring(0, this.cursorPosition) + text + this.text.substring(this.cursorPosition);
        this.cursorPosition += text.length();
        this.onTextChanged();
        updateCursorX();
        hideSuggestions();
    }
    
    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = class_3532.method_15340(position, 0, this.text.length());
        updateCursorX();
        hideSuggestions();
    }
    
    public void setFileName(String v) {
        this.filename = v;
        this.fileType = getFileTypeFromName(v);
    }
    
    public String getFileName() {
        return this.filename;
    }
    
    public void startSearch(String query) {
        this.searchQuery = query;
        this.isSearching = true;
        searchEngine.search(query, text);
        if (searchEngine.hasMatches()) {
            scrollToCurrentMatch();
        }
        hideSuggestions();
    }
    
    public void findNext() {
        if (isSearching && searchEngine.hasMatches()) {
            searchEngine.nextMatch();
            scrollToCurrentMatch();
        }
    }
    
    public void findPrevious() {
        if (isSearching && searchEngine.hasMatches()) {
            searchEngine.previousMatch();
            scrollToCurrentMatch();
        }
    }
    
    private void scrollToCurrentMatch() {
        Integer matchPos = searchEngine.getCurrentMatchPosition();
        if (matchPos != null) {
            int lineIndex = getLineIndex(matchPos);
            if (lineIndex < scrollOffset || lineIndex >= scrollOffset + maxVisibleLines) {
                scrollOffset = Math.max(0, lineIndex - 2);
            }
        }
    }
    
    public void endSearch() {
        isSearching = false;
        searchQuery = "";
        searchEngine.clear();
    }
    
    private int getLineIndex(int position) {
        int line = 0;
        for (int i = 0; i < position && i < text.length(); i++) {
            if (text.charAt(i) == '\n') {
                line++;
            }
        }
        return line;
    }
    
    public boolean isSearching() {
        return isSearching;
    }
    
    public int getSearchMatchCount() {
        return searchEngine.getMatchCount();
    }
    
    public int getCurrentSearchIndex() {
        return searchEngine.getCurrentMatchIndex() + 1;
    }
    
    private void updateSuggestions() {
        if (!ConfigManager.getConfig().doSuggestions) {
            hideSuggestions();
            return;
        }
        currentSuggestions = CodeSuggester.suggestForPosition(text, cursorPosition);
        showSuggestions = !currentSuggestions.isEmpty();
        selectedSuggestion = showSuggestions ? 0 : -1;
    }
    
    private void hideSuggestions() {
        showSuggestions = false;
        currentSuggestions.clear();
        selectedSuggestion = -1;
    }
    
    private void insertSuggestion(String suggestion) {
        insertTextAtCursor(suggestion);
        hideSuggestions();
    }
    
    private boolean isMouseOverSuggestion(double mouseX, double mouseY) {
        if (!showSuggestions) return false;
        
        int lineHeight = textRenderer.field_2000 + 2;
        String[] lines = text.split("\n", -1);
        
        int lineIndex = 0;
        int xPos = method_46426() + 4 + 12 - horizontalScrollOffset;
        int remaining = cursorPosition;
        for (int i = 0; i < lines.length; i++) {
            if (remaining <= lines[i].length()) {
                xPos += fileType.getHighLighter().getTextWidthUpToChar(textRenderer, lines[i], remaining);
                lineIndex = i;
                break;
            }
            remaining -= (lines[i].length() + 1);
        }
        
        int yPos = method_46427() + 4 + (lineIndex - scrollOffset) * lineHeight + textRenderer.field_2000;
        int suggestionHeight = Math.min(currentSuggestions.size(), 5) * lineHeight;
        int suggestionWidth = 200;
        
        return mouseX >= xPos && mouseX <= xPos + suggestionWidth &&
               mouseY >= yPos && mouseY <= yPos + suggestionHeight;
    }
    
    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (isDraggingHorizontalScroll) {
            int visibleWidth = this.field_22758 - 20;
            int dragDeltaX = (int) mouseX - dragStartX;
            int scrollRange = Math.max(0, maxLineWidth - visibleWidth);
            
            if (scrollRange > 0) {
                float scrollRatio = (float) dragDeltaX / (float) this.field_22758;
                int newScrollOffset = dragStartScrollOffset + (int) (scrollRatio * scrollRange);
                horizontalScrollOffset = class_3532.method_15340(newScrollOffset, 0, scrollRange);
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (isDraggingHorizontalScroll) {
            isDraggingHorizontalScroll = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }
}
