package io.github.zhengzhengyiyi.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;

import io.github.zhengzhengyiyi.util.BackupHelper;
import io.github.zhengzhengyiyi.gui.widget.MultilineEditorWidget;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.ArrayList;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorScreen extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorScreen.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private List<Path> configFiles;
    private int selectedIndex = 0;
    private MultilineEditorWidget multilineEditor;
    private boolean modified = false;
    private class_4185 saveButton;
    private class_4185 openFolderButton;
    private class_4185 backupButton;
    private String buffer = "";

    public EditorScreen() {
        super(class_2561.method_43471("zhengzhengyiyi.configeditor.title"));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            configFiles = Files.list(configDir)
                    .filter(Files::isRegularFile)
                    .filter(path -> path.toString().endsWith(".json"))
                    .collect(Collectors.toList());
            LOGGER.info("Found {} config files", configFiles.size());
        } catch (Exception e) {
            configFiles = new ArrayList<>();
            LOGGER.error("Failed to list config files", e);
        }

        int buttonY = 20;
        for (int i = 0; i < configFiles.size(); i++) {
            int index = i;
            Path file = configFiles.get(i);
            String fileName = file.getFileName().toString();
            
            this.method_37063(class_4185.method_46430(
                    class_2561.method_43470(fileName.length() > 20 ? fileName.substring(0, 17) + "..." : fileName),
                    button -> switchFile(index))
                    .method_46434(10, buttonY, 150, 20)
                    .method_46431());
            buttonY += 25;
        }

        saveButton = class_4185.method_46430(
                class_2561.method_43471("zhengzhengyiyi.configeditor.save"),
                button -> saveFile())
                .method_46434(this.field_22789 - 170, this.field_22790 - 30, 80, 20)
                .method_46431();
        this.method_37063(saveButton);
        
        backupButton = class_4185.method_46430(class_2561.method_43471("zhengzhengyiyi.configeditor.backup"), button -> BackupHelper.backupEntireConfigDirectory())
        		.method_46434(0, 0, 70, 20)
        		.method_46431();
        this.method_37063(backupButton);

        openFolderButton = class_4185.method_46430(
                class_2561.method_43471("zhengzhengyiyi.configeditor.openfolder"),
                button -> openConfigFolder())
                .method_46434(this.field_22789 - 80, this.field_22790 - 30, 70, 20)
                .method_46431();
        this.method_37063(openFolderButton);

        multilineEditor = new MultilineEditorWidget(
                170, 20, 
                this.field_22789 - 180, this.field_22790 - 60,
                class_2561.method_43471("zhengzhengyiyi.configeditor.editor"));
        multilineEditor.setChangedListener(text -> {
        	if (!buffer.equals(text)) {
	            modified = true;
	            updateButtonStates();
        	} else {
        		modified = false;
        	}
        });
        
        // 修正：将 multilineEditor 作为可绘制子组件添加
        this.method_37063(multilineEditor);
        this.method_48265(multilineEditor);

        if (!configFiles.isEmpty()) {
            loadFile(selectedIndex);
        } else {
            multilineEditor.setText("{}");
            multilineEditor.setEditable(false);
            LOGGER.warn("No config files found in config directory");
        }
        
        updateButtonStates();
    }

    private void updateButtonStates() {
        saveButton.field_22763 = modified && !configFiles.isEmpty();
    }

    private void switchFile(int index) {
        if (modified) {
            class_410 confirmScreen = new class_410(
                result -> {
                    if (result) {
                        saveFileAsync(() -> loadFile(index));
                        this.field_22787.method_1507(null);
                        this.field_22787.method_1507(this);
                    } else {
                        loadFile(index);
                        this.field_22787.method_1507(null);
                        this.field_22787.method_1507(this);
                    }
                },
                class_2561.method_43471("zhengzhengyiyi.confirm.title"),
                class_2561.method_43471("zhengzhengyiyi.confirm.unsaved")
            );
            this.field_22787.method_1507(confirmScreen);
        } else {
            loadFile(index);
        }
    }

    private void loadFile(int index) {
        if (index < 0 || index >= configFiles.size()) {
            LOGGER.error("Invalid file index: {}", index);
            return;
        }
        
        selectedIndex = index;
        modified = false;
        Path file = configFiles.get(index);
        
        try {
            String content = Files.readString(file);
            buffer = content;
            JsonElement json = JsonParser.parseString(content);
            String formattedContent = GSON.toJson(json);
            multilineEditor.setText(formattedContent);
            LOGGER.info("Successfully loaded config file: {}", file.getFileName());
        } catch (Exception e) {
            LOGGER.error("Failed to load config file: {}", file.getFileName(), e);
            multilineEditor.setText("{}");
            multilineEditor.setEditable(false);
            showErrorPopup(class_2561.method_43471("zhengzhengyiyi.error.loadfailed"));
        }
        
        updateButtonStates();
    }

    private void saveFile() {
        saveFileAsync(null);
    }

    private void saveFileAsync(Runnable callback) {
        if (configFiles.isEmpty()) return;
        
        Path file = configFiles.get(selectedIndex);
        String content = multilineEditor.getText();
        
        try {
            JsonParser.parseString(content);
        } catch (JsonSyntaxException e) {
            LOGGER.warn("Invalid JSON syntax in file: {}", file.getFileName());
            showErrorPopup(class_2561.method_43471("zhengzhengyiyi.error.invalidjson"));
            return;
        }
        
        new Thread(() -> {
            try {
                Files.writeString(file, content);
                modified = false;
                LOGGER.info("Successfully saved config file: {}", file.getFileName());
                
                if (callback != null) {
                    field_22787.execute(callback);
                } else {
                    field_22787.execute(() -> {
                        updateButtonStates();
                        showMessagePopup(class_2561.method_43471("zhengzhengyiyi.message.saved"));
                    });
                }
            } catch (Exception e) {
                LOGGER.error("Failed to save config file: {}", file.getFileName(), e);
                field_22787.execute(() -> 
                    showErrorPopup(class_2561.method_43471("zhengzhengyiyi.error.savefailed")));
            }
        }).start();
    }
    
    private void openConfigFolder() {
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            LOGGER.info("Config folder location: {}", configDir);
            class_156.method_668().method_673(configDir.toUri());
        } catch (Exception e) {
            LOGGER.error("Failed to get config folder", e);
        }
    }

    private void showErrorPopup(class_2561 message) {
    	field_22787.method_1507(new class_410(
        	result -> {
        		this.method_25419();
           		this.field_22787.method_1507(null);
           	},
            class_2561.method_43471("zhengzhengyiyi.confirm.title"),
            class_2561.method_43471("zhengzhengyiyi.error.title")
        ));
    }

    private void showMessagePopup(class_2561 message) {
        field_22787.method_1507(new class_410(
        	result -> {
        		this.method_25419();
        		this.field_22787.method_1507(null);
        	},
            class_2561.method_43471("zhengzhengyiyi.confirm.title"),
            class_2561.method_43471("zhengzhengyiyi.message.title")
        ));
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        
        context.method_51439(this.field_22793, 
            class_2561.method_43471("zhengzhengyiyi.configeditor.title"), 
            this.field_22789 / 2 - 50, 5, 0xFFFFFF, true);
        
        if (!configFiles.isEmpty()) {
            String status = modified ? "* " + configFiles.get(selectedIndex).getFileName().toString() : 
                configFiles.get(selectedIndex).getFileName().toString();
            context.method_51433(this.field_22793, status, 170, 5, modified ? 0xFF5555 : 0xFFFFFF, false);
        }
    }

    @Override
    public boolean method_25422() {
        if (modified) {
            class_410 confirmScreen = new class_410(
                result -> {
                    if (result) {
                        saveFileAsync(() -> {this.method_25419(); this.field_22787.method_1507(null);});
                    } else {
                        this.method_25419();
                        this.field_22787.method_1507(null);
                    }
                },
                class_2561.method_43471("zhengzhengyiyi.confirm.title"),
                class_2561.method_43471("zhengzhengyiyi.confirm.unsavedclose")
            );
            this.field_22787.method_1507(confirmScreen);
            return false;
        }
        return true;
    }

    @Override
    public void method_25419() {
        super.method_25419();
        LOGGER.info("Config editor closed");
    }

    @Override
    public void method_25432() {
        super.method_25432();
        LOGGER.info("Config editor screen removed");
    }
}
