/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util.highlighter;

import io.github.zhengzhengyiyi.util.highlighter.HighLighter;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class PropertiesSyntaxHighlighter
implements HighLighter {
    @Override
    public int getCharIndexFromTokens(class_327 textRenderer, String line, int targetX) {
        if (line.isEmpty()) {
            return 0;
        }
        for (int i = 0; i <= line.length(); ++i) {
            int width = this.getTextWidthUpToChar(textRenderer, line, i);
            if (width < targetX) continue;
            return i;
        }
        return line.length();
    }

    @Override
    public int getTextWidthUpToChar(class_327 textRenderer, String line, int charIndex) {
        if (line.isEmpty() || charIndex <= 0) {
            return 0;
        }
        List<Token> tokens = this.tokenizeLine(line);
        int currentCharIndex = 0;
        int totalWidth = 0;
        for (Token token : tokens) {
            int tokenLength = token.content.length();
            if (currentCharIndex + tokenLength >= charIndex) {
                int charsInThisToken = charIndex - currentCharIndex;
                if (charsInThisToken <= 0) break;
                totalWidth += textRenderer.method_1727(token.content.substring(0, charsInThisToken));
                break;
            }
            totalWidth += textRenderer.method_1727(token.content);
            currentCharIndex += tokenLength;
        }
        return totalWidth;
    }

    @Override
    public void drawHighlightedText(class_332 context, class_327 textRenderer, String text, int x, int y, boolean editable) {
        if (text.isEmpty()) {
            return;
        }
        List<Token> tokens = this.tokenizeLine(text);
        int currentX = x;
        for (Token token : tokens) {
            int color = this.getTokenColor(token.type, editable);
            context.method_51433(textRenderer, token.content, currentX, y, color, false);
            currentX += textRenderer.method_1727(token.content);
        }
    }

    private List<Token> tokenizeLine(String line) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (line.isEmpty()) {
            return tokens;
        }
        if (line.trim().startsWith("#") || line.trim().startsWith("!")) {
            tokens.add(new Token(TokenType.COMMENT, line));
            return tokens;
        }
        if (line.trim().startsWith("[") && line.trim().endsWith("]")) {
            tokens.add(new Token(TokenType.SECTION_HEADER, line));
            return tokens;
        }
        int equalsIndex = line.indexOf(61);
        if (equalsIndex == -1) {
            tokens.add(new Token(TokenType.TEXT, line));
            return tokens;
        }
        String beforeEquals = line.substring(0, equalsIndex);
        String afterEquals = line.substring(equalsIndex + 1);
        String keyPart = beforeEquals.trim();
        int keyStart = beforeEquals.indexOf(keyPart);
        if (keyStart > 0) {
            tokens.add(new Token(TokenType.TEXT, beforeEquals.substring(0, keyStart)));
        }
        if (!keyPart.isEmpty()) {
            tokens.add(new Token(TokenType.KEY, keyPart));
        }
        tokens.add(new Token(TokenType.EQUALS, "="));
        if (!afterEquals.isEmpty()) {
            tokens.add(new Token(TokenType.VALUE, afterEquals));
        }
        return tokens;
    }

    @Override
    public int getTextWidth(class_327 textRenderer, String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        List<Token> tokens = this.tokenizeLine(text);
        int totalWidth = 0;
        for (Token token : tokens) {
            totalWidth += textRenderer.method_1727(token.content);
        }
        return totalWidth;
    }

    private int getTokenColor(TokenType type, boolean editable) {
        int defaultColor = editable ? -1 : -5592406;
        switch (type.ordinal()) {
            case 0: {
                return -9791147;
            }
            case 4: {
                return -10496;
            }
            case 1: {
                return -10694413;
            }
            case 2: {
                return -5592406;
            }
            case 3: {
                return -1647756;
            }
        }
        return defaultColor;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Token {
        public final TokenType type;
        public final String content;

        public Token(TokenType type, String content) {
            this.type = type;
            this.content = content;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TokenType {
        COMMENT,
        KEY,
        EQUALS,
        VALUE,
        SECTION_HEADER,
        TEXT;

    }
}

