/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util.highlighter;

import io.github.zhengzhengyiyi.util.highlighter.HighLighter;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class TextSyntaxHighlighter
implements HighLighter {
    @Override
    public int getCharIndexFromTokens(class_327 textRenderer, String line, int targetX) {
        if (line.isEmpty()) {
            return 0;
        }
        for (int i = 0; i <= line.length(); ++i) {
            int width = this.getTextWidthUpToChar(textRenderer, line, i);
            if (width < targetX) continue;
            return i;
        }
        return line.length();
    }

    @Override
    public int getTextWidthUpToChar(class_327 textRenderer, String line, int charIndex) {
        if (line.isEmpty() || charIndex <= 0) {
            return 0;
        }
        List<Token> tokens = this.tokenizeLine(line);
        int currentCharIndex = 0;
        int totalWidth = 0;
        for (Token token : tokens) {
            int tokenLength = token.content.length();
            if (currentCharIndex + tokenLength >= charIndex) {
                int charsInThisToken = charIndex - currentCharIndex;
                if (charsInThisToken <= 0) break;
                totalWidth += textRenderer.method_1727(token.content.substring(0, charsInThisToken));
                break;
            }
            totalWidth += textRenderer.method_1727(token.content);
            currentCharIndex += tokenLength;
        }
        return totalWidth;
    }

    @Override
    public void drawHighlightedText(class_332 context, class_327 textRenderer, String text, int x, int y, boolean editable) {
        if (text.isEmpty()) {
            return;
        }
        List<Token> tokens = this.tokenizeLine(text);
        int currentX = x;
        for (Token token : tokens) {
            int color = this.getTokenColor(token.type, editable);
            context.method_51433(textRenderer, token.content, currentX, y, color, false);
            currentX += textRenderer.method_1727(token.content);
        }
    }

    private List<Token> tokenizeLine(String line) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (line.isEmpty()) {
            return tokens;
        }
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith("#") || trimmedLine.startsWith("//")) {
            tokens.add(new Token(TokenType.COMMENT, line));
            return tokens;
        }
        StringBuilder currentToken = new StringBuilder();
        boolean inQuotes = false;
        char quoteChar = '\"';
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"' || c == '\'') {
                if (!inQuotes) {
                    if (currentToken.length() > 0) {
                        tokens.add(this.createToken(currentToken.toString()));
                        currentToken.setLength(0);
                    }
                    inQuotes = true;
                    quoteChar = c;
                } else if (c == quoteChar) {
                    inQuotes = false;
                    if (currentToken.length() <= 0) continue;
                    tokens.add(new Token(TokenType.QUOTED_TEXT, currentToken.toString()));
                    currentToken.setLength(0);
                    continue;
                }
            }
            if (inQuotes) {
                currentToken.append(c);
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (currentToken.length() > 0) {
                    tokens.add(this.createToken(currentToken.toString()));
                    currentToken.setLength(0);
                }
                tokens.add(new Token(TokenType.TEXT, String.valueOf(c)));
                continue;
            }
            if (this.isBracket(c)) {
                if (currentToken.length() > 0) {
                    tokens.add(this.createToken(currentToken.toString()));
                    currentToken.setLength(0);
                }
                tokens.add(new Token(TokenType.BRACKET, String.valueOf(c)));
                continue;
            }
            if (this.isSymbol(c)) {
                if (currentToken.length() > 0) {
                    tokens.add(this.createToken(currentToken.toString()));
                    currentToken.setLength(0);
                }
                tokens.add(new Token(TokenType.SYMBOL, String.valueOf(c)));
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            tokens.add(this.createToken(currentToken.toString()));
        }
        return tokens;
    }

    private Token createToken(String text) {
        if (text.startsWith("#") || text.startsWith("//")) {
            return new Token(TokenType.COMMENT, text);
        }
        if (this.isHeader(text)) {
            return new Token(TokenType.HEADER, text);
        }
        if (this.isNumber(text)) {
            return new Token(TokenType.NUMBER, text);
        }
        if (this.isURL(text)) {
            return new Token(TokenType.URL, text);
        }
        if (this.isEmail(text)) {
            return new Token(TokenType.EMAIL, text);
        }
        return new Token(TokenType.TEXT, text);
    }

    private boolean isHeader(String text) {
        return text.length() > 0 && Character.isUpperCase(text.charAt(0)) && text.length() < 50 && (double)text.chars().filter(Character::isUpperCase).count() > (double)text.length() * 0.3;
    }

    private boolean isNumber(String text) {
        return text.matches("-?\\d+(\\.\\d+)?([eE][+-]?\\d+)?%?");
    }

    private boolean isURL(String text) {
        return text.matches("(https?|ftp)://[^\\s]+") || text.matches("www\\.[^\\s]+\\.[^\\s]+") || text.matches("[^\\s]+\\.[a-z]{2,}(/\\S*)?");
    }

    private boolean isEmail(String text) {
        return text.matches("\\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Z|a-z]{2,}\\b");
    }

    private boolean isBracket(char c) {
        return c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}';
    }

    private boolean isSymbol(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '=' || c == '<' || c == '>' || c == '!' || c == '?' || c == ':' || c == ';' || c == '.' || c == ',' || c == '&' || c == '|' || c == '^' || c == '~' || c == '@' || c == '#' || c == '$' || c == '%';
    }

    @Override
    public int getTextWidth(class_327 textRenderer, String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        List<Token> tokens = this.tokenizeLine(text);
        int totalWidth = 0;
        for (Token token : tokens) {
            totalWidth += textRenderer.method_1727(token.content);
        }
        return totalWidth;
    }

    private int getTokenColor(TokenType type, boolean editable) {
        int defaultColor = editable ? -1 : -5592406;
        switch (type.ordinal()) {
            case 0: {
                return -9791147;
            }
            case 1: {
                return -10496;
            }
            case 2: {
                return -5340673;
            }
            case 3: {
                return -10036753;
            }
            case 4: {
                return -5840338;
            }
            case 5: {
                return -1647756;
            }
            case 6: {
                return -448910;
            }
            case 7: {
                return -157921;
            }
        }
        return defaultColor;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Token {
        public final TokenType type;
        public final String content;

        public Token(TokenType type, String content) {
            this.type = type;
            this.content = content;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum TokenType {
        COMMENT,
        HEADER,
        NUMBER,
        URL,
        EMAIL,
        QUOTED_TEXT,
        BRACKET,
        SYMBOL,
        TEXT;

    }
}

