/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.EditorScreen;
import java.util.Stack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class UndoRedoEntrypoint
implements ApiEntrypoint {
    private boolean enabled = true;
    private EditorScreen editor;
    private Stack<String> undoStack = new Stack();
    private Stack<String> redoStack = new Stack();
    private String lastText = "";

    @Override
    public void init() {
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
        if (editor.getTextWidget() != null) {
            this.lastText = editor.getTextWidget().getText();
            this.undoStack.push(this.lastText);
        }
    }

    @Override
    public void onEditerClose(EditorScreen editor) {
        this.editor = null;
        this.undoStack.clear();
        this.redoStack.clear();
    }

    @Override
    public class_1269 onMouseDown(int x, int y) {
        return class_1269.field_5812;
    }

    @Override
    public void onMouseScroll() {
    }

    @Override
    public class_1269 onType(int keyCode, int scanCode, int modifiers) {
        if (!this.enabled || this.editor == null || this.editor.getTextWidget() == null) {
            return class_1269.field_5811;
        }
        String currentText = this.editor.getTextWidget().getText();
        if (!currentText.equals(this.lastText)) {
            this.undoStack.push(this.lastText);
            this.redoStack.clear();
            this.lastText = currentText;
        }
        if (keyCode == 90 && class_437.method_25441()) {
            if (class_437.method_25442()) {
                this.performRedo();
            } else {
                this.performUndo();
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public class_1269 onCharTyped(char chr, int modifiers) {
        if (!this.enabled || this.editor == null || this.editor.getTextWidget() == null) {
            return class_1269.field_5811;
        }
        String currentText = this.editor.getTextWidget().getText();
        if (!currentText.equals(this.lastText)) {
            this.undoStack.push(this.lastText);
            this.redoStack.clear();
            this.lastText = currentText;
        }
        return class_1269.field_5811;
    }

    @Override
    public void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void performUndo() {
        if (this.undoStack.size() > 1) {
            this.redoStack.push(this.undoStack.pop());
            String previousText = this.undoStack.peek();
            this.editor.getTextWidget().setText(previousText);
            this.lastText = previousText;
        }
    }

    private void performRedo() {
        if (!this.redoStack.isEmpty()) {
            String nextText = this.redoStack.pop();
            this.undoStack.push(nextText);
            this.editor.getTextWidget().setText(nextText);
            this.lastText = nextText;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

