package io.github.zhengzhengyiyi.gui.widget;

import io.github.zhengzhengyiyi.ConfigEditorClient;
import io.github.zhengzhengyiyi.config.ConfigManager;
import io.github.zhengzhengyiyi.util.*;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.lwjgl.glfw.GLFW;

import java.util.function.Consumer;

public class MultilineEditor extends class_339 {
    private final class_327 textRenderer;
    private String text = "";
//    private int yOffset = 0;
    private int scrollOffset = 0;
    private boolean editable = true;
    private Consumer<String> changedListener;
    private int cursorPosition = 0;
    private long lastCursorBlinkTime = 0;
    private boolean cursorVisible = true;
    private String filename = "";
    
    private int lastCursorX = 0;

    public MultilineEditor(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
        this.textRenderer = class_310.method_1551().field_1772;
        this.method_25365(false);
        System.out.println(lastCursorX);
        
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
        	editable = !ConfigManager.getConfig().readonly_mode;
        });
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) {
            return;
        }

        context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xFF000000);
        context.method_49601(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, 0xFFFFFFFF);

        String[] lines = this.text.split("\n", -1);
        int lineHeight = this.textRenderer.field_2000 + 2;
        int maxVisibleLines = this.field_22759 / lineHeight;

        for (int i = 0; i < lines.length; i++) {
            if (i >= this.scrollOffset && i < this.scrollOffset + maxVisibleLines) {
                int yPos = this.method_46427() + 4 + (i - this.scrollOffset) * lineHeight;
//                context.drawText(this.textRenderer, lines[i], this.getX() + 4, yPos, this.editable ? 0xFFFFFFFF : 0xFF777777, false);
                SyntaxHighlighter.drawHighlightedText(context, this.textRenderer, lines[i], this.method_46426() + 4, yPos, this.editable);
            }
        }

        for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.renderButton(context, mouseX, mouseY, delta);
        }

        if (this.method_25370() && this.editable) {
            long currentTime = class_156.method_648();
            if (currentTime - lastCursorBlinkTime > 500000000) {
                cursorVisible = !cursorVisible;
                lastCursorBlinkTime = currentTime;
            }
            if (cursorVisible) {
                int lineIndex = 0;
                int xPos = this.method_46426() + 4;
                int remaining = this.cursorPosition;
                for (int i = 0; i < lines.length; i++) {
                    if (remaining <= lines[i].length()) {
                        xPos += this.textRenderer.method_1727(lines[i].substring(0, remaining));
                        lineIndex = i;
                        break;
                    }
                    remaining -= (lines[i].length() + 1);
                }
                
                if (lineIndex >= this.scrollOffset && lineIndex < this.scrollOffset + maxVisibleLines) {
                    int yPos = this.method_46427() + 4 + (lineIndex - this.scrollOffset) * lineHeight;
                    context.method_25301(xPos, yPos - 1, yPos + this.textRenderer.field_2000 + 1, 0xFFFFFFFF);
                }
            }
        }

        if (lines.length > maxVisibleLines) {
            int scrollbarHeight = Math.max(20, (int)((float)this.field_22759 * (float)maxVisibleLines / (float)lines.length));
            int scrollbarY = this.method_46427() + (int)((float)(this.field_22759 - scrollbarHeight) * (float)this.scrollOffset / (float)(lines.length - maxVisibleLines));
            context.method_25294(this.method_46426() + this.field_22758 - 5, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0xFF555555);
            context.method_25294(this.method_46426() + this.field_22758 - 4, scrollbarY, this.method_46426() + this.field_22758 - 1, scrollbarY + scrollbarHeight, 0xFFBBBBBB);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && this.editable) {
            this.method_25365(true);
            
            int lineHeight = this.textRenderer.field_2000 + 2;
            int clickedY = (int)mouseY - (this.method_46427() + 4);
            int lineIndex = class_3532.method_15340(clickedY / lineHeight + this.scrollOffset, 0, this.text.split("\n", -1).length - 1);
            
            String[] lines = this.text.split("\n", -1);
            String line = lines[lineIndex];
            
            int clickedX = (int)mouseX - (this.method_46426() + 4);
            
            int charIndex = 0;
            for (int i = 1; i <= line.length(); i++) {
                if (this.textRenderer.method_1727(line.substring(0, i)) > clickedX) {
                    charIndex = i - 1;
                    break;
                }
                charIndex = i;
            }
            
            int newPosition = 0;
            for (int i = 0; i < lineIndex; i++) {
                newPosition += lines[i].length() + 1;
            }
            newPosition += charIndex;
            
            this.cursorPosition = class_3532.method_15340(newPosition, 0, this.text.length());
//            this.lastCursorX = this.textRenderer.getWidth(line.substring(0, charIndex));
            
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            	class_1269 result = entrypoint.onMouseDown((int)Math.round(mouseX), (int)Math.round(mouseY));
                if (result == class_1269.field_5814) {
                    return true;
                }
            }
            
            return true;
        } else {
            this.method_25365(false);
            return false;
        }
    }

//    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (!this.method_25405(mouseX, mouseY)) return false;
        
        int lineHeight = this.textRenderer.field_2000 + 2;
        int maxLines = this.text.split("\n", -1).length;
        int maxVisibleLines = this.field_22759 / lineHeight;
        
        int newScrollOffset = this.scrollOffset - (int)Math.signum(amount);
        this.scrollOffset = class_3532.method_15340(newScrollOffset, 0, Math.max(0, maxLines - maxVisibleLines));
        
        for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onMouseScroll();
        }
        
        return true;
    }
    
    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.mouseScrolled(mouseX, mouseY, verticalAmount);
    }

//    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        
        for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
        	class_1269 result = entrypoint.onType(keyCode, scanCode, modifiers);
            if (result == class_1269.field_5814) {
                return true;
            }
        }

        boolean controlDown = class_437.method_25441();
//        boolean shiftDown = Screen.hasShiftDown();

        if (controlDown) {
            if (keyCode == GLFW.GLFW_KEY_V) {
                pasteFromClipboard();
                return true;
            }
            if (keyCode == GLFW.GLFW_KEY_C) {
                copyToClipboard();
                return true;
            }
        }
        
        if (keyCode == GLFW.GLFW_KEY_LEFT) {
            this.cursorPosition = class_3532.method_15340(this.cursorPosition - 1, 0, this.text.length());
            updateCursorX();
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_RIGHT) {
            this.cursorPosition = class_3532.method_15340(this.cursorPosition + 1, 0, this.text.length());
            updateCursorX();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_HOME) {
            this.cursorPosition = getLineStart(this.cursorPosition);
            updateCursorX();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_END) {
            this.cursorPosition = getLineEnd(this.cursorPosition);
            updateCursorX();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_UP) {
            int lineStart = getLineStart(this.cursorPosition);
//            int lineEnd = getLineEnd(this.cursorPosition);
//            int currentLineLength = lineEnd - lineStart;
            int currentX = this.cursorPosition - lineStart;
            
            int prevLineEnd = lineStart > 0 ? getLineEnd(lineStart - 1) : -1;
            if (prevLineEnd != -1) {
                int prevLineStart = getLineStart(prevLineEnd);
                int prevLineLength = prevLineEnd - prevLineStart;
                int newX = Math.min(currentX, prevLineLength);
                this.cursorPosition = prevLineStart + newX;
            }
            updateCursorX();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        if (keyCode == GLFW.GLFW_KEY_DOWN) {
            int lineEnd = getLineEnd(this.cursorPosition);
//            int currentLineLength = lineEnd - getLineStart(this.cursorPosition);
            int currentX = this.cursorPosition - getLineStart(this.cursorPosition);
            
            int nextLineStart = lineEnd < this.text.length() ? lineEnd + 1 : -1;
            if (nextLineStart != -1) {
                int nextLineEnd = getLineEnd(nextLineStart);
                int nextLineLength = nextLineEnd - nextLineStart;
                int newX = Math.min(currentX, nextLineLength);
                this.cursorPosition = nextLineStart + newX;
            }
            updateCursorX();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }

        if (keyCode == GLFW.GLFW_KEY_BACKSPACE) {
            if (this.cursorPosition > 0) {
                this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                this.cursorPosition--;
                this.onTextChanged();
                updateCursorX();
            }
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }

        if (keyCode == GLFW.GLFW_KEY_DELETE) {
            if (this.cursorPosition < this.text.length()) {
                this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                this.onTextChanged();
                updateCursorX();
            }
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }
        
        if (keyCode == GLFW.GLFW_KEY_ENTER || keyCode == GLFW.GLFW_KEY_KP_ENTER) {
            this.text = this.text.substring(0, this.cursorPosition) + "\n" + this.text.substring(this.cursorPosition);
            this.cursorPosition++;
            this.onTextChanged();
            updateCursorX();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(keyCode, scanCode, modifiers);
            }
            return true;
        }

        return false;
    }

    @Override
    public boolean method_25400(char chr, int modifiers) {
        if (!this.method_25370() || !this.editable) {
            return false;
        }
        
        for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
        	class_1269 result = entrypoint.onCharTyped(chr, modifiers);
            if (result == class_1269.field_5814) {
                return true;
            }
        }
        
        if (chr >= 32 && chr != 127) {
            this.text = this.text.substring(0, this.cursorPosition) + chr + this.text.substring(this.cursorPosition);
            this.cursorPosition++;
            this.onTextChanged();
            updateCursorX();
            for (io.github.zhengzhengyiyi.api.ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
                entrypoint.onType(chr, 0, modifiers);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    public String getText() {
        return this.text;
    }
    
    public void setText(String text) {
        this.text = text;
        this.cursorPosition = class_3532.method_15340(this.cursorPosition, 0, this.text.length());
        this.onTextChanged();
        updateCursorX();
    }
    
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    private void onTextChanged() {
        if (this.changedListener != null) {
            this.changedListener.accept(this.text);
        }
    }
    
    private void updateCursorX() {
        int lineStart = getLineStart(this.cursorPosition);
        String currentLine = this.text.substring(lineStart, this.cursorPosition);
        this.lastCursorX = this.textRenderer.method_1727(currentLine);
    }

    private int getLineStart(int pos) {
        int start = this.text.lastIndexOf('\n', pos - 1) + 1;
        return start;
    }

    private int getLineEnd(int pos) {
        int end = this.text.indexOf('\n', pos);
        if (end == -1) {
            end = this.text.length();
        }
        return end;
    }

    private void copyToClipboard() {
        class_310.method_1551().field_1774.method_1455(this.text);
    }

    private void pasteFromClipboard() {
        String clipboardText = class_310.method_1551().field_1774.method_1460();
        if (clipboardText != null) {
            this.text = this.text.substring(0, this.cursorPosition) + clipboardText + this.text.substring(this.cursorPosition);
            this.cursorPosition += clipboardText.length();
            this.onTextChanged();
            updateCursorX();
        }
    }
    
    public void insertTextAtCursor(String text) {
        this.text = this.text.substring(0, this.cursorPosition) + text + this.text.substring(this.cursorPosition);
        this.cursorPosition += text.length();
        this.onTextChanged();
        updateCursorX();
    }
    
    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int position) {
        this.cursorPosition = class_3532.method_15340(position, 0, this.text.length());
        updateCursorX();
    }
    
    public void setFileName(String v) {
    	this.filename = v;
    }
    
    public String getFileName() {
    	return this.filename;
    }
}