package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.gui.EditorScreen;
import io.github.zhengzhengyiyi.api.*;
import org.lwjgl.glfw.GLFW;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1269;
import net.minecraft.class_437;

public class UndoRedoEntrypoint implements ApiEntrypoint {
    private boolean enabled = true;
    private EditorScreen editor;
    private Deque<String> undoStack = new ArrayDeque<>();
    private Deque<String> redoStack = new ArrayDeque<>();
    private String currentText = "";
    private boolean isUndoing = false;
    private boolean isRedoing = false;
    private static final int MAX_HISTORY = 100;

    @Override
    public void init() {
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
        resetStacks();
        if (editor.getTextWidget() != null) {
            currentText = editor.getTextWidget().getText();
            saveState();
        }
    }

    @Override
    public void onEditerClose(EditorScreen editor) {
        this.editor = null;
        resetStacks();
    }

    @Override
    public class_1269 onMouseDown(int x, int y) {
        return class_1269.field_5811;
    }

    @Override
    public void onMouseScroll() {
    }

    @Override
    public class_1269 onType(int keyCode, int scanCode, int modifiers) {
        if (!enabled || editor == null || editor.getTextWidget() == null) return class_1269.field_5811;

        if (keyCode == GLFW.GLFW_KEY_Z && class_437.method_25441()) {
            if (class_437.method_25442()) {
                performRedo();
            } else {
                performUndo();
            }
            return class_1269.field_5814;
        }
        
        if (keyCode == GLFW.GLFW_KEY_Y && class_437.method_25441()) {
            performRedo();
            return class_1269.field_5814;
        }

        checkTextChange();
        return class_1269.field_5811;
    }

    @Override
    public class_1269 onCharTyped(char chr, int modifiers) {
        if (!enabled || editor == null || editor.getTextWidget() == null) return class_1269.field_5811;
        
        checkTextChange();
        return class_1269.field_5811;
    }

    @Override
    public void renderButton(net.minecraft.class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void checkTextChange() {
        if (isUndoing || isRedoing) return;
        
        String newText = editor.getTextWidget().getText();
        if (!newText.equals(currentText)) {
            saveState();
            currentText = newText;
        }
    }

    private void saveState() {
        if (isUndoing || isRedoing) return;
        
        undoStack.push(currentText);
        if (undoStack.size() > MAX_HISTORY) {
            Deque<String> newStack = new ArrayDeque<>();
            int count = 0;
            for (String state : undoStack) {
                if (count++ < MAX_HISTORY) newStack.add(state);
            }
            undoStack = newStack;
        }
        redoStack.clear();
    }

    private void performUndo() {
        if (undoStack.size() <= 1 || isUndoing) return;
        
        isUndoing = true;
        redoStack.push(currentText);
        undoStack.pop();
        String previousText = undoStack.peek();
        editor.getTextWidget().setText(previousText);
        currentText = previousText;
        isUndoing = false;
    }

    private void performRedo() {
        if (redoStack.isEmpty() || isRedoing) return;
        
        isRedoing = true;
        String nextText = redoStack.pop();
        undoStack.push(nextText);
        editor.getTextWidget().setText(nextText);
        currentText = nextText;
        isRedoing = false;
    }

    private void resetStacks() {
        undoStack.clear();
        redoStack.clear();
        currentText = "";
    }

    public void clearHistory() {
        resetStacks();
    }

    public boolean canUndo() {
        return undoStack.size() > 1;
    }

    public boolean canRedo() {
        return !redoStack.isEmpty();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) resetStacks();
    }
}
