package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.gui.EditorScreen;
import io.github.zhengzhengyiyi.api.*;
import org.lwjgl.glfw.GLFW;
import java.util.Stack;
import net.minecraft.class_1269;
import net.minecraft.class_437;

public class UndoRedoEntrypoint implements ApiEntrypoint {
    private boolean enabled = true;
    private EditorScreen editor;
    private Stack<String> undoStack = new Stack<>();
    private Stack<String> redoStack = new Stack<>();
    private String lastText = "";

    @Override
    public void init() {
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
        if (editor.getTextWidget() != null) {
            lastText = editor.getTextWidget().getText();
            undoStack.push(lastText);
        }
    }

    @Override
    public void onEditerClose(EditorScreen editor) {
        this.editor = null;
        undoStack.clear();
        redoStack.clear();
    }

    @Override
    public class_1269 onMouseDown(int x, int y) {
    	return class_1269.field_5812;
    }

    @Override
    public void onMouseScroll() {
    }

    @Override
    public class_1269 onType(int keyCode, int scanCode, int modifiers) {
        if (!enabled || editor == null || editor.getTextWidget() == null) return class_1269.field_5811;

        String currentText = editor.getTextWidget().getText();
        
        if (!currentText.equals(lastText)) {
            undoStack.push(lastText);
            redoStack.clear();
            lastText = currentText;
        }

        if (keyCode == GLFW.GLFW_KEY_Z && class_437.method_25441()) {
            if (class_437.method_25442()) {
                performRedo();
            } else {
                performUndo();
            }
            return class_1269.field_5814;
        }
        
        return class_1269.field_5811;
    }

    @Override
    public class_1269 onCharTyped(char chr, int modifiers) {
        if (!enabled || editor == null || editor.getTextWidget() == null) return class_1269.field_5811;

        String currentText = editor.getTextWidget().getText();
        
        if (!currentText.equals(lastText)) {
            undoStack.push(lastText);
            redoStack.clear();
            lastText = currentText;
        }
        
        return class_1269.field_5811;
    }

    @Override
    public void renderButton(net.minecraft.class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void performUndo() {
        if (undoStack.size() > 1) {
            redoStack.push(undoStack.pop());
            String previousText = undoStack.peek();
            editor.getTextWidget().setText(previousText);
            lastText = previousText;
        }
    }

    private void performRedo() {
        if (!redoStack.isEmpty()) {
            String nextText = redoStack.pop();
            undoStack.push(nextText);
            editor.getTextWidget().setText(nextText);
            lastText = nextText;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}