package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.gui.*;
import io.github.zhengzhengyiyi.gui.widget.GeneralMultilineEditor;
import io.github.zhengzhengyiyi.gui.widget.MultilineEditor;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;

public class TextStatsEntrypoint implements ApiEntrypoint {
    private boolean enabled = true;
    private EditorScreen editor;
    private int statsX = 80;
    private int statsY = 15;

    @Override
    public void init() {}

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
        
        statsX = this.editor.field_22789 / 2 + 35;
        statsY = this.editor.field_22790 - 10;
    }

    @Override
    public void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
        if (!enabled || editor == null || editor.getTextWidget() == null) return;
        
        String text = "";
        class_339 textWidget = editor.getTextWidget();
        
//        String text = editor.getTextWidget().getText();
        if (textWidget instanceof MultilineEditor) {
    		text = ((MultilineEditor)textWidget).text;
        } else if (textWidget instanceof GeneralMultilineEditor) {
			text = ((GeneralMultilineEditor)textWidget).text;
		} else {
			LOGGER.error("can not find current text");
		}
        
        int charCount = text.length();
        int wordCount = text.trim().isEmpty() ? 0 : text.split("\\s+").length;
        int lineCount = text.isEmpty() ? 0 : text.split("\n").length;
        
        String stats = "letter: " + charCount + " | words: " + wordCount + " | Lines: " + lineCount;
        context.method_51433(class_310.method_1551().field_1772, stats, statsX, statsY, 0xFFFFFF00, false);
    }
}
