/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.github.zhengzhengyiyi.ConfigEditorClient;
import io.github.zhengzhengyiyi.api.ApiEntrypoint;
import io.github.zhengzhengyiyi.config.ConfigData;
import io.github.zhengzhengyiyi.config.ConfigManager;
import io.github.zhengzhengyiyi.gui.theme.ThemeManager;
import io.github.zhengzhengyiyi.gui.widget.MultilineEditor;
import io.github.zhengzhengyiyi.util.BackupHelper;
import io.github.zhengzhengyiyi.util.ConfigDiffEngine;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class EditorScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorScreen.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private List<Path> configFiles;
    private int selectedIndex = 0;
    private MultilineEditor multilineEditor;
    private boolean modified = false;
    private class_4185 saveButton;
    private class_4185 openFolderButton;
    private class_4185 backupButton;
    private String buffer = "";
    private class_342 searchField;
    private class_4185 searchNextButton;
    private class_4185 searchPrevButton;
    private class_4185 exitButton;
    private class_4185 diffButton;
    private boolean searchVisible = false;
    private ThemeManager themeManager;
    private class_4185 themeToggleButton;
    private int fileListScrollOffset = 0;
    private class_4185 scrollUpButton;
    private class_4185 scrollDownButton;
    private List<class_4185> fileButtonList;
    private boolean showDiffView = false;
    private List<ConfigDiffEngine.DiffLine> currentDiff = new ArrayList<ConfigDiffEngine.DiffLine>();
    private String originalText = "";

    public EditorScreen() {
        super((class_2561)class_2561.method_43471((String)"configeditor.title"));
    }

    protected void method_25426() {
        super.method_25426();
        this.themeManager = ThemeManager.getInstance();
        this.themeToggleButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)this.getThemeButtonText()), button -> this.toggleTheme()).method_46434(this.field_22789 - 350, 5, 45, 16).method_46431();
        this.method_37063((class_364)this.themeToggleButton);
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            this.configFiles = Files.list(configDir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).collect(Collectors.toList());
            LOGGER.info("Found {} config files", (Object)this.configFiles.size());
        }
        catch (Exception e) {
            this.configFiles = new ArrayList<Path>();
            LOGGER.error("Failed to list config files", (Throwable)e);
        }
        this.fileButtonList = new ArrayList<class_4185>();
        this.scrollUpButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> this.scrollUp()).method_46434(140, 25, 20, 20).method_46431();
        this.scrollDownButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2193"), button -> this.scrollDown()).method_46434(140, this.field_22790 - 45, 20, 20).method_46431();
        this.method_37063((class_364)this.scrollUpButton);
        this.method_37063((class_364)this.scrollDownButton);
        this.renderFileList();
        this.multilineEditor = new MultilineEditor(170, 20, this.field_22789 - 180, this.field_22790 - 60, (class_2561)class_2561.method_43471((String)"configeditor.editor"));
        this.multilineEditor.setChangedListener(text -> {
            if (!this.buffer.equals(text)) {
                this.modified = true;
                this.updateButtonStates();
            } else {
                this.modified = false;
            }
        });
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.save"), button -> this.saveFile()).method_46434(this.field_22789 - 170, this.field_22790 - 30, 80, 20).method_46431();
        this.backupButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.backup"), button -> BackupHelper.backupEntireConfigDirectory()).method_46434(0, 0, 70, 20).method_46431();
        this.openFolderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.openfolder"), button -> this.openConfigFolder()).method_46434(this.field_22789 - 80, this.field_22790 - 30, 70, 20).method_46431();
        this.exitButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.close"), button -> this.method_25419()).method_46434(0, this.field_22790 - 25, 80, 20).method_46431();
        this.diffButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Different"), button -> {
            if (!this.showDiffView) {
                this.originalText = this.multilineEditor.getText();
                this.currentDiff = ConfigDiffEngine.computeDiff(this.originalText, this.multilineEditor.getText());
            } else {
                this.currentDiff.clear();
            }
            this.showDiffView = !this.showDiffView;
        }).method_46434(this.field_22789 - 250, 5, 40, 16).method_46431();
        this.method_37063((class_364)this.diffButton);
        this.searchField = new class_342(this.field_22793, this.field_22789 - 250, 5, 120, 16, (class_2561)class_2561.method_43471((String)"configeditor.search.placeholder"));
        this.searchField.method_1862(false);
        this.searchNextButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.search.next"), button -> {
            if (this.multilineEditor != null) {
                this.multilineEditor.findNext();
            }
        }).method_46434(this.field_22789 - 125, 5, 50, 16).method_46431();
        this.searchNextButton.field_22764 = false;
        this.searchPrevButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.search.prev"), button -> {
            if (this.multilineEditor != null) {
                this.multilineEditor.findPrevious();
            }
        }).method_46434(this.field_22789 - 70, 5, 50, 16).method_46431();
        this.searchPrevButton.field_22764 = false;
        class_4185 searchButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"configeditor.button.search"), button -> this.toggleSearch()).method_46434(this.field_22789 - 300, 5, 45, 16).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.backupButton);
        this.method_37063((class_364)this.openFolderButton);
        this.method_37063((class_364)this.searchField);
        this.method_37063((class_364)this.searchNextButton);
        this.method_37063((class_364)this.searchPrevButton);
        this.method_37063((class_364)this.exitButton);
        this.method_37063((class_364)searchButton);
        this.method_37063((class_364)this.multilineEditor);
        this.method_48265((class_364)this.multilineEditor);
        if (!this.configFiles.isEmpty()) {
            this.loadFile(this.selectedIndex);
        } else {
            this.multilineEditor.setText("{}");
            this.multilineEditor.setEditable(false);
            LOGGER.warn("No config files found in config directory");
        }
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onEditerOpen(this);
        }
        this.updateButtonStates();
        this.updateScrollButtons();
    }

    private void renderFileList() {
        for (class_4185 button : this.fileButtonList) {
            this.method_37066((class_364)button);
        }
        this.fileButtonList.clear();
        int buttonY = 25;
        for (int i = this.fileListScrollOffset; i < this.configFiles.size() && i < this.fileListScrollOffset + 15; ++i) {
            int index = i;
            Path file = this.configFiles.get(i);
            String fileName = file.getFileName().toString();
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)(fileName.length() > 20 ? fileName.substring(0, 17) + "..." : fileName)), _button -> this.switchFile(index)).method_46434(10, buttonY, 130, 20).method_46431();
            this.method_37063((class_364)button);
            this.fileButtonList.add(button);
            buttonY += 23;
        }
    }

    private void scrollUp() {
        if (this.fileListScrollOffset > 0) {
            --this.fileListScrollOffset;
            this.renderFileList();
            this.updateScrollButtons();
        }
    }

    private void scrollDown() {
        if (this.fileListScrollOffset < this.configFiles.size() - 15) {
            ++this.fileListScrollOffset;
            this.renderFileList();
            this.updateScrollButtons();
        }
    }

    private void updateScrollButtons() {
        this.scrollUpButton.field_22763 = this.fileListScrollOffset > 0;
        this.scrollDownButton.field_22763 = this.fileListScrollOffset < this.configFiles.size() - 15;
    }

    private void updateButtonStates() {
        if (this.saveButton != null) {
            this.saveButton.field_22763 = this.modified && !this.configFiles.isEmpty();
        }
    }

    private void switchFile(int index) {
        this.loadFile(index);
    }

    private void loadFile(int index) {
        if (index < 0 || index >= this.configFiles.size()) {
            LOGGER.error("Invalid file index: {}", (Object)index);
            return;
        }
        this.selectedIndex = index;
        this.modified = false;
        Path file = this.configFiles.get(index);
        try {
            String content;
            this.buffer = content = Files.readString(file);
            JsonElement json = JsonParser.parseString((String)content);
            String formattedContent = GSON.toJson(json);
            this.multilineEditor.setText(formattedContent);
            LOGGER.info("Successfully loaded config file: {}", (Object)file.getFileName());
        }
        catch (Exception e) {
            String text = null;
            try {
                text = Files.readString(file);
            }
            catch (IOException ioexception) {
                LOGGER.error("tried to read file except IOException: ", (Object)ioexception.toString());
            }
            if (text == null) {
                LOGGER.error("Failed to load config file: {}", (Object)file.getFileName(), (Object)e);
                this.multilineEditor.setText("{}");
                this.multilineEditor.setEditable(false);
                this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.loadfailed"));
            }
            this.multilineEditor.setText(text);
        }
        this.updateButtonStates();
    }

    private void saveFile() {
        this.saveFileAsync(null);
    }

    private void saveFileAsync(Runnable callback) {
        if (this.configFiles.isEmpty()) {
            return;
        }
        Path file = this.configFiles.get(this.selectedIndex);
        String content = this.multilineEditor.getText();
        try {
            JsonParser.parseString((String)content);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Invalid JSON syntax in file: {}", (Object)file.getFileName());
            this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.invalidjson"));
            return;
        }
        new Thread(() -> {
            int retryCount = 0;
            int maxRetries = 3;
            while (retryCount <= 3) {
                try {
                    block13: {
                        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                            FileLock lock;
                            block14: {
                                lock = channel.tryLock(0L, Long.MAX_VALUE, false);
                                if (lock == null) break block13;
                                try {
                                    Files.writeString(file, (CharSequence)content, StandardOpenOption.TRUNCATE_EXISTING);
                                    this.modified = false;
                                    LOGGER.info("Successfully saved config file: {}", (Object)file.getFileName());
                                    if (callback != null) {
                                        this.field_22787.execute(callback);
                                        break block14;
                                    }
                                    this.field_22787.execute(this::updateButtonStates);
                                }
                                catch (Throwable throwable) {
                                    lock.release();
                                    throw throwable;
                                }
                            }
                            lock.release();
                            return;
                        }
                    }
                    if (++retryCount > 3) continue;
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    if (++retryCount <= 3) continue;
                    LOGGER.error("Failed to save config file after {} attempts: {}", new Object[]{3, file.getFileName(), e});
                    this.field_22787.execute(() -> {
                        if (this.field_22787.field_1755 != null && this.field_22787.field_1755.equals((Object)this)) {
                            this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.savefailed"));
                        }
                    });
                }
            }
            this.field_22787.execute(() -> {
                if (this.field_22787.field_1755 != null && this.field_22787.field_1755.equals((Object)this)) {
                    this.showErrorPopup((class_2561)class_2561.method_43471((String)"configeditor.error.fileretryfailed"));
                }
            });
        }).start();
    }

    private void openConfigFolder() {
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir();
            LOGGER.info("Config folder location: {}", (Object)configDir);
            class_156.method_668().method_673(configDir.toUri());
        }
        catch (Exception e) {
            LOGGER.error("Failed to get config folder", (Throwable)e);
        }
    }

    private void showErrorPopup(class_2561 message) {
        this.field_22787.method_1507((class_437)new class_410(result -> this.field_22787.method_1507((class_437)this), (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), message));
    }

    public void showMessagePopup(class_2561 message) {
        this.field_22787.method_1507((class_437)new class_410(result -> {
            this.method_25419();
            this.field_22787.method_1507(null);
        }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), message));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (ConfigManager.getConfig().doRenderBackground) {
            context.method_25294(0, 0, this.field_22789, this.field_22790, this.themeManager.getBackgroundColor());
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (!this.configFiles.isEmpty()) {
            Object status = this.modified ? "* " + this.configFiles.get(this.selectedIndex).getFileName().toString() : this.configFiles.get(this.selectedIndex).getFileName().toString();
            context.method_51433(this.field_22793, (String)status, 170, 5, this.modified ? 0xFFFF00 : 0xFFFFFF, false);
        }
        this.renderDiffPanel(context, mouseX, mouseY);
    }

    public boolean method_25422() {
        if (this.modified) {
            class_410 confirmScreen = new class_410(result -> {
                if (result) {
                    this.saveFileAsync(() -> {
                        this.method_25419();
                        this.field_22787.method_1507(null);
                    });
                } else {
                    this.method_25419();
                    this.field_22787.method_1507(null);
                }
            }, (class_2561)class_2561.method_43471((String)"configeditor.confirm.title"), (class_2561)class_2561.method_43471((String)"configeditor.confirm.unsavedclose"));
            this.field_22787.method_1507((class_437)confirmScreen);
            return false;
        }
        return true;
    }

    public MultilineEditor getTextWidget() {
        return this.multilineEditor;
    }

    private void toggleSearch() {
        if (this.multilineEditor == null) {
            return;
        }
        this.searchVisible = !this.searchVisible;
        this.searchField.method_1862(this.searchVisible);
        this.searchNextButton.field_22764 = this.searchVisible;
        this.searchPrevButton.field_22764 = this.searchVisible;
        if (this.searchVisible) {
            this.method_25395((class_364)this.searchField);
            String searchText = this.searchField.method_1882();
            if (searchText != null && !searchText.trim().isEmpty()) {
                this.multilineEditor.startSearch(searchText);
            }
        } else {
            this.multilineEditor.endSearch();
        }
    }

    public void method_25419() {
        super.method_25419();
        for (ApiEntrypoint entrypoint : ConfigEditorClient.ENTRYPOINTS) {
            entrypoint.onEditerClose(this);
        }
        LOGGER.info("Config editor closed");
    }

    public void method_25432() {
        super.method_25432();
        LOGGER.info("Config editor screen removed");
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 81 && EditorScreen.method_25441() && EditorScreen.method_25443()) {
            this.field_22787.method_1507(null);
            LOGGER.info("Config editor force closed by user shortcut");
            return true;
        }
        if (this.multilineEditor == null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.searchVisible) {
            if (keyCode == 257) {
                this.multilineEditor.startSearch(this.searchField.method_1882());
                return true;
            }
            if (keyCode == 256) {
                this.toggleSearch();
                return true;
            }
            if (keyCode == 292) {
                this.multilineEditor.findNext();
                return true;
            }
        }
        if (keyCode == 70 && EditorScreen.method_25441()) {
            this.toggleSearch();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void toggleTheme() {
        ConfigData config = ConfigManager.getConfig();
        switch (config.theme) {
            case DARK: {
                config.theme = ConfigData.ThemeMode.LIGHT;
                break;
            }
            case LIGHT: {
                config.theme = ConfigData.ThemeMode.AUTO;
                break;
            }
            case AUTO: {
                config.theme = ConfigData.ThemeMode.DARK;
            }
        }
        ConfigManager.save();
        this.themeToggleButton.method_25355((class_2561)class_2561.method_43471((String)this.getThemeButtonText()));
    }

    private String getThemeButtonText() {
        return switch (ConfigManager.getConfig().theme) {
            default -> throw new MatchException(null, null);
            case ConfigData.ThemeMode.DARK -> "configeditor.theme.dark";
            case ConfigData.ThemeMode.LIGHT -> "configeditor.theme.light";
            case ConfigData.ThemeMode.AUTO -> "configeditor.theme.auto";
        };
    }

    private void renderDiffPanel(class_332 context, int mouseX, int mouseY) {
        if (!this.showDiffView || this.currentDiff == null || this.currentDiff.isEmpty()) {
            return;
        }
        int panelWidth = 200;
        int panelHeight = 80;
        int x = this.field_22789 - panelWidth - 10;
        int y = this.field_22790 - panelHeight - 10;
        context.method_25294(x, y, x + panelWidth, y + panelHeight, -872415232);
        context.method_49601(x, y, panelWidth, panelHeight, -1);
        int startY = y + 5;
        context.method_51433(this.field_22793, "Change Summary", x + 5, startY, -256, false);
        int added = 0;
        int deleted = 0;
        int modified = 0;
        int unchanged = 0;
        for (ConfigDiffEngine.DiffLine line : this.currentDiff) {
            switch (line.type) {
                case ADDED: {
                    ++added;
                    break;
                }
                case DELETED: {
                    ++deleted;
                    break;
                }
                case MODIFIED: {
                    ++modified;
                    break;
                }
                case UNCHANGED: {
                    ++unchanged;
                }
            }
        }
        context.method_51433(this.field_22793, "Added: " + added, x + 10, startY += 12, -16711936, false);
        context.method_51433(this.field_22793, "Deleted: " + deleted, x + 10, startY += 10, -65536, false);
        context.method_51433(this.field_22793, "Modified: " + modified, x + 10, startY += 10, -256, false);
        context.method_51433(this.field_22793, "Total: " + this.currentDiff.size(), x + 10, startY += 10, -1, false);
        if (this.isMouseOverPanel(mouseX, mouseY, x, y, panelWidth, panelHeight)) {
            context.method_51433(this.field_22793, "Click to close", x + panelWidth - 60, y + panelHeight - 12, -7829249, false);
        }
    }

    private boolean isMouseOverPanel(int mouseX, int mouseY, int panelX, int panelY, int width, int height) {
        return mouseX >= panelX && mouseX <= panelX + width && mouseY >= panelY && mouseY <= panelY + height;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int panelHeight;
        int y;
        int panelWidth;
        int x;
        if (this.showDiffView && this.currentDiff != null && this.isMouseOverPanel((int)mouseX, (int)mouseY, x = this.field_22789 - (panelWidth = 200) - 10, y = this.field_22790 - (panelHeight = 80) - 10, panelWidth, panelHeight)) {
            this.showDiffView = false;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

