/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FileLockUtil {
    public static FileLockResult tryLockFile(Path filePath) {
        return FileLockUtil.tryLockFile(filePath, 3, 100L);
    }

    public static FileLockResult tryLockFile(Path filePath, int maxRetries, long retryInterval) {
        int attempt = 0;
        while (attempt <= maxRetries) {
            block6: {
                try {
                    FileChannel channel = FileChannel.open(filePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                    FileLock lock = channel.tryLock();
                    if (lock != null) {
                        return new FileLockResult(true, lock, channel, null);
                    }
                    channel.close();
                }
                catch (Exception e) {
                    if (attempt < maxRetries) break block6;
                    return new FileLockResult(false, null, null, e);
                }
            }
            if (++attempt > maxRetries) continue;
            try {
                Thread.sleep(retryInterval);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return new FileLockResult(false, null, null, ie);
            }
        }
        return new FileLockResult(false, null, null, new IOException("Max retries exceeded"));
    }

    public static void releaseLock(FileLockResult result) {
        if (result != null && result.lock != null) {
            try {
                result.lock.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (result != null && result.channel != null) {
            try {
                result.channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FileLockResult {
        public final boolean success;
        public final FileLock lock;
        public final FileChannel channel;
        public final Exception error;

        public FileLockResult(boolean success, FileLock lock, FileChannel channel, Exception error) {
            this.success = success;
            this.lock = lock;
            this.channel = channel;
            this.error = error;
        }
    }
}

