/*
 * Decompiled with CFR 0.152.
 */
package io.github.zhengzhengyiyi.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PerformanceMonitor {
    private static final ConcurrentHashMap<String, OperationStats> statsMap = new ConcurrentHashMap();
    private static final AtomicLong totalMemoryUsed = new AtomicLong(0L);
    private static final AtomicInteger activeOperations = new AtomicInteger(0);
    private static volatile boolean enabled = true;

    public static Timer start(String operationName) {
        return new Timer(operationName);
    }

    public static OperationStats getStats(String operationName) {
        return statsMap.get(operationName);
    }

    public static ConcurrentHashMap<String, OperationStats> getAllStats() {
        return new ConcurrentHashMap<String, OperationStats>(statsMap);
    }

    public static void reset() {
        statsMap.clear();
        totalMemoryUsed.set(0L);
        activeOperations.set(0);
    }

    public static void setEnabled(boolean isEnabled) {
        enabled = isEnabled;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static long getTotalMemoryUsed() {
        return totalMemoryUsed.get();
    }

    public static int getActiveOperations() {
        return activeOperations.get();
    }

    public static String getSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append("Performance Monitor Summary:\n");
        summary.append("Active Operations: ").append(activeOperations.get()).append("\n");
        summary.append("Total Memory Used: ").append(totalMemoryUsed.get() / 1024L / 1024L).append("MB\n");
        statsMap.forEach((name, stats) -> {
            if (stats.count.get() > 0L) {
                double avgTime = (double)stats.totalTime.get() / (double)stats.count.get() / 1000000.0;
                summary.append(String.format("%s: count=%d, avg=%.2fms, min=%.2fms, max=%.2fms, errors=%d\n", name, stats.count.get(), avgTime, (double)stats.minTime.get() / 1000000.0, (double)stats.maxTime.get() / 1000000.0, stats.errors.get()));
            }
        });
        return summary.toString();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Timer
    implements AutoCloseable {
        private final String operationName;
        private final long startTime;
        private final long startMemory;
        private boolean closed = false;

        public Timer(String operationName) {
            if (!enabled) {
                this.operationName = null;
                this.startTime = 0L;
                this.startMemory = 0L;
                return;
            }
            this.operationName = operationName;
            this.startTime = System.nanoTime();
            this.startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            activeOperations.incrementAndGet();
        }

        @Override
        public void close() {
            if (!enabled || this.closed || this.operationName == null) {
                return;
            }
            long endTime = System.nanoTime();
            long duration = endTime - this.startTime;
            long endMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long memoryUsed = endMemory - this.startMemory;
            OperationStats stats = statsMap.computeIfAbsent(this.operationName, k -> new OperationStats());
            stats.totalTime.addAndGet(duration);
            stats.count.incrementAndGet();
            stats.maxTime.updateAndGet(current -> Math.max(current, duration));
            stats.minTime.updateAndGet(current -> Math.min(current, duration));
            totalMemoryUsed.addAndGet(memoryUsed);
            activeOperations.decrementAndGet();
            this.closed = true;
        }

        public void recordError() {
            if (!enabled || this.closed || this.operationName == null) {
                return;
            }
            OperationStats stats = statsMap.get(this.operationName);
            if (stats != null) {
                stats.errors.incrementAndGet();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class OperationStats {
        public final AtomicLong totalTime = new AtomicLong(0L);
        public final AtomicLong count = new AtomicLong(0L);
        public final AtomicLong maxTime = new AtomicLong(0L);
        public final AtomicLong minTime = new AtomicLong(Long.MAX_VALUE);
        public final AtomicLong errors = new AtomicLong(0L);
    }
}

