package io.github.zhengzhengyiyi.api;

import io.github.zhengzhengyiyi.gui.EditorScreen;
import net.minecraft.class_332;

/**
 * The entry point for other mods to interact with the config editor.
 * This interface allows for extending the functionality of the editor
 * screen by listening to events and rendering custom content.
 */
public interface ApiEntrypoint {

    /**
     * Initializes the API entry point. This method is called by the config editor mod
     * during its initialization phase. It is the only required method to be implemented.
     */
    void init();

    /**
     * Called when the editor screen is opened.
     * @param editor The instance of the EditorScreen.
     */
    default void onEditerOpen(EditorScreen editor) {
        // Default empty implementation
    }

    /**
     * Called when the editor screen is closed.
     * @param editor The instance of the EditorScreen.
     */
    default void onEditerClose(EditorScreen editor) {
    }

    /**
     * Called when a mouse button is pressed on the screen.
     * @param x The x-coordinate of the mouse cursor.
     * @param y The y-coordinate of the mouse cursor.
     */
    default void onMouseDown(int x, int y) {
    }

    /**
     * Called when the mouse scroll wheel is used.
     */
    default void onMouseScroll() {
    }

    /**
     * Called when a key is typed on the keyboard.
     * @param keyCode The key code of the typed key.
     * @param scanCode The scan code of the typed key.
     * @param modifiers The keyboard modifiers pressed at the time of typing.
     */
    default void onType(int keyCode, int scanCode, int modifiers) {
    }

    /**
     * Called to render custom buttons or elements on the screen.
     * @param context The draw context used for rendering.
     * @param mouseX The x-coordinate of the mouse cursor.
     * @param mouseY The y-coordinate of the mouse cursor.
     * @param delta The partial ticks for smooth rendering.
     */
    default void renderButton(class_332 context, int mouseX, int mouseY, float delta) {
    }
}