package io.github.zhengzhengyiyi.addon;

import io.github.zhengzhengyiyi.gui.EditorScreen;
import io.github.zhengzhengyiyi.api.*;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1269;

/**
 * This class will handle if use type bracket or other bracket like charactors.
 * {@code
 * bracketPairs.put('(', ')');
 *      bracketPairs.put('[', ']');
 *      bracketPairs.put('{', '}');
 *      bracketPairs.put('"', '"');
 *      bracketPairs.put('\'', '\'');
 *      bracketPairs.put('`', '`');
 * }
 */
public class AutoBracketCompletionEntrypoint implements ApiEntrypoint {
    private boolean enabled = true;
    private EditorScreen editor;
    private final Map<Character, Character> bracketPairs = new HashMap<>();

    public AutoBracketCompletionEntrypoint() {
        initializeBracketPairs();
    }

    /**
     * 
     * nothing needs to init, leave as empty
     */
    @Override
    public void init() {
    }

    @Override
    public void onEditerOpen(EditorScreen editor) {
        this.editor = editor;
    }

    @Override
    public void onEditerClose(EditorScreen editor) {
        this.editor = null;
    }

    @Override
    public class_1269 onMouseDown(int x, int y) {
        return class_1269.field_5812;
    }

    @Override
    public void onMouseScroll() {
    }

    @Override
    public class_1269 onType(int keyCode, int scanCode, int modifiers) {
        return class_1269.field_5811;
    }

    @Override
    public class_1269 onCharTyped(char chr, int modifiers) {
        if (!enabled || editor == null || editor.getTextWidget() == null) {
            return class_1269.field_5811;
        }

        if (bracketPairs.containsKey(chr)) {
            handleBracketCompletion(chr);
            return class_1269.field_5814;
        }

        return class_1269.field_5811;
    }

    @Override
    public void renderButton(net.minecraft.class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void initializeBracketPairs() {
        bracketPairs.put('(', ')');
        bracketPairs.put('[', ']');
        bracketPairs.put('{', '}');
        bracketPairs.put('"', '"');
        bracketPairs.put('\'', '\'');
        bracketPairs.put('`', '`');
    }

    private void handleBracketCompletion(char openingChar) {
        char closingChar = bracketPairs.get(openingChar);
        String pair = String.valueOf(openingChar) + closingChar;
        
        editor.getTextWidget().insertTextAtCursor(pair);
        
        if (openingChar != closingChar) {
            int currentPos = editor.getTextWidget().getCursorPosition();
            editor.getTextWidget().setCursorPosition(currentPos - 1);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void toggleEnabled() {
        this.enabled = !this.enabled;
    }
}