/*
 * Decompiled with CFR 0.152.
 */
package com.blocklegend001.morenuggets.datagen;

import com.blocklegend001.morenuggets.items.ModItems;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ModRecipeProvider
extends RecipeProvider {
    private static final Map<Item, Supplier<Item>> MATERIAL_TO_NUGGET = Map.of(Items.REDSTONE, () -> (Item)ModItems.NUGGETS.get("redstone").get(), Items.CHARCOAL, () -> (Item)ModItems.NUGGETS.get("charcoal").get(), Items.COAL, () -> (Item)ModItems.NUGGETS.get("coal").get(), Items.DIAMOND, () -> (Item)ModItems.NUGGETS.get("diamond").get(), Items.NETHERITE_INGOT, () -> (Item)ModItems.NUGGETS.get("netherite").get(), Items.EMERALD, () -> (Item)ModItems.NUGGETS.get("emerald").get(), Items.LAPIS_LAZULI, () -> (Item)ModItems.NUGGETS.get("lapis").get(), Items.COPPER_INGOT, () -> (Item)ModItems.NUGGETS.get("copper").get());

    public ModRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
        super(provider, recipeOutput);
    }

    protected void buildRecipes() {
        MATERIAL_TO_NUGGET.forEach((material, nuggetSupplier) -> this.addNuggetRecipes((Item)material, (Item)nuggetSupplier.get(), this.output));
        this.addSmeltingRecipes(this.output);
    }

    private void addNuggetRecipes(Item material, Item nugget, RecipeOutput recipeOutput) {
        this.shapeless(RecipeCategory.MISC, (ItemLike)nugget, 9).requires((ItemLike)material).unlockedBy("has_" + Objects.requireNonNull(material.builtInRegistryHolder().key().location()).getPath(), this.has((ItemLike)material)).save(this.output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"morenuggets", (String)(Objects.requireNonNull(nugget.builtInRegistryHolder().key().location()).getPath() + "_from_" + Objects.requireNonNull(material.builtInRegistryHolder().key().location()).getPath()))));
        this.shaped(RecipeCategory.MISC, (ItemLike)material).pattern("NNN").pattern("NNN").pattern("NNN").define(Character.valueOf('N'), (ItemLike)nugget).unlockedBy("has_" + Objects.requireNonNull(nugget.builtInRegistryHolder().key().location()).getPath(), this.has((ItemLike)nugget)).save(this.output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"morenuggets", (String)(Objects.requireNonNull(material.builtInRegistryHolder().key().location()).getPath() + "_from_" + Objects.requireNonNull(nugget.builtInRegistryHolder().key().location()).getPath()))));
    }

    private void addSmeltingRecipes(RecipeOutput recipeOutput) {
        Map<Item, Set<Item>> nuggetToItems = Map.of((Item)ModItems.NUGGETS.get("diamond").get(), Set.of(Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS, Items.DIAMOND_SWORD, Items.DIAMOND_AXE, Items.DIAMOND_HOE, Items.DIAMOND_PICKAXE, Items.DIAMOND_SHOVEL), (Item)ModItems.NUGGETS.get("netherite").get(), Set.of(Items.NETHERITE_HELMET, Items.NETHERITE_CHESTPLATE, Items.NETHERITE_LEGGINGS, Items.NETHERITE_BOOTS, Items.NETHERITE_SWORD, Items.NETHERITE_AXE, Items.NETHERITE_HOE, Items.NETHERITE_PICKAXE, Items.NETHERITE_SHOVEL));
        nuggetToItems.forEach((nugget, items) -> items.forEach(item -> SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)item), (RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (float)1.0f, (int)100).unlockedBy("has_" + Objects.requireNonNull(item.builtInRegistryHolder().key().location()).getPath(), this.has((ItemLike)item)).save(this.output, String.valueOf(ResourceLocation.fromNamespaceAndPath((String)"morenuggets", (String)(Objects.requireNonNull(item.builtInRegistryHolder().key().location()).getPath() + "_to_" + Objects.requireNonNull(nugget.builtInRegistryHolder().key().location()).getPath()))))));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> providerCompletableFuture) {
            super(output, providerCompletableFuture);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new ModRecipeProvider(provider, recipeOutput);
        }

        public String getName() {
            return "Recipes";
        }
    }
}

