/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wurstclient.glass.test;

import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.wurstclient.glass.MoGlassBlocks;

public enum ItemNamesTest
{
	;
	
	public static void testItemNamesShowUpCorrectly()
	{
		System.out.println("Testing item names...");
		
		assertItemName("Glass Slab", new class_1799(MoGlassBlocks.GLASS_SLAB));
		assertItemName("Glass Stairs",
			new class_1799(MoGlassBlocks.GLASS_STAIRS));
		
		assertItemName("Tinted Glass Slab",
			new class_1799(MoGlassBlocks.TINTED_GLASS_SLAB));
		assertItemName("Tinted Glass Stairs",
			new class_1799(MoGlassBlocks.TINTED_GLASS_STAIRS));
		
		String[] colors = {"White", "Orange", "Magenta", "Light Blue", "Yellow",
			"Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue",
			"Brown", "Green", "Red", "Black"};
		for(int i = 0; i < colors.length; i++)
		{
			assertItemName(colors[i] + " Stained Glass Slab",
				new class_1799(MoGlassBlocks.STAINED_GLASS_SLABS.get(i)));
			assertItemName(colors[i] + " Stained Glass Stairs",
				new class_1799(MoGlassBlocks.STAINED_GLASS_STAIRS.get(i)));
		}
	}
	
	private static void assertItemName(String expected, class_1799 stack)
	{
		if(!expected.equals(class_1074.method_4662(stack.method_7964().getString())))
			throw new RuntimeException("Wrong item name: Expected <" + expected
				+ "> but got <" + stack.method_7964() + ">");
	}
}
