/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wurstclient.glass.test;

import static net.wurstclient.glass.test.WiModsTestHelper.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10291;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9696;
import net.wurstclient.glass.MoGlassBlocks;

public enum RecipesTest
{
	;
	
	public static void testRecipesWork()
	{
		System.out.println("Testing crafting/stonecutting recipes...");
		
		// normal glass
		testRecipesForGlassType(class_2246.field_10033, MoGlassBlocks.GLASS_SLAB,
			MoGlassBlocks.GLASS_STAIRS);
		
		// tinted glass
		testRecipesForGlassType(class_2246.field_27115,
			MoGlassBlocks.TINTED_GLASS_SLAB, MoGlassBlocks.TINTED_GLASS_STAIRS);
		
		// stained glass
		for(class_1767 color : class_1767.values())
		{
			class_2248 block = getStainedGlassBlock(color);
			class_2248 slab = MoGlassBlocks.STAINED_GLASS_SLABS.get(color.ordinal());
			class_2248 stairs =
				MoGlassBlocks.STAINED_GLASS_STAIRS.get(color.ordinal());
			testRecipesForGlassType(block, slab, stairs);
		}
	}
	
	private static void testRecipesForGlassType(class_1935 input,
		class_1935 slabOutput, class_1935 stairsOutput)
	{
		// slab crafting
		assertCraftingRecipe(new class_1799[][]{
			{new class_1799(input), new class_1799(input), new class_1799(input)}},
			new class_1799(slabOutput, 6));
		
		// stairs crafting
		assertCraftingRecipe(new class_1799[][]{
			{new class_1799(input), null, null},
			{new class_1799(input), new class_1799(input), null},
			{new class_1799(input), new class_1799(input), new class_1799(input)}},
			new class_1799(stairsOutput, 4));
		
		// slab stonecutting
		assertStonecuttingRecipe(new class_1799(input),
			new class_1799(slabOutput, 2));
		
		// stairs stonecutting
		assertStonecuttingRecipe(new class_1799(input),
			new class_1799(stairsOutput, 1));
	}
	
	private static void assertCraftingRecipe(class_1799[][] inputGrid,
		class_1799 expectedResult)
	{
		int width = inputGrid[0].length;
		int height = inputGrid.length;
		
		ArrayList<class_1799> stacks = new ArrayList<>();
		for(class_1799[] row : inputGrid)
			for(class_1799 item : row)
				stacks.add(item != null ? item : class_1799.field_8037);
			
		class_9694 input =
			class_9694.method_60505(width, height, stacks).comp_2795();
		Optional<class_8786<class_3955>> optional =
			submitAndGet(mc -> mc.method_1576().method_3772()
				.method_8132(class_3956.field_17545, input, mc.field_1687));
		
		if(!optional.isPresent())
			throw new RuntimeException(
				"No crafting recipe found for " + expectedResult);
		
		class_8786<class_3955> entry = optional.get();
		class_3955 recipe = entry.comp_1933();
		class_1799 result = submitAndGet(
			mc -> recipe.method_8116(input, mc.field_1687.method_30349()));
		
		if(!class_1799.method_7973(expectedResult, result))
			throw new RuntimeException("Wrong crafting result: Expected "
				+ expectedResult + " but got " + result);
	}
	
	private static void assertStonecuttingRecipe(class_1799 input,
		class_1799 expectedResult)
	{
		class_10291.class_10293<class_3975> recipeGroups =
			submitAndGet(mc -> mc.method_1576().method_3772()
				.method_64677().method_64714(input));
		
		List<class_3975> recipes = recipeGroups.comp_3255().stream()
			.map(group -> group.comp_3254().comp_3252()).filter(Optional::isPresent)
			.map(Optional::get).map(class_8786::comp_1933).toList();
		
		if(recipes.isEmpty())
			throw new RuntimeException(
				"No stonecutting recipes found for " + input);
		
		List<class_1799> results = submitAndGet(mc -> recipes.stream()
			.map(recipe -> recipe.method_59998(new class_9696(input),
				mc.field_1687.method_30349()))
			.toList());
		
		if(!results.stream()
			.anyMatch(stack -> class_1799.method_7973(stack, expectedResult)))
			throw new RuntimeException("No stonecutting recipe found for "
				+ input + " -> " + expectedResult
				+ ", only found recipes that result in " + String.join(", ",
					results.stream().map(class_1799::toString).toList()));
	}
	
	// As of 1.21.4, vanilla Minecraft doesn't seem to have a method like this.
	private static class_2248 getStainedGlassBlock(class_1767 color)
	{
		return switch(color)
		{
			case field_7952 -> class_2246.field_10087;
			case field_7946 -> class_2246.field_10227;
			case field_7958 -> class_2246.field_10574;
			case field_7951 -> class_2246.field_10271;
			case field_7947 -> class_2246.field_10049;
			case field_7961 -> class_2246.field_10157;
			case field_7954 -> class_2246.field_10317;
			case field_7944 -> class_2246.field_10555;
			case field_7967 -> class_2246.field_9996;
			case field_7955 -> class_2246.field_10248;
			case field_7945 -> class_2246.field_10399;
			case field_7966 -> class_2246.field_10060;
			case field_7957 -> class_2246.field_10073;
			case field_7942 -> class_2246.field_10357;
			case field_7964 -> class_2246.field_10272;
			case field_7963 -> class_2246.field_9997;
		};
	}
}
