/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass.test;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.wurstclient.glass.MoGlassBlocks;
import net.wurstclient.glass.test.WiModsTestHelper;

public final class LootTableTest
extends Enum<LootTableTest> {
    private static final /* synthetic */ LootTableTest[] $VALUES;

    public static LootTableTest[] values() {
        return (LootTableTest[])$VALUES.clone();
    }

    public static LootTableTest valueOf(String name) {
        return Enum.valueOf(LootTableTest.class, name);
    }

    public static void testGlassPiecesDropCorrectItems() {
        System.out.println("Testing if glass pieces drop the correct items...");
        class_2338 playerPos = WiModsTestHelper.submitAndGet(mc -> mc.field_1724.method_24515());
        class_2338 startPos = playerPos.method_10069(-4, 0, 7);
        LinkedHashMap<class_2338, class_2680> blocks = LootTableTest.createTestRig(startPos);
        WiModsTestHelper.setBlocks(blocks);
        try {
            LootTableTest.testWithTool(false, blocks, startPos);
            LootTableTest.testWithTool(true, blocks, startPos);
            WiModsTestHelper.takeScreenshot("loot_table_test");
        }
        catch (TestFailureException e) {
            WiModsTestHelper.clearChat();
            e.showFailure(playerPos);
            throw e;
        }
        WiModsTestHelper.runChatCommand("fill ~-7 ~ ~-4 ~7 ~30 ~10 air");
        WiModsTestHelper.runChatCommand("clear");
        WiModsTestHelper.clearChat();
    }

    private static LinkedHashMap<class_2338, class_2680> createTestRig(class_2338 startPos) {
        LinkedHashMap<class_2338, class_2680> blocks = new LinkedHashMap<class_2338, class_2680>();
        for (class_1767 color : class_1767.values()) {
            int i = color.ordinal();
            class_2338 pos = startPos.method_10069(i % 3 * 3, i / 3, 0);
            LootTableTest.addGroup(blocks, pos, (class_2248)MoGlassBlocks.STAINED_GLASS_SLABS.get(i), (class_2248)MoGlassBlocks.STAINED_GLASS_STAIRS.get(i));
        }
        LootTableTest.addGroup(blocks, startPos.method_10069(3, 5, 0), MoGlassBlocks.GLASS_SLAB, MoGlassBlocks.GLASS_STAIRS);
        LootTableTest.addGroup(blocks, startPos.method_10069(6, 5, 0), MoGlassBlocks.TINTED_GLASS_SLAB, MoGlassBlocks.TINTED_GLASS_STAIRS);
        return blocks;
    }

    private static void addGroup(LinkedHashMap<class_2338, class_2680> blocks, class_2338 pos, class_2248 slab, class_2248 stairs) {
        blocks.put(pos, slab.method_9564());
        blocks.put(pos.method_10089(1), (class_2680)stairs.method_9564().method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11034));
        blocks.put(pos.method_10089(2), (class_2680)slab.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682));
    }

    private static void testWithTool(boolean silkTouch, Map<class_2338, class_2680> blocks, class_2338 startPos) {
        WiModsTestHelper.runChatCommand("clear");
        WiModsTestHelper.runChatCommand("give @s diamond_pickaxe" + (silkTouch ? "[enchantments={silk_touch:1}]" : ""));
        WiModsTestHelper.waitForWorldTicks(2);
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 9; ++col) {
                class_2338 pos = startPos.method_10069(col, row, 0);
                LootTableTest.testBlockDrops(pos, blocks.get(pos), silkTouch);
            }
        }
        WiModsTestHelper.clearChat();
    }

    private static void testBlockDrops(class_2338 pos, class_2680 state, boolean silkTouch) {
        List drops = WiModsTestHelper.submitAndGet(mc -> {
            class_3222 player = mc.method_1576().method_3760().method_14602(mc.field_1724.method_5667());
            class_3218 world = mc.method_1576().method_3847(class_1937.field_25179);
            return class_2248.method_9609((class_2680)state, (class_3218)world, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
        });
        String dropsString = drops.stream().map(class_1799::toString).reduce((a, b) -> a + ", " + b).orElse("no items");
        System.out.println(String.valueOf(state) + " " + (silkTouch ? "with" : "without") + " silk touch drops " + dropsString);
        class_1799 expectedStack = LootTableTest.getExpectedDrops(state, silkTouch);
        class_1799 firstDrop = drops.stream().findFirst().orElse(class_1799.field_8037);
        if (drops.size() <= 1 && class_1799.method_7973((class_1799)expectedStack, (class_1799)firstDrop)) {
            return;
        }
        throw new TestFailureException(state, silkTouch, expectedStack, dropsString);
    }

    private static class_1799 getExpectedDrops(class_2680 state, boolean silkTouch) {
        boolean tinted;
        boolean doubleSlab = state.method_28500((class_2769)class_2482.field_11501).orElse(null) == class_2771.field_12682;
        boolean bl = tinted = state.method_26204() == MoGlassBlocks.TINTED_GLASS_SLAB || state.method_26204() == MoGlassBlocks.TINTED_GLASS_STAIRS;
        if (silkTouch || tinted) {
            return new class_1799((class_1935)state.method_26204(), doubleSlab ? 2 : 1);
        }
        return class_1799.field_8037;
    }

    private static /* synthetic */ LootTableTest[] $values() {
        return new LootTableTest[0];
    }

    static {
        $VALUES = LootTableTest.$values();
    }

    private static class TestFailureException
    extends RuntimeException {
        private final class_2680 state;
        private final boolean silkTouch;

        public TestFailureException(class_2680 state, boolean silkTouch, class_1799 expectedStack, String actualDrops) {
            super(TestFailureException.formatErrorMessage(state, silkTouch, expectedStack, actualDrops));
            this.state = state;
            this.silkTouch = silkTouch;
        }

        private static String getBlockName(class_2680 state) {
            boolean doubleSlab = state.method_28500((class_2769)class_2482.field_11501).orElse(null) == class_2771.field_12682;
            class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
            return (doubleSlab ? "double_" : "") + id.toString().replace("mo_glass:", "");
        }

        private static String formatErrorMessage(class_2680 state, boolean silkTouch, class_1799 expectedStack, String actualDrops) {
            return TestFailureException.getBlockName(state) + (silkTouch ? " with" : " without") + " silk touch dropped " + actualDrops + " instead of " + String.valueOf(expectedStack);
        }

        public void showFailure(class_2338 playerPos) {
            class_2338 pos = playerPos.method_10077(4);
            WiModsTestHelper.setBlock(pos, this.state);
            WiModsTestHelper.runChatCommand("loot spawn " + pos.method_10263() + " " + (pos.method_10264() + 1) + " " + pos.method_10260() + " mine " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260() + " diamond_pickaxe" + (this.silkTouch ? "[enchantments={silk_touch:1}]" : ""));
            WiModsTestHelper.clearChat();
            WiModsTestHelper.takeScreenshot("FAILED_TEST_" + TestFailureException.getBlockName(this.state) + "_drops_wrong_items_" + (this.silkTouch ? "with" : "without") + "_silk_touch");
        }
    }
}

