/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.glass.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10291;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.wurstclient.glass.MoGlassBlocks;
import net.wurstclient.glass.test.WiModsTestHelper;

public final class RecipesTest
extends Enum<RecipesTest> {
    private static final /* synthetic */ RecipesTest[] $VALUES;

    public static RecipesTest[] values() {
        return (RecipesTest[])$VALUES.clone();
    }

    public static RecipesTest valueOf(String name) {
        return Enum.valueOf(RecipesTest.class, name);
    }

    public static void testRecipesWork() {
        System.out.println("Testing crafting/stonecutting recipes...");
        RecipesTest.testRecipesForGlassType((class_1935)class_2246.field_10033, (class_1935)MoGlassBlocks.GLASS_SLAB, (class_1935)MoGlassBlocks.GLASS_STAIRS);
        RecipesTest.testRecipesForGlassType((class_1935)class_2246.field_27115, (class_1935)MoGlassBlocks.TINTED_GLASS_SLAB, (class_1935)MoGlassBlocks.TINTED_GLASS_STAIRS);
        for (class_1767 color : class_1767.values()) {
            class_2248 block = RecipesTest.getStainedGlassBlock(color);
            class_2248 slab = (class_2248)MoGlassBlocks.STAINED_GLASS_SLABS.get(color.ordinal());
            class_2248 stairs = (class_2248)MoGlassBlocks.STAINED_GLASS_STAIRS.get(color.ordinal());
            RecipesTest.testRecipesForGlassType((class_1935)block, (class_1935)slab, (class_1935)stairs);
        }
    }

    private static void testRecipesForGlassType(class_1935 input, class_1935 slabOutput, class_1935 stairsOutput) {
        RecipesTest.assertCraftingRecipe(new class_1799[][]{{new class_1799(input), new class_1799(input), new class_1799(input)}}, new class_1799(slabOutput, 6));
        RecipesTest.assertCraftingRecipe(new class_1799[][]{{new class_1799(input), null, null}, {new class_1799(input), new class_1799(input), null}, {new class_1799(input), new class_1799(input), new class_1799(input)}}, new class_1799(stairsOutput, 4));
        RecipesTest.assertStonecuttingRecipe(new class_1799(input), new class_1799(slabOutput, 2));
        RecipesTest.assertStonecuttingRecipe(new class_1799(input), new class_1799(stairsOutput, 1));
    }

    private static void assertCraftingRecipe(class_1799[][] inputGrid, class_1799 expectedResult) {
        int width = inputGrid[0].length;
        int height = inputGrid.length;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_1799[][] class_1799Array = inputGrid;
        int n = class_1799Array.length;
        for (int i = 0; i < n; ++i) {
            class_1799[] row;
            for (class_1799 item : row = class_1799Array[i]) {
                stacks.add(item != null ? item : class_1799.field_8037);
            }
        }
        class_9694 input = class_9694.method_60505((int)width, (int)height, stacks).comp_2795();
        Optional optional = WiModsTestHelper.submitAndGet(mc -> mc.method_1576().method_3772().method_8132(class_3956.field_17545, (class_9695)input, (class_1937)mc.field_1687));
        if (!optional.isPresent()) {
            throw new RuntimeException("No crafting recipe found for " + String.valueOf(expectedResult));
        }
        class_8786 entry = (class_8786)optional.get();
        class_3955 recipe = (class_3955)entry.comp_1933();
        class_1799 result = WiModsTestHelper.submitAndGet(mc -> recipe.method_8116((class_9695)input, (class_7225.class_7874)mc.field_1687.method_30349()));
        if (!class_1799.method_7973((class_1799)expectedResult, (class_1799)result)) {
            throw new RuntimeException("Wrong crafting result: Expected " + String.valueOf(expectedResult) + " but got " + String.valueOf(result));
        }
    }

    private static void assertStonecuttingRecipe(class_1799 input, class_1799 expectedResult) {
        class_10291.class_10293 recipeGroups = WiModsTestHelper.submitAndGet(mc -> mc.method_1576().method_3772().method_64677().method_64714(input));
        List<class_3975> recipes = recipeGroups.comp_3255().stream().map(group -> group.comp_3254().comp_3252()).filter(Optional::isPresent).map(Optional::get).map(class_8786::comp_1933).toList();
        if (recipes.isEmpty()) {
            throw new RuntimeException("No stonecutting recipes found for " + String.valueOf(input));
        }
        List results = WiModsTestHelper.submitAndGet(mc -> recipes.stream().map(recipe -> recipe.method_59998(new class_9696(input), (class_7225.class_7874)mc.field_1687.method_30349())).toList());
        if (!results.stream().anyMatch(stack -> class_1799.method_7973((class_1799)stack, (class_1799)expectedResult))) {
            throw new RuntimeException("No stonecutting recipe found for " + String.valueOf(input) + " -> " + String.valueOf(expectedResult) + ", only found recipes that result in " + String.join((CharSequence)", ", results.stream().map(class_1799::toString).toList()));
        }
    }

    private static class_2248 getStainedGlassBlock(class_1767 color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case class_1767.field_7952 -> class_2246.field_10087;
            case class_1767.field_7946 -> class_2246.field_10227;
            case class_1767.field_7958 -> class_2246.field_10574;
            case class_1767.field_7951 -> class_2246.field_10271;
            case class_1767.field_7947 -> class_2246.field_10049;
            case class_1767.field_7961 -> class_2246.field_10157;
            case class_1767.field_7954 -> class_2246.field_10317;
            case class_1767.field_7944 -> class_2246.field_10555;
            case class_1767.field_7967 -> class_2246.field_9996;
            case class_1767.field_7955 -> class_2246.field_10248;
            case class_1767.field_7945 -> class_2246.field_10399;
            case class_1767.field_7966 -> class_2246.field_10060;
            case class_1767.field_7957 -> class_2246.field_10073;
            case class_1767.field_7942 -> class_2246.field_10357;
            case class_1767.field_7964 -> class_2246.field_10272;
            case class_1767.field_7963 -> class_2246.field_9997;
        };
    }

    private static /* synthetic */ RecipesTest[] $values() {
        return new RecipesTest[0];
    }

    static {
        $VALUES = RecipesTest.$values();
    }
}

