/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wimods.mo_glass.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import net.fabricmc.fabric.api.block.v1.FabricBlock;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.wimods.mo_glass.MoGlass;
import net.wimods.mo_glass.MoGlassTags;

@Mixin(class_2248.class)
public abstract class BlockMixin extends class_4970
	implements class_1935, FabricBlock
{
	private BlockMixin(MoGlass moGlass, class_2251 settings)
	{
		super(settings);
	}
	
	/**
	 * See {@link MoGlassTags#NON_OPAQUE_FOR_CULLING} for why this exists.
	 */
	@Inject(at = @At("HEAD"),
		method = "shouldRenderFace(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z",
		cancellable = true)
	private static void onShouldDrawSide(class_2680 state,
		class_2680 otherState, class_2350 direction,
		CallbackInfoReturnable<Boolean> cir)
	{
		if(!state.method_26164(ConventionalBlockTags.GLASS_BLOCKS_TINTED)
			&& !state.method_26164(MoGlassTags.NON_OPAQUE_FOR_CULLING)
			&& otherState.method_26164(MoGlassTags.NON_OPAQUE_FOR_CULLING))
			cir.setReturnValue(true);
	}
}
