/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wurstclient.glass.test;

import static net.wurstclient.glass.test.WiModsTestHelper.*;

import java.time.Duration;

import org.spongepowered.asm.mixin.MixinEnvironment;

import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_155;
import net.minecraft.class_442;
import net.minecraft.class_525;
import net.minecraft.class_526;
import net.minecraft.class_8032;

public final class MoGlassTestClient implements ClientModInitializer
{
	@Override
	public void onInitializeClient()
	{
		if(System.getProperty("mo_glass.e2eTest") == null)
			return;
		
		Thread.ofVirtual().name("Mo Glass End-to-End Test")
			.uncaughtExceptionHandler((t, e) -> {
				e.printStackTrace();
				System.exit(1);
			}).start(this::runTests);
	}
	
	private void runTests()
	{
		System.out.println("Starting Mo Glass End-to-End Test");
		waitForResourceLoading();
		disableInactivityFpsLimit();
		submitAndWait(mc -> mc.field_1690.method_42503().method_41748(5));
		
		if(submitAndGet(mc -> mc.field_1690.field_41785))
		{
			System.out.println("Onboarding is enabled. Waiting for it");
			waitForScreen(class_8032.class);
			System.out.println("Reached onboarding screen");
			clickButton("gui.continue");
		}
		
		waitForScreen(class_442.class);
		waitForTitleScreenFade();
		System.out.println("Reached title screen");
		takeScreenshot("title_screen", Duration.ZERO);
		
		System.out.println("Clicking singleplayer button");
		clickButton("menu.singleplayer");
		
		if(submitAndGet(mc -> !mc.method_1586().method_235().method_43421()))
		{
			System.out.println("World list is not empty. Waiting for it");
			waitForScreen(class_526.class);
			System.out.println("Reached select world screen");
			takeScreenshot("select_world_screen");
			clickButton("selectWorld.create");
		}
		
		waitForScreen(class_525.class);
		System.out.println("Reached create world screen");
		
		// Set MC version as world name
		setTextFieldText(0,
			"E2E Test " + class_155.method_16673().method_48019());
		// Select creative mode
		clickButton("selectWorld.gameMode");
		clickButton("selectWorld.gameMode");
		takeScreenshot("create_world_screen");
		
		System.out.println("Creating test world");
		clickButton("selectWorld.create");
		
		waitForWorldLoad();
		dismissTutorialToasts();
		waitForWorldTicks(200);
		runChatCommand("seed");
		System.out.println("Reached singleplayer world");
		takeScreenshot("in_game", Duration.ZERO);
		clearChat();
		
		System.out.println("Opening debug menu");
		toggleDebugHud();
		takeScreenshot("debug_menu");
		
		System.out.println("Closing debug menu");
		toggleDebugHud();
		
		System.out.println("Checking for broken mixins");
		MixinEnvironment.getCurrentEnvironment().audit();
		
		System.out.println("Opening inventory");
		openInventory();
		takeScreenshot("inventory");
		
		System.out.println("Closing inventory");
		closeScreen();
		
		// Build a test platform and clear out the space above it
		runChatCommand("fill ~-7 ~-5 ~-4 ~7 ~-1 ~10 stone");
		runChatCommand("fill ~-7 ~ ~-4 ~7 ~30 ~10 air");
		runChatCommand("kill @e[type=!player,distance=..15]");
		runChatCommand("kill @e[type=item]");
		
		// Clear inventory and chat before running tests
		runChatCommand("clear");
		clearChat();
		
		// Test Mo Glass features
		ItemNamesTest.testItemNamesShowUpCorrectly();
		RecipesTest.testRecipesWork();
		LootTableTest.testGlassPiecesDropCorrectItems();
		GlassPieceConnectionTest.testGlassPiecesConnectCorrectly();
		TintedGlassLightBlockingTest.testTintedGlassBlocksLightCorrectly();
		
		System.out.println("Opening game menu");
		openGameMenu();
		takeScreenshot("game_menu");
		
		System.out.println("Returning to title screen");
		clickButton("menu.returnToMenu");
		waitForScreen(class_442.class);
		
		System.out.println("Stopping the game");
		clickButton("menu.quit");
	}
}
