/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wimods.mo_glass;

import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public enum MoGlassBlocks
{
	;
	
	public static final class_2248 GLASS_SLAB = new GlassSlabBlock(
		class_4970.class_2251.method_9637().method_51368(class_2766.field_12645)
			.method_9632(0.3F).method_9626(class_2498.field_11537).method_22488()
			.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
			.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122));
	
	public static final class_2248 GLASS_STAIRS = new GlassStairsBlock(
		class_4970.class_2251.method_9637().method_51368(class_2766.field_12645)
			.method_9632(0.3F).method_9626(class_2498.field_11537).method_22488()
			.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
			.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122));
	
	public static final class_2248 TINTED_GLASS_SLAB = new TintedGlassSlabBlock(
		class_4970.class_2251.method_9630(class_2246.field_10033)
			.method_31710(class_3620.field_15978).method_22488()
			.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
			.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122));
	
	public static final class_2248 TINTED_GLASS_STAIRS = new TintedGlassStairsBlock(
		class_4970.class_2251.method_9630(class_2246.field_10033)
			.method_31710(class_3620.field_15978).method_22488()
			.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
			.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122));
	
	public static final StainedGlassSlabBlock WHITE_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7952);
	public static final StainedGlassSlabBlock ORANGE_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7946);
	public static final StainedGlassSlabBlock MAGENTA_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7958);
	public static final StainedGlassSlabBlock LIGHT_BLUE_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7951);
	public static final StainedGlassSlabBlock YELLOW_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7947);
	public static final StainedGlassSlabBlock LIME_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7961);
	public static final StainedGlassSlabBlock PINK_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7954);
	public static final StainedGlassSlabBlock GRAY_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7944);
	public static final StainedGlassSlabBlock LIGHT_GRAY_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7967);
	public static final StainedGlassSlabBlock CYAN_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7955);
	public static final StainedGlassSlabBlock PURPLE_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7945);
	public static final StainedGlassSlabBlock BLUE_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7966);
	public static final StainedGlassSlabBlock BROWN_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7957);
	public static final StainedGlassSlabBlock GREEN_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7942);
	public static final StainedGlassSlabBlock RED_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7964);
	public static final StainedGlassSlabBlock BLACK_STAINED_GLASS_SLAB =
		createStainedGlassSlab(class_1767.field_7963);
	
	public static final StainedGlassStairsBlock WHITE_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7952);
	public static final StainedGlassStairsBlock ORANGE_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7946);
	public static final StainedGlassStairsBlock MAGENTA_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7958);
	public static final StainedGlassStairsBlock LIGHT_BLUE_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7951);
	public static final StainedGlassStairsBlock YELLOW_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7947);
	public static final StainedGlassStairsBlock LIME_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7961);
	public static final StainedGlassStairsBlock PINK_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7954);
	public static final StainedGlassStairsBlock GRAY_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7944);
	public static final StainedGlassStairsBlock LIGHT_GRAY_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7967);
	public static final StainedGlassStairsBlock CYAN_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7955);
	public static final StainedGlassStairsBlock PURPLE_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7945);
	public static final StainedGlassStairsBlock BLUE_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7966);
	public static final StainedGlassStairsBlock BROWN_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7957);
	public static final StainedGlassStairsBlock GREEN_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7942);
	public static final StainedGlassStairsBlock RED_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7964);
	public static final StainedGlassStairsBlock BLACK_STAINED_GLASS_STAIRS =
		createStainedGlassStairs(class_1767.field_7963);
	
	public static final StainedGlassSlabBlock[] STAINED_GLASS_SLABS =
		{WHITE_STAINED_GLASS_SLAB, ORANGE_STAINED_GLASS_SLAB,
			MAGENTA_STAINED_GLASS_SLAB, LIGHT_BLUE_STAINED_GLASS_SLAB,
			YELLOW_STAINED_GLASS_SLAB, LIME_STAINED_GLASS_SLAB,
			PINK_STAINED_GLASS_SLAB, GRAY_STAINED_GLASS_SLAB,
			LIGHT_GRAY_STAINED_GLASS_SLAB, CYAN_STAINED_GLASS_SLAB,
			PURPLE_STAINED_GLASS_SLAB, BLUE_STAINED_GLASS_SLAB,
			BROWN_STAINED_GLASS_SLAB, GREEN_STAINED_GLASS_SLAB,
			RED_STAINED_GLASS_SLAB, BLACK_STAINED_GLASS_SLAB};
	
	public static final StainedGlassStairsBlock[] STAINED_GLASS_STAIRS =
		{WHITE_STAINED_GLASS_STAIRS, ORANGE_STAINED_GLASS_STAIRS,
			MAGENTA_STAINED_GLASS_STAIRS, LIGHT_BLUE_STAINED_GLASS_STAIRS,
			YELLOW_STAINED_GLASS_STAIRS, LIME_STAINED_GLASS_STAIRS,
			PINK_STAINED_GLASS_STAIRS, GRAY_STAINED_GLASS_STAIRS,
			LIGHT_GRAY_STAINED_GLASS_STAIRS, CYAN_STAINED_GLASS_STAIRS,
			PURPLE_STAINED_GLASS_STAIRS, BLUE_STAINED_GLASS_STAIRS,
			BROWN_STAINED_GLASS_STAIRS, GREEN_STAINED_GLASS_STAIRS,
			RED_STAINED_GLASS_STAIRS, BLACK_STAINED_GLASS_STAIRS};
	
	public static void initialize()
	{
		if(FabricLoader.getInstance().isModLoaded("translucent-glass"))
		{
			registerBlockTranslucent(GLASS_SLAB, "glass_slab");
			registerBlockTranslucent(GLASS_STAIRS, "glass_stairs");
			
		}else
		{
			registerBlockCutoutMipped(GLASS_SLAB, "glass_slab");
			registerBlockCutoutMipped(GLASS_STAIRS, "glass_stairs");
		}
		
		registerBlockTranslucent(TINTED_GLASS_SLAB, "tinted_glass_slab");
		registerBlockTranslucent(TINTED_GLASS_STAIRS, "tinted_glass_stairs");
		
		String[] colors = {"white", "orange", "magenta", "light_blue", "yellow",
			"lime", "pink", "gray", "light_gray", "cyan", "purple", "blue",
			"brown", "green", "red", "black"};
		
		for(int i = 0; i < 16; i++)
			registerBlockTranslucent(STAINED_GLASS_SLABS[i],
				colors[i] + "_stained_glass_slab");
		
		for(int i = 0; i < 16; i++)
			registerBlockTranslucent(STAINED_GLASS_STAIRS[i],
				colors[i] + "_stained_glass_stairs");
		
		ItemGroupEvents.modifyEntriesEvent(class_7706.field_41059)
			.register(content -> {
				
				// stairs
				content.addBefore(class_2246.field_10285, GLASS_STAIRS,
					TINTED_GLASS_STAIRS);
				content.addBefore(class_2246.field_10285, STAINED_GLASS_STAIRS);
				
				// slabs
				content.addBefore(class_2246.field_10285, GLASS_SLAB,
					TINTED_GLASS_SLAB);
				content.addBefore(class_2246.field_10285, STAINED_GLASS_SLABS);
			});
	}
	
	private static void registerBlockTranslucent(class_2248 block, String idPath)
	{
		registerBlock(block, idPath);
		
		if(MoGlass.INSTANCE.isClient())
			BlockRenderLayerMap.INSTANCE.putBlock(block,
				class_1921.method_23583());
	}
	
	private static void registerBlockCutoutMipped(class_2248 block, String idPath)
	{
		registerBlock(block, idPath);
		
		if(MoGlass.INSTANCE.isClient())
			BlockRenderLayerMap.INSTANCE.putBlock(block,
				class_1921.method_23579());
	}
	
	private static void registerBlock(class_2248 block, String idPath)
	{
		class_2960 identifier =
			class_2960.method_60655("mo_glass", idPath);
		class_2378.method_10230(class_7923.field_41175, identifier, block);
		
		class_1793 itemSettings = new class_1792.class_1793();
		class_1747 blockItem = new class_1747(block, itemSettings);
		class_2378.method_10230(class_7923.field_41178, identifier, blockItem);
	}
	
	private static StainedGlassSlabBlock createStainedGlassSlab(class_1767 color)
	{
		return new StainedGlassSlabBlock(color,
			class_4970.class_2251.method_9637().method_51517(color)
				.method_51368(class_2766.field_12645).method_9632(0.3F)
				.method_9626(class_2498.field_11537).method_22488()
				.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
				.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122));
	}
	
	private static StainedGlassStairsBlock createStainedGlassStairs(
		class_1767 color)
	{
		return new StainedGlassStairsBlock(color,
			class_4970.class_2251.method_9637().method_51517(color)
				.method_51368(class_2766.field_12645).method_9632(0.3F)
				.method_9626(class_2498.field_11537).method_22488()
				.method_26235(class_2246::method_26114).method_26236(class_2246::method_26122)
				.method_26243(class_2246::method_26122).method_26245(class_2246::method_26122));
	}
}
