/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wimods.mo_glass;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2506;
import net.minecraft.class_2510;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_3726;
import net.minecraft.class_4275;

public final class StainedGlassSlabBlock extends class_2482
	implements class_4275
{
	private final class_1767 color;
	
	public StainedGlassSlabBlock(class_1767 color, class_2251 settings)
	{
		super(settings);
		this.color = color;
	}
	
	@Override
	@Environment(EnvType.CLIENT)
	public boolean method_9522(class_2680 state, class_2680 stateFrom,
		class_2350 direction)
	{
		class_2248 blockFrom = stateFrom.method_26204();
		
		if(blockFrom instanceof class_2506
			&& ((class_2506)blockFrom).method_10622() == color)
			return true;
		
		if(blockFrom == this)
			if(isInvisibleToGlassSlab(state, stateFrom, direction))
				return true;
			
		if(blockFrom instanceof StainedGlassStairsBlock
			&& ((StainedGlassStairsBlock)blockFrom).method_10622() == color)
			if(isInvisibleToGlassStairs(state, stateFrom, direction))
				return true;
			
		return super.method_9522(state, stateFrom, direction);
	}
	
	private boolean isInvisibleToGlassSlab(class_2680 state,
		class_2680 stateFrom, class_2350 direction)
	{
		class_2771 type = state.method_11654(class_2482.field_11501);
		class_2771 typeFrom = stateFrom.method_11654(class_2482.field_11501);
		
		switch(direction)
		{
			case field_11036:
			if(typeFrom != class_2771.field_12679 && type != class_2771.field_12681)
				return true;
			break;
			
			case field_11033:
			if(typeFrom != class_2771.field_12681 && type != class_2771.field_12679)
				return true;
			break;
			
			case field_11043:
			case field_11034:
			case field_11035:
			case field_11039:
			if(type == typeFrom || typeFrom == class_2771.field_12682)
				return true;
			break;
		}
		
		return false;
	}
	
	private boolean isInvisibleToGlassStairs(class_2680 state,
		class_2680 stateFrom, class_2350 direction)
	{
		class_2771 type = state.method_11654(class_2482.field_11501);
		class_2760 halfFrom = stateFrom.method_11654(class_2510.field_11572);
		class_2350 facingFrom = stateFrom.method_11654(class_2510.field_11571);
		class_2778 shapeFrom = stateFrom.method_11654(class_2510.field_11565);
		
		// up
		if(direction == class_2350.field_11036)
			if(halfFrom == class_2760.field_12617)
				return true;
			
		// down
		if(direction == class_2350.field_11033)
			if(halfFrom == class_2760.field_12619)
				return true;
			
		// other stairs rear
		if(facingFrom == direction.method_10153()
			&& shapeFrom != class_2778.field_12708
			&& shapeFrom != class_2778.field_12709)
			return true;
		
		// other curved stairs fully covered side
		if(facingFrom.method_10160() == direction
			&& shapeFrom == class_2778.field_12713)
			return true;
		if(facingFrom.method_10170() == direction
			&& shapeFrom == class_2778.field_12712)
			return true;
		
		// sides
		if(direction.method_10161() != -1)
		{
			if(type == class_2771.field_12681 && halfFrom == class_2760.field_12617)
				return true;
			
			if(type == class_2771.field_12679 && halfFrom == class_2760.field_12619)
				return true;
		}
		
		return false;
	}
	
	@Override
	public class_265 method_26159(class_2680 state, class_1922 world,
		class_2338 pos, class_3726 context)
	{
		return class_259.method_1073();
	}
	
	@Override
	@Environment(EnvType.CLIENT)
	public float method_9575(class_2680 state, class_1922 world,
		class_2338 pos)
	{
		return 1.0F;
	}
	
	@Override
	public boolean method_9579(class_2680 state, class_1922 world,
		class_2338 pos)
	{
		return true;
	}
	
	@Override
	public class_1767 method_10622()
	{
		return color;
	}
}
