/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wimods.mo_glass.mixin;

import org.spongepowered.asm.mixin.Mixin;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_8923;
import net.wimods.mo_glass.MoGlass;
import net.wimods.mo_glass.MoGlassBlocks;

@Mixin(class_8923.class)
public abstract class GlassBlockMixin extends class_2373
{
	private GlassBlockMixin(MoGlass moGlass, class_2251 settings)
	{
		super(settings);
	}
	
	@Override
	public boolean method_9522(class_2680 state, class_2680 stateFrom,
		class_2350 direction)
	{
		if(state.method_26204() == class_2246.field_10033)
		{
			if(stateFrom.method_26204() == MoGlassBlocks.GLASS_SLAB)
				if(isInvisibleToGlassSlab(state, stateFrom, direction))
					return true;
				
			if(stateFrom.method_26204() == MoGlassBlocks.GLASS_STAIRS)
				if(isInvisibleToGlassStairs(state, stateFrom, direction))
					return true;
		}
		
		return super.method_9522(state, stateFrom, direction);
	}
	
	private boolean isInvisibleToGlassSlab(class_2680 state,
		class_2680 stateFrom, class_2350 direction)
	{
		class_2771 typeFrom = stateFrom.method_11654(class_2482.field_11501);
		
		if(typeFrom == class_2771.field_12682)
			return true;
		
		if(direction == class_2350.field_11036)
			if(typeFrom != class_2771.field_12679)
				return true;
			
		if(direction == class_2350.field_11033)
			if(typeFrom != class_2771.field_12681)
				return true;
			
		return false;
	}
	
	private boolean isInvisibleToGlassStairs(class_2680 state,
		class_2680 stateFrom, class_2350 direction)
	{
		class_2760 halfFrom = stateFrom.method_11654(class_2510.field_11572);
		class_2350 facingFrom = stateFrom.method_11654(class_2510.field_11571);
		class_2778 shapeFrom = stateFrom.method_11654(class_2510.field_11565);
		
		// up
		if(direction == class_2350.field_11036)
			if(halfFrom == class_2760.field_12617)
				return true;
			
		// down
		if(direction == class_2350.field_11033)
			if(halfFrom == class_2760.field_12619)
				return true;
			
		// other stairs rear
		if(facingFrom == direction.method_10153()
			&& shapeFrom != class_2778.field_12708
			&& shapeFrom != class_2778.field_12709)
			return true;
		
		// other curved stairs fully covered side
		if(facingFrom.method_10160() == direction
			&& shapeFrom == class_2778.field_12713)
			return true;
		if(facingFrom.method_10170() == direction
			&& shapeFrom == class_2778.field_12712)
			return true;
		
		return false;
	}
}
