/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wurstclient.glass;

import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.wurstclient.glass.mixin.BlockMixin;

public enum MoGlassTags
{
	;
	
	/**
	 * Blocks in this tag need to be considered opaque for lighting
	 * calculations, but non-opaque for culling. This is necessary for tinted
	 * glass slabs and stairs to properly block light without letting you see
	 * through the world.
	 *
	 * <p>
	 * See {@link BlockMixin} for how I modified culling to make this work.
	 */
	public static final class_6862<class_2248> NON_OPAQUE_FOR_CULLING =
		createTag("non_opaque_for_culling");
	
	private static class_6862<class_2248> createTag(String idPath)
	{
		return class_6862.method_40092(class_7924.field_41254, class_2960.method_60655("mo_glass", idPath));
	}
}
