/*
 * Copyright (c) 2019-2025 Wurst-Imperium and contributors.
 *
 * This source code is subject to the terms of the GNU General Public
 * License, version 3. If a copy of the GPL was not distributed with this
 * file, You can obtain one at: https://www.gnu.org/licenses/gpl-3.0.txt
 */
package net.wurstclient.glass.test;

import static net.wurstclient.glass.test.WiModsTestHelper.*;

import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.wurstclient.glass.MoGlassBlocks;

public enum GlassPieceConnectionTest
{
	;
	
	public static void testGlassPiecesConnectCorrectly()
	{
		System.out.println("Testing if glass pieces connect correctly...");
		class_2338 pos = submitAndGet(mc -> mc.field_1724.method_24515());
		
		class_2680[][] blocksWithFullyCoveredNorthSide = {blocks(),
			slabs(class_2771.field_12682),
			stairs(class_2350.field_11043, class_2760.field_12617, class_2778.field_12710),
			stairs(class_2350.field_11043, class_2760.field_12619, class_2778.field_12710),
			stairs(class_2350.field_11043, class_2760.field_12617, class_2778.field_12712),
			stairs(class_2350.field_11034, class_2760.field_12617, class_2778.field_12712),
			stairs(class_2350.field_11034, class_2760.field_12619, class_2778.field_12712),
			stairs(class_2350.field_11043, class_2760.field_12619, class_2778.field_12713),
			stairs(class_2350.field_11043, class_2760.field_12617, class_2778.field_12713),
			stairs(class_2350.field_11039, class_2760.field_12617, class_2778.field_12713),
			stairs(class_2350.field_11043, class_2760.field_12619, class_2778.field_12712),
			stairs(class_2350.field_11039, class_2760.field_12619, class_2778.field_12713)};
		
		for(class_2680[] back : blocksWithFullyCoveredNorthSide)
		{
			test(pos, back, blocks(), false, false);
			test(pos, back, slabs(class_2771.field_12681), true, false);
			test(pos, back, slabs(class_2771.field_12679), true, false);
			test(pos, back, slabs(class_2771.field_12682), false, false);
			for(class_2350 dir : class_2350.class_2353.field_11062)
				for(class_2760 half : class_2760.values())
				{
					test(pos, back, stairs(dir, half, class_2778.field_12710),
						dir != class_2350.field_11035, false);
					test(pos, back, stairs(dir, half, class_2778.field_12712),
						dir != class_2350.field_11035 && dir != class_2350.field_11039, false);
					test(pos, back, stairs(dir, half, class_2778.field_12713),
						dir != class_2350.field_11035 && dir != class_2350.field_11034, false);
					test(pos, back, stairs(dir, half, class_2778.field_12708),
						true, false);
					test(pos, back, stairs(dir, half, class_2778.field_12709),
						true, false);
				}
		}
		
		class_2680[][] blocksWithBottomHalfCoveredNorthSide = {
			slabs(class_2771.field_12681),
			stairs(class_2350.field_11035, class_2760.field_12617, class_2778.field_12710),
			stairs(class_2350.field_11035, class_2760.field_12617, class_2778.field_12708),
			stairs(class_2350.field_11039, class_2760.field_12617, class_2778.field_12708),
			stairs(class_2350.field_11034, class_2760.field_12617, class_2778.field_12709),
			stairs(class_2350.field_11035, class_2760.field_12617, class_2778.field_12709)};
		
		for(class_2680[] back : blocksWithBottomHalfCoveredNorthSide)
		{
			test(pos, back, slabs(class_2771.field_12681), false, false);
			test(pos, back, slabs(class_2771.field_12679), true, true);
			for(class_2760 half : class_2760.values())
			{
				test(pos, back,
					stairs(class_2350.field_11043, half, class_2778.field_12710),
					half == class_2760.field_12619, half == class_2760.field_12619);
				test(pos, back,
					stairs(class_2350.field_11034, half, class_2778.field_12710),
					half == class_2760.field_12619, true);
				test(pos, back,
					stairs(class_2350.field_11039, half, class_2778.field_12710),
					half == class_2760.field_12619, true);
				
				test(pos, back,
					stairs(class_2350.field_11043, half, class_2778.field_12712),
					half == class_2760.field_12619, true);
				test(pos, back,
					stairs(class_2350.field_11034, half, class_2778.field_12712),
					half == class_2760.field_12619, true);
				test(pos, back,
					stairs(class_2350.field_11043, half, class_2778.field_12713),
					half == class_2760.field_12619, true);
				test(pos, back,
					stairs(class_2350.field_11039, half, class_2778.field_12713),
					half == class_2760.field_12619, true);
				
				test(pos, back,
					stairs(class_2350.field_11043, half, class_2778.field_12708),
					half == class_2760.field_12619, half == class_2760.field_12619);
				test(pos, back,
					stairs(class_2350.field_11034, half, class_2778.field_12708),
					half == class_2760.field_12619, half == class_2760.field_12619);
				test(pos, back,
					stairs(class_2350.field_11035, half, class_2778.field_12708),
					half == class_2760.field_12619, true);
				test(pos, back,
					stairs(class_2350.field_11039, half, class_2778.field_12708),
					half == class_2760.field_12619, true);
				
				test(pos, back,
					stairs(class_2350.field_11043, half, class_2778.field_12709),
					half == class_2760.field_12619, half == class_2760.field_12619);
				test(pos, back,
					stairs(class_2350.field_11034, half, class_2778.field_12709),
					half == class_2760.field_12619, true);
				test(pos, back,
					stairs(class_2350.field_11035, half, class_2778.field_12709),
					half == class_2760.field_12619, true);
				test(pos, back,
					stairs(class_2350.field_11039, half, class_2778.field_12709),
					half == class_2760.field_12619, half == class_2760.field_12619);
			}
		}
		
		// Clean up
		runChatCommand("fill ~-7 ~ ~-4 ~7 ~30 ~10 air");
		clearChat();
	}
	
	private static void test(class_2338 startPos, class_2680[] backBlocks,
		class_2680[] frontBlocks, boolean drawFront, boolean drawBack)
	{
		record TestCase(class_2338 pos, class_2350 dir, boolean shouldDraw)
		{
			boolean test(LinkedHashMap<class_2338, class_2680> blocks)
			{
				return class_2248.method_9607(blocks.get(pos),
					blocks.get(pos.method_10093(dir)), dir) == shouldDraw;
			}
		}
		
		// Create test cases and map of blocks
		ArrayList<TestCase> testCases = new ArrayList<>();
		LinkedHashMap<class_2338, class_2680> blocks = new LinkedHashMap<>();
		int[] xOffsets = {2, 0, -2};
		for(int i = 0; i < 3; i++)
		{
			class_2338 backPos = startPos.method_10069(xOffsets[i], 0, 5);
			blocks.put(backPos, backBlocks[i]);
			testCases.add(new TestCase(backPos, class_2350.field_11043, drawFront));
			
			class_2338 frontPos = startPos.method_10069(xOffsets[i], 0, 4);
			blocks.put(frontPos, frontBlocks[i]);
			testCases.add(new TestCase(frontPos, class_2350.field_11035, drawBack));
		}
		
		// Run tests and return if successful
		TestCase failed =
			testCases.stream().filter(testCase -> !testCase.test(blocks))
				.findFirst().orElse(null);
		if(failed == null)
			return;
		
		// Build the test case and mark where it failed
		blocks.put(failed.pos().method_10086(2), class_2246.field_10058.method_9564());
		setBlocks(blocks);
		waitUntil("blocks are placed",
			mc -> blocks.entrySet().stream().allMatch(entry -> mc.field_1687
				.method_8320(entry.getKey()) == entry.getValue()));
		
		// Take a screenshot
		if(failed.dir() == class_2350.field_11035)
			runChatCommand("tp @s ~ ~ ~9 180 0");
		clearChat();
		takeScreenshot("FAILED_TEST_glass_connected_incorrectly",
			Duration.ofMillis(250));
		
		class_2680 state1 = blocks.get(failed.pos());
		class_2680 state2 = blocks.get(failed.pos().method_10093(failed.dir()));
		throw new RuntimeException("Block " + state1
			+ (failed.shouldDraw() ? " connected to " : " did not connect to ")
			+ state2);
	}
	
	private static class_2680[] blocks()
	{
		return new class_2680[]{class_2246.field_10033.method_9564(),
			class_2246.field_10087.method_9564(),
			class_2246.field_27115.method_9564()};
	}
	
	private static class_2680[] slabs(class_2771 type)
	{
		return new class_2680[]{
			MoGlassBlocks.GLASS_SLAB.method_9564().method_11657(class_2482.field_11501,
				type),
			MoGlassBlocks.STAINED_GLASS_SLABS.get(class_1767.field_7952.ordinal())
				.method_9564().method_11657(class_2482.field_11501, type),
			MoGlassBlocks.TINTED_GLASS_SLAB.method_9564()
				.method_11657(class_2482.field_11501, type)};
	}
	
	private static class_2680[] stairs(class_2350 facing, class_2760 half,
		class_2778 shape)
	{
		return new class_2680[]{
			MoGlassBlocks.GLASS_STAIRS.method_9564()
				.method_11657(class_2510.field_11571, facing).method_11657(class_2510.field_11572, half)
				.method_11657(class_2510.field_11565, shape),
			MoGlassBlocks.STAINED_GLASS_STAIRS.get(class_1767.field_7952.ordinal())
				.method_9564().method_11657(class_2510.field_11571, facing)
				.method_11657(class_2510.field_11572, half).method_11657(class_2510.field_11565, shape),
			MoGlassBlocks.TINTED_GLASS_STAIRS.method_9564()
				.method_11657(class_2510.field_11571, facing).method_11657(class_2510.field_11572, half)
				.method_11657(class_2510.field_11565, shape)};
	}
}
